<!--##
<NAME>Affiliate - Orders List</NAME>
<DESC>Affiliate Orders List page</DESC>
<SECTION>My Account||Store||Affiliates</SECTION>
##-->

<inp2:m_RequireLogin login_template="platform/login/register"/> <!--## LOGIN REQUIRED ##-->
<inp2:m_CheckSSL mode="required" condition="Require_SSL" /> <!--## CHECK IF SSL REQUIRED ##-->
<inp2:m_RequireAffiliate registration_template="in-commerce/my_account/affiliate/affiliate" /> <!--## MUST BE AN AFFILIATE ##-->

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:m_Phrase label="lu_title_AffiliateStatisticsOrders" no_editing="1"/>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/cart_indicator.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_if check="u_IsAffiliate">
				<inp2:m_RenderElement name="in-commerce/elements/side_boxes/affiliate_navigation.elm" design="blue_box"/>
			</inp2:m_if>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/top_seller_products.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/recent_products.elm" design="blue_box" data_exists="1"/>
		</div>
	</div>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="lu_title_MyAccount,lu_title_Affiliate,lu_title_AffiliateStatistics,lu_title_AffiliateStatisticsOrders" templates="platform/my_account/my_account,in-commerce/my_account/affiliate/affiliate,in-commerce/my_account/affiliate/affiliate_statistics,in-commerce/my_account/affiliate/affiliate_statistics_orders_list"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box" block_no_data="no_orders">

				<inp2:visits_InitList list_name="visitors_orders_list" types="myvisitororders" grid="visitsincommerce"/>

				<inp2:m_Capture to_var="header">
					<inp2:m_Phrase label="lu_title_AffiliateStatisticsOrders"/>
				</inp2:m_Capture>

				<inp2:m_include template="in-commerce/elements/affiliate_date_filter.elm" prefix="visits.incommerce" field="VisitDate" grid_name="visitsincommerce"/>

				<inp2:m_include template="in-commerce/elements/affiliates.elm"/>

				<table class="fullwidth">
					<inp2:m_RenderElement name="separator" colspan="4"/>
					<tr class="sub-section-header">
						<td><inp2:m_Phrase label="lu_col_Date"/></td>
						<td><inp2:m_Phrase label="lu_col_OrderNumber"/></td>
						<td><inp2:m_Phrase label="lu_col_OrderTotalAmount"/></td>
						<td><inp2:m_Phrase label="lu_col_OrderCommissionEarned"/></td>
					</tr>
					<inp2:m_RenderElement name="separator" colspan="5"/>
					<inp2:visits_PrintList list_name="visitors_orders_list" render_as="my_order_element"/>
					<inp2:visits_AffiliateOrderInfo list_name="visitors_orders_list" types="myvisitors" render_as="affiliate_orders_info" currency="selected" />
				</table>

				<inp2:m_include template="platform/elements/pagination.elm" prefix="visits" list_name="visitors_orders_list"/>
			</inp2:m_RenderElement>
		</div>
	</div>
</inp2:m_DefineElement>

<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>