<?php
/**
* @version	$Id: upgrades.php 15523 2012-08-20 15:40:39Z alex $
* @package	In-News
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$upgrade_class = 'InNewsUpgrades';

	/**
	 * Class, that holds all upgrade scripts for "In-News" module
	 *
	 */
	class InNewsUpgrades extends kUpgradeHelper {

		public function __construct()
		{
			parent::__construct();

			$this->dependencies = Array (
				'4.3.9' => Array ('Core' => '4.3.9'),
				'5.0.0' => Array ('Core' => '5.0.0'),
				'5.0.1' => Array ('Core' => '5.0.1'),
				'5.0.2-B1' => Array ('Core' => '5.0.2-B1'),
				'5.0.2-B2' => Array ('Core' => '5.0.2-B2'),
				'5.0.2-RC1' => Array ('Core' => '5.0.2-RC1'),
				'5.0.2' => Array ('Core' => '5.0.2'),
				'5.0.3-B1' => Array ('Core' => '5.0.3-B1'),
				'5.0.3-B2' => Array ('Core' => '5.0.3-B2'),
				'5.0.3-RC1' => Array ('Core' => '5.0.3-RC1'),
				'5.0.3' => Array ('Core' => '5.0.3'),
				'5.0.4-B1' => Array ('Core' => '5.0.4-B1'),
				'5.0.4-B2' => Array ('Core' => '5.0.4-B2'),
				'5.0.4' => Array ('Core' => '5.0.4'),
				'5.1.0-B1' => Array ('Core' => '5.1.0-B1'),
				'5.1.0-RC1' => Array ('Core' => '5.1.0-RC1'),
				'5.1.0' => Array ('Core' => '5.1.0'),
				'5.1.1-B1' => Array ('Core' => '5.1.1-B1'),
				'5.1.1-RC1' => Array ('Core' => '5.1.1-RC1'),
				'5.1.1' => Array ('Core' => '5.1.1'),
				'5.1.2-B1' => Array ('Core' => '5.1.2-B1'),
				'5.1.2-RC1' => Array ('Core' => '5.1.2-RC1'),
				'5.1.2' => Array ('Core' => '5.1.2'),
				'5.1.3-B1' => Array ('Core' => '5.1.3-B2'),
				'5.1.3-RC1' => Array ('Core' => '5.1.3-RC1'),
				'5.1.3-RC2' => Array ('Core' => '5.1.3-RC2'),
				'5.1.3' => Array ('Core' => '5.1.3'),
				'5.2.0-B1' => Array ('Core' => '5.2.0-B1'),
				'5.2.0-B2' => Array ('Core' => '5.2.0-B2'),
				'5.2.0-B3' => Array ('Core' => '5.2.0-B3'),
				'5.2.0-RC1' => Array ('Core' => '5.2.0-RC1'),
				'5.2.0' => Array ('Core' => '5.2.0'),
				'5.2.1-B1' => Array ('Core' => '5.2.1-B1'),
			);
		}

		/**
		 * Changes table structure, where multilingual fields of TEXT type are present
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_0($mode)
		{
			if ($mode == 'after') {
				$root_category = $this->Application->findModule('Name', 'In-News', 'RootCat');

				$sql = 'UPDATE ' . $this->Application->getUnitOption('c', 'TableName') . '
						SET UseMenuIconUrl = 1, MenuIconUrl = "in-news/img/menu_articles.gif"
						WHERE ' . $this->Application->getUnitOption('c', 'IDField') . ' = ' . $root_category;
				$this->Conn->Query($sql);

				$this->_updateDetailTemplate('n', 'innews/detail', 'in-news/designs/detail');
			}
		}

		/**
		 * Update to 5.0.1
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_1($mode)
		{
			if ($mode == 'after') {
				$this->_updateDetailTemplate('n', 'in-news/designs/detail', 'in-news/articles/article_detail');

				// delete old events
				$events_to_delete = Array ( 'NEWS.OWNER.MODIFY.PENDING', 'NEWS.OWNER.MODIFY' );

				$sql = 'SELECT EventId FROM ' . TABLE_PREFIX . 'Events
							WHERE Event IN ("' . implode('","', $events_to_delete) . '")';
				$event_ids = $this->Conn->GetCol($sql);

				if ($event_ids) {
					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'EmailMessage
								WHERE EventId IN (' . implode(',', $event_ids) . ')';
					$this->Conn->Query($sql);

					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Events
								WHERE EventId IN (' . implode(',', $event_ids) . ')';
					$this->Conn->Query($sql);

					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Phrase
								WHERE Phrase IN ("la_event_news.owner.modify", "la_event_news.owner.modify.pending")';
					$this->Conn->Query($sql);
				}
			}
		}
	}