<?php
/**
* @version	$Id: articles_config.php 14139 2011-01-09 14:55:45Z alex $
* @package	In-News
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'n',

					'ItemClass'			=>	Array ('class' => 'kCatDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kCatDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'ArticlesEventHandler', 'file' => 'articles_event_handler.php', 'require_classes' => Array ('kCatDBEventHandler'), 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'ArticlesTagProcessor', 'file' => 'articles_tag_processor.php', 'require_classes' => Array ('kCatDBTagProcessor'), 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'ConfigPriority' => 0,

					'RewritePriority' => 102,
					'RewriteListener' => 'ModRewriteHelper:CategoryItemRewriteListener',

					'Hooks' => Array (
						Array (
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => 'c',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '',
							'DoEvent' => 'OnUpdateCategoryCustomFields',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => 'cdata',
							'DoSpecial' => '*',
							'DoEvent' => 'OnDefineCustomFields',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '#file',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'rev',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'fav',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'rel',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'img',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'ci',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),
					),

					'CatalogItem' 			=>	true,
					'AdminTemplatePath'		=>	'articles',
					'AdminTemplatePrefix'	=>	'articles_',
					'SearchConfigPostfix' 	=>	'articles',

					'QueryString'		=>	Array (
												1	=>	'id',
												2	=>	'Page',
												3	=>	'PerPage',
												4	=>	'event',
												5	=>	'mode',
											),

					'RegularEvents'		=>	Array (
													'rss_category_update' =>	Array ('EventName' => 'OnUpdateRSSAtricles', 'RunInterval' => 0, 'Type' => reBEFORE),
											),

					'IDField'			=>	'NewsId',
 					'StatusField'		=>	Array ('Status'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'Title',		// field, used in bluebar when editing existing item
					'TitlePhrase'		=>	'la_Text_Article',	// phrase used to specify item type in relationship list

					'TitlePresets'		=>	Array (
	   												'default'	=>	Array (	'new_status_labels'		=> Array ('n' => '!la_title_AddingArticle!'),
																			'edit_status_labels'	=> Array ('n' => '!la_title_EditingArticle!'),
																			'new_titlefield'		=> Array ('n' => '!la_title_NewArticle!'),
																	),

													'articles_edit' => Array ('prefixes' => Array ('n'), 'format' => "#n_status# '#n_titlefield#' - !la_title_General!"),

													'articles_categories' =>Array ('prefixes' => Array ('n', 'n-ci_List'), 'format' => "#n_status# '#n_titlefield#' - !la_title_Categories!"),
													'articles_relations' =>	Array ('prefixes' => Array ('n'), 'format' => "#n_status# '#n_titlefield#' - !la_title_Relations!"),
													'articles_images'	=>	Array ('prefixes' => Array ('n'), 'format' => "#n_status# '#n_titlefield#' - !la_title_Images!"),
													'articles_files'	=>	Array ('prefixes' => Array ('n'), 'format' => "#n_status# '#n_titlefield#' - !la_title_Files!"),
													'articles_reviews'	=>	Array ('prefixes' => Array ('n'), 'format' => "#n_status# '#n_titlefield#' - !la_title_Reviews!"),
													'articles_custom'	=>	Array ('prefixes' => Array ('n'), 'format' => "#n_status# '#n_titlefield#' - !la_title_Custom!"),

													'images_edit'		=>	Array (	'prefixes'				=>	Array ('n', 'n-img'),
																					'new_status_labels'		=>	Array ('n-img' => '!la_title_Adding_Image!'),
																					'edit_status_labels'	=>	Array ('n-img' => '!la_title_Editing_Image!'),
																					'new_titlefield'		=>	Array ('n-img' => '!la_title_New_Image!'),
																					'format'				=>	"#n_status# '#n_titlefield#' - #n-img_status# '#n-img_titlefield#'",
																			),
													'file_edit' => Array (
														'prefixes' => Array ('n', 'n-file'),
														'new_status_labels' => Array ('n-file' => "!la_title_AddingFile!"),
														'edit_status_labels' => Array ('n-file' => '!la_title_EditingFile!'),
														'new_titlefield' => Array ('n-file' => '!la_title_NewFile!'),
														'format' => "#n_status# '#n_titlefield#' - #n-file_status# '#n-file_titlefield#'",
														),

													'reviews_edit'	=>	Array (		'prefixes'				=>	Array ('n', 'n-rev'),
																					'new_status_labels'		=>	Array ('n-rev' =>"!la_title_Adding_Review! '!la_title_New_Review!'"),
																					'edit_status_labels'	=>	Array ('n-rev' => '!la_title_Editing_Review!'),
																					'format'				=>	"#n_status# '#n_titlefield#' - #n-rev_status#",
																			),

													'relations_edit'	=>	Array (	'prefixes'				=>	Array ('n', 'n-rel'),
																					'new_status_labels'		=>	Array ('n-rel' =>"!la_title_Adding_Relationship! '!la_title_New_Relationship!'"),
																					'edit_status_labels'	=>	Array ('n-rel' => '!la_title_Editing_Relationship!'),
																					'format'				=>	"#n_status# '#n_titlefield#' - #n-rel_status#",
																			),

	   												'tree_in-news'	=>	Array ('format' => '!la_Text_Version! '.$this->Application->findModule('Name', 'In-News', 'Version')),

													'articles_export' => Array ('format' => '!la_title_ArticlesExport!'),

													'articles_import' => Array ('format' => '!la_title_ImportArticles!'),
   											),

   					'EditTabPresets' => Array (
   						'Default' => Array (
   							Array ('title' => 'la_tab_General', 't' => 'in-news/articles/articles_edit', 'priority' => 1),
   							Array ('title' => 'la_tab_Categories', 't' => 'in-news/articles/articles_categories', 'priority' => 2),
   							Array ('title' => 'la_tab_Relations', 't' => 'in-news/articles/articles_relations', 'priority' => 3),
   							Array ('title' => 'la_tab_Images', 't' => 'in-news/articles/articles_images', 'priority' => 4),
   							Array ('title' => 'la_tab_Files', 't' => 'in-news/articles/articles_files', 'priority' => 5),
   							Array ('title' => 'la_tab_Reviews', 't' => 'in-news/articles/articles_reviews', 'priority' => 6),
   							Array ('title' => 'la_tab_Custom', 't' => 'in-news/articles/articles_custom', 'priority' => 7),
   						),
   					),

   					'PermItemPrefix'	=>	'NEWS',

   					'PermTabText'		=>	'In-News',
   					'PermSection'		=>	Array ('main' => 'CATEGORY:in-news:articles_list', 'search' => 'in-news:configuration_search', 'custom' => 'in-news:configuration_custom'),

					'Sections'			=>	Array (
						/*'in-news'	=>	Array (
							'parent'		=>	'in-portal:root',
							'icon'			=>	'settings_in-newz',
							'label'			=>	'la_title_In-News',
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.2,
							'container'		=>	true,
							'type'			=>	stTREE,
						),*/

						'in-news:articles'	=>	Array (
							'parent'		=>	'in-portal:site',
							'icon'			=>	'articles',
							'label'			=>	'la_tab_Articles',
							'url'			=>	Array ('t' => 'catalog/advanced_view', 'anchor' => 'tab-n.showall', 'pass' => 'm'),
							'onclick'		=>	'setCatalogTab(\'n.showall\')',
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.3,
							'type'			=>	stTREE,
						),

						// article settings
						'in-news:setting_folder' => Array (
							'parent'		=>	'in-portal:system',
							'icon'			=>	'conf_news',
							'label'			=>	'la_title_In-News',
							'use_parent_header' => 1,
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.4,
							'container'		=>	true,
							'type'			=>	stTREE,
						),

						/*'in-news:innews_general'	=>	Array (
							'parent'		=>	'in-news:setting_folder',
							'icon'			=>	'core:settings_general',
							'label'			=>	'la_tab_GeneralSettings',
							'url'			=>	Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	0.9,
							'type'			=>	stTREE,
						),*/

						'in-news:configuration_output'	=>	Array (
							'parent'		=>	'in-news:setting_folder',
							'icon'			=>	'core:conf_output',
							'label'			=>	'la_tab_ConfigOutput',
							'url'			=>	Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	1,
							'type'			=>	stTREE,
						),

						'in-news:configuration_search'	=>	Array (
							'parent'		=>	'in-news:setting_folder',
							'icon'			=>	'core:conf_search',
							'label'			=>	'la_tab_ConfigSearch',
							'url'			=>	Array ('t' => 'config/config_search', 'module_key' => 'articles', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	2,
							'type'			=>	stTREE,
						),

						'in-news:configuration_custom'	=>	Array (
							'parent'		=>	'in-news:setting_folder',
							'icon'			=>	'core:conf_customfields',
							'label'			=>	'la_tab_ConfigCustom',
							'url'			=>	Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 2, 'pass_section' => true, 'pass' => 'm,cf'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),

					),

					'FilterMenu'		=>	Array (
						'Groups' => Array (
							Array ('mode' => 'AND', 'filters' => Array ('show_new'), 'type' => HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_hot'), 'type' => HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_pop'), 'type' => HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_pick'), 'type' => WHERE_FILTER),
						),
						'Filters' => Array (
							'show_new'	=>	Array ('label' => 'la_Text_New', 'on_sql' => '', 'off_sql' => '`IsNew` != 1'  ),
							'show_hot'	=>	Array ('label' => 'la_Text_Hot', 'on_sql' => '', 'off_sql' => '`IsHot` != 1'  ),
							'show_pop'	=>	Array ('label' => 'la_Text_Pop', 'on_sql' => '', 'off_sql' => '`IsPop` != 1'  ),
							'show_pick'	=>	Array ('label' => 'la_prompt_EditorsPick', 'on_sql' => '', 'off_sql' => '%1$s.`EditorsPick` != 1'  ),
						),
					),

					'CatalogSelectorName'	=>	'newslist',

					'ItemPropertyMappings'	=>	Array (
														'NewDays'		=>	'News_CatNewDays',	// number of days item to be NEW
														'MinPopVotes'	=>	'News_MinPopVotes',	// minimum number of votes for an item to be POP
														'MinPopRating'	=>	'News_MinPopRating',// minimum rating for an item to be POP
														'MaxHotNumber'	=>	'News_MaxHotNumber',// maximum number of HOT items

														'HotLimit'		=>	'News_HotLimit',	// variable name in inp_Cache table
														'ClickField'	=>	'Hits',				// item click count is stored here (in item table)
												),

					'ItemType'			=>	2,	// this is used when relation to product is added from in-portal and via-versa

					'ViewMenuPhrase'	=>	'la_title_Articles',
					'CatalogTabIcon' => 'in-news:icon16_articles.png',
					'UsePendingEditing'	=>	true, // item editing is controlled by NEWS.ADD/EDIT, NEWS.ADD/EDIT.PENDING permissions

					'StatisticsInfo'	=>	Array (
													'pending'	=>	Array (
																			'icon'		=>	'icon16_article_pending.gif',
																			'label'		=>	'la_Text_Articles',
																			'js_url' 	=>	'#url#',
																			'url'		=>	Array ('t' => 'catalog/advanced_view', 'SetTab' => 'n', 'pass' => 'm,n.showall', 'n.showall_event' => 'OnSetFilterPattern', 'n.showall_filters' => 'show_active=0,show_pending=1,show_disabled=0,show_new=1,show_hot=1,show_pop=1,show_pick=1'),
																			'status'	=>	STATUS_PENDING,
																	),
											),

					'TableName'			=>	TABLE_PREFIX.'News',

					'CalculatedFields' => Array (
						'' => Array (
							'UserName'		=>	'IF (ISNULL(u.Login), IF (%1$s.CreatedById = ' . USER_ROOT . ', "root", IF (%1$s.CreatedById = ' . USER_GUEST . ', "Guest", "n/a")), u.Login)',
							'CategoryId'	=>	TABLE_PREFIX.'%3$sCategoryItems.CategoryId',
							'Filename' => TABLE_PREFIX.'%3$sCategoryItems.Filename',
							'CategoryFilename' => TABLE_PREFIX.'Category.NamedParentPath',
							'PrimaryCat'	=> TABLE_PREFIX.'%3$sCategoryItems.PrimaryCat',
							'ParentPath' => TABLE_PREFIX.'Category.ParentPath',

							'AltName'		=>	'img.AltName',
							'SameImages'	=>	'img.SameImages',
							'LocalThumb'	=>	'img.LocalThumb',
							'ThumbPath'		=>	'img.ThumbPath',
							'ThumbUrl'		=>	'img.ThumbUrl',
							'LocalImage'	=>	'img.LocalImage',
							'LocalPath'		=>	'img.LocalPath',
							'FullUrl'		=>	'img.Url',
						),
					),

					'CacheModRewrite' => true,

					'ListSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Category ON '.TABLE_PREFIX.'Category.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'%3$sImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'PermCache perm ON perm.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.CreatedById = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'%3$sNewsCustomData cust ON %1$s.ResourceId = cust.ResourceId',
											), // key - special, value - list select sql

					'ListSortings'	=> 	Array (
												'' => Array (
															'ForcedSorting' => Array ('EditorsPick' => 'desc', 'Priority' => 'desc'),
															'Sorting' => Array ('Title' => 'asc'),
														)
										),
					'ItemSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Category ON '.TABLE_PREFIX.'Category.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'%3$sImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.CreatedById = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'%3$sNewsCustomData cust ON %1$s.ResourceId = cust.ResourceId'),

					'SubItems' => Array ('n-rev', 'n-ci', 'n-rel', 'n-img', 'n-cdata', 'n-fav', 'n-file'),

					'Fields' => Array (
			            'NewsId'			=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
			            'Title'				=>	Array ('type' => 'string', /*'formatter' => 'kMultiLanguage', */'not_null' => 1, 'required' => 1, 'default' => '', 'max_len' => 255),
			            'AutomaticFilename' =>	Array (
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
					    	'use_phrases' => 1, 'not_null' => 1, 'default' => 1,
						),
			            'Excerpt'			=>	Array ('type' => 'string', /*'formatter' => 'kMultiLanguage',*/ 'default' => null),
			            'Author'			=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			            'Body'				=>	Array ('type' => 'string', 'formatter' => 'kFormatter',/*'kMultiLanguage'*/ 'using_fck' => 1, 'required' => 1, 'default' => null),
			            'CreatedOn'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
			            'TextFormat'		=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'EndOn'				=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
			            'Hits'				=>	Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%d', 'not_null' => 1, 'default' => 0),
			            'CachedRating'		=>	Array ('type' => 'string', 'default' => 0),
			            'CachedVotesQty'	=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'CreatedById' => Array (
			            	'type' => 'int',
			            	'formatter' => 'kLEFTFormatter', 
			            	'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			            	'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'PortalUser 
			            					WHERE `%s` = \'%s\'',
			            	'left_key_field' => 'PortalUserId',
			            	'left_title_field' => 'Login',
							'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			            	'sample_value' => 'Guest', 'required' => 1, 'default' => NULL,
						),
			            'Priority'			=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Status'			=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 2,
						),
			            'EditorsPick'		=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
						),
			            'LeadStory'			=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
						),
			            'LeadCatStory'		=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
						),
			            'ResourceId'		=>	Array ('type' => 'int', 'default' => null),
			            'CachedReviewsQty'	=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'StartDate'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
			            'NewItem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
						'PopItem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
			            'HotItem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
			            'Archived'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 2 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
			            'Modified'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			            'ModifiedById'		=>	Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'default' => NULL),
			            'OrgId'				=>	Array ('type' => 'int', 'default' => null),
			            'MetaKeywords'			=>	Array ('type' => 'string', 'default' => null),
						'MetaDescription'		=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
					),

					'VirtualFields'	=> 	Array (
						'MoreCategories'		=>	Array ('type' => 'string', 'default' => ''),

						'UserName'				=>	Array ('type' => 'string', 'default' => ''),
						'CategoryId'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => 0),

						'cust_RssOriginalURL'	=>	Array ('type' => 'string', 'default' => ''),
						'cust_RssArticleCRC'	=>	Array ('type' => 'int', 'default' => 0),
						'Filename'				=>	Array ('type' => 'string', 'default' => ''),
						'CategoryFilename'		=>	Array ('type' => 'string', 'default' => ''),
						'PrimaryCat'			=>	Array ('type' => 'int', 'default' => 0),
						'CachedNavbar'			=>	Array ('type' => 'string', 'default' => ''),
						'ParentPath'			=>	Array ('type' => 'string', 'default' => ''),

						// for primary image
						'AltName'		=>	Array ('type' => 'string', 'default' => ''),
						'SameImages'	=>	Array ('type' => 'string', 'default' => ''),
						'LocalThumb'	=>	Array ('type' => 'string', 'default' => ''),
						'ThumbPath'		=>	Array ('type' => 'string', 'default' => ''),
						'ThumbUrl'		=>	Array ('type' => 'string', 'default' => ''),
						'LocalImage'	=>	Array ('type' => 'string', 'default' => ''),
						'LocalPath'		=>	Array ('type' => 'string', 'default' => ''),
						'FullUrl'		=>	Array ('type' => 'string', 'default' => ''),

						// export related fields: begin
						'CategoryId'	=>	Array ('type' => 'int', 'default' => 0),
						'ExportFormat'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CSV', /*2 => 'XML'*/), 'default' => 1),
						'ExportFilename'		=>	Array ('type' => 'string', 'default' => ''),
						'FieldsSeparatedBy'		=>	Array ('type' => 'string', 'default' => ', '),
						'FieldsEnclosedBy'		=>	Array ('type' => 'string', 'default' => '"'),
						'LineEndings'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'Windows', 2 => 'UNIX'), 'default' => 1),
						'LineEndingsInside'		=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CRLF', 2 => 'LF'), 'default' => 2),
						'IncludeFieldTitles'	=>	Array (
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
					    	'use_phrases' => 1, 'default' => 1,
						),
						'ExportColumns'			=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
						'AvailableColumns'		=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
						'CategoryFormat'		=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_MixedCategoryPath', 2 => 'la_SeparatedCategoryPath'), 'use_phrases' => 1, 'default' => 1),
						'CategorySeparator'		=>	Array ('type' => 'string', 'default' => ':'),
						'IsBaseCategory'		=>	Array (
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
					    	'use_phrases' => 1, 'default' => 0,
						),
						// export related fields: end

						// import related fields: begin
						'FieldTitles'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Automatic', 2 => 'la_Manual'), 'use_phrases' => 1, 'default' => 1),
						'ImportSource'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Upload', 2 => 'la_Local'), 'use_phrases' => 1, 'default' => 2),
						'ImportFilename'		=>	Array ('type' => 'string', 'formatter' => 'kUploadFormatter', 'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => EXPORT_BASE_PATH . '/', 'default' => ''),
						'ImportLocalFilename'	=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'default' => ''),
						'CheckDuplicatesMethod'	=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_IDField', 2 => 'la_OtherFields'), 'use_phrases' => 1, 'default' => 1),
						'ReplaceDuplicates'		=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 0),
						'DuplicateCheckFields'	=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array ('Title' => 'TITLE'), 'default' => '|Title|'),
						'SkipFirstRow'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 1),
						// import related fields: end
					),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array (
								0 => 'icon16_article_disabled.png',
								1 => 'icon16_article.png',
								2 => 'icon16_article_pending.png',
								'NEW' => 'icon16_article_new.png',
							),

							'Fields' => Array (
								'NewsId' =>	Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Title' => Array ('title' => 'la_col_Title', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'Priority' => Array('title'=>'la_col_Priority', 'filter_block' => 'grid_range_filter', 'width' => 65),
								'UserName' => Array ('title' => 'la_col_Author', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'LeadStory' => Array ('title' => 'la_col_LeadStory', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
								'LeadCatStory' => Array ('title' => 'la_col_LeadCatStory', 'filter_block' => 'grid_options_filter', 'width' => 85, ),
								'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 70, ),
								'CreatedOn' => Array ('title' => 'la_col_CreatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'StartDate' => Array ('title' => 'la_col_StartDate', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'EndOn' => Array ('title' => 'la_col_EndOn', 'data_block' => 'article_expire_td', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
							),
						),


						'Radio'	=>	Array (
							'Icons' => Array (
								0 => 'icon16_article_disabled.png',
								1 => 'icon16_article.png',
								2 => 'icon16_article_pending.png',
								-2 => 'icon16_article_pending.png', // pending DUPLICATE item
								'NEW' => 'icon16_article_new.gif',
							),

							'Selector' => 'radio',
							'Fields' => Array (
								'NewsId' =>	Array ('title' => 'la_col_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Title' => Array ('title' => 'la_col_Title', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'Priority' => Array('title'=>'la_col_Priority', 'filter_block' => 'grid_range_filter', 'width' => 65),
								'UserName' => Array ('title' => 'la_col_Author', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'LeadStory' => Array ('title' => 'la_col_LeadStory', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
								'LeadCatStory' => Array ('title' => 'la_col_LeadCatStory', 'filter_block' => 'grid_options_filter', 'width' => 85, ),
								'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 70, ),
								'CreatedOn' => Array ('title' => 'la_col_CreatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'StartDate' => Array ('title' => 'la_col_StartDate', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'EndOn' => Array ('title' => 'la_col_EndOn', 'data_block' => 'article_expire_td', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
							),
						),
					),

					'ConfigMapping' => 	Array (
												'PerPage'				=>	'Perpage_News',
												'ShortListPerPage'		=>	'Perpage_News_Short',
												'ForceEditorPick'		=>	'News_ShowPick',
												'DefaultSorting1Field'	=>	'News_SortField',
												'DefaultSorting2Field'	=>	'News_SortField2',
												'DefaultSorting1Dir'	=>	'News_SortOrder',
												'DefaultSorting2Dir'	=>	'News_SortOrder2',

												'RatingDelayValue'		=>	'News_RatingDelay_Value',
												'RatingDelayInterval'	=>	'News_RatingDelay_Interval',
										),
			);