CREATE TABLE News (
  NewsId int(11) NOT NULL AUTO_INCREMENT,
  Title varchar(255) NOT NULL DEFAULT '',
  l1_Title varchar(255) NOT NULL DEFAULT '',
  l2_Title varchar(255) NOT NULL DEFAULT '',
  l3_Title varchar(255) NOT NULL DEFAULT '',
  l4_Title varchar(255) NOT NULL DEFAULT '',
  l5_Title varchar(255) NOT NULL DEFAULT '',
  AutomaticFilename tinyint(3) unsigned NOT NULL DEFAULT '1',
  Excerpt text,
  l1_Excerpt text,
  l2_Excerpt text,
  l3_Excerpt text,
  l4_Excerpt text,
  l5_Excerpt text,
  Author varchar(255) NOT NULL DEFAULT '',
  Body text,
  l1_Body text,
  l2_Body text,
  l3_Body text,
  l4_Body text,
  l5_Body text,
  MetaKeywords varchar(255) DEFAULT NULL,
  MetaDescription text,
  CreatedOn int(11) DEFAULT NULL,
  TextFormat int(11) NOT NULL DEFAULT '0',
  EndOn int(11) DEFAULT NULL,
  Hits double(20,6) NOT NULL DEFAULT '0.000000',
  CachedRating varchar(10) DEFAULT '0',
  CachedVotesQty int(11) NOT NULL DEFAULT '0',
  CreatedById int(11) DEFAULT NULL,
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '2',
  EditorsPick tinyint(4) NOT NULL DEFAULT '0',
  LeadStory tinyint(4) NOT NULL DEFAULT '0',
  LeadCatStory tinyint(4) NOT NULL DEFAULT '0',
  ResourceId int(11) DEFAULT NULL,
  CachedReviewsQty int(11) NOT NULL DEFAULT '0',
  StartDate int(11) DEFAULT NULL,
  NewItem tinyint(4) NOT NULL DEFAULT '2',
  PopItem tinyint(4) NOT NULL DEFAULT '2',
  HotItem tinyint(4) NOT NULL DEFAULT '2',
  Archived int(11) NOT NULL DEFAULT '0',
  Modified int(11) DEFAULT NULL,
  ModifiedById int(11) DEFAULT NULL,
  OrgId int(11) DEFAULT NULL,
  PRIMARY KEY (NewsId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY Title (Title),
  KEY l1_Title (l1_Title),
  KEY l2_Title (l2_Title),
  KEY l3_Title (l3_Title),
  KEY l4_Title (l4_Title),
  KEY l5_Title (l5_Title),
  KEY Excerpt (Excerpt(5)),
  KEY l1_Excerpt (l1_Excerpt(5)),
  KEY l2_Excerpt (l2_Excerpt(5)),
  KEY l3_Excerpt (l3_Excerpt(5)),
  KEY l4_Excerpt (l4_Excerpt(5)),
  KEY l5_Excerpt (l5_Excerpt(5)),
  KEY Body (Body(5)),
  KEY l1_Body (l1_Body(5)),
  KEY l2_Body (l2_Body(5)),
  KEY l3_Body (l3_Body(5)),
  KEY l4_Body (l4_Body(5)),
  KEY l5_Body (l5_Body(5)),
  KEY CreatedOn (CreatedOn),
  KEY EndOn (EndOn),
  KEY Priority (Priority),
  KEY `Status` (`Status`),
  KEY EditorsPick (EditorsPick),
  KEY Hits (Hits),
  KEY Modified (Modified),
  KEY NewItem (NewItem),
  KEY PopItem (PopItem),
  KEY HotItem (HotItem),
  KEY StartDate (StartDate),
  KEY Archived (Archived)
);

CREATE TABLE NewsCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);