<?php
/**
* @version	$Id: upgrades.php 15866 2013-07-04 15:47:13Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	$upgrade_class = 'InBulletinUpgrades';

	/**
	 * Class, that holds all upgrade scripts for "In-Bulletin" module
	 *
	 */
	class InBulletinUpgrades extends kUpgradeHelper {

		public function __construct()
		{
			parent::__construct();

			$this->dependencies = Array (
				'4.3.9' => Array ('Core' => '4.3.9'),
				'5.0.0' => Array ('Core' => '5.0.0'),
				'5.0.1' => Array ('Core' => '5.0.1'),
				'5.0.2-B1' => Array ('Core' => '5.0.2-B1'),
				'5.0.2-B2' => Array ('Core' => '5.0.2-B2'),
				'5.0.2-RC1' => Array ('Core' => '5.0.2-RC1'),
				'5.0.2' => Array ('Core' => '5.0.2'),
				'5.0.3-B1' => Array ('Core' => '5.0.3-B1'),
				'5.0.3-B2' => Array ('Core' => '5.0.3-B2'),
				'5.0.3-RC1' => Array ('Core' => '5.0.3-RC1'),
				'5.0.3' => Array ('Core' => '5.0.3'),
				'5.0.4-B1' => Array ('Core' => '5.0.4-B1'),
				'5.0.4-B2' => Array ('Core' => '5.0.4-B2'),
				'5.0.4' => Array ('Core' => '5.0.4'),
				'5.1.0-B1' => Array ('Core' => '5.1.0-B1'),
				'5.1.0-B2' => Array ('Core' => '5.1.0-B2'),
				'5.1.0-RC1' => Array ('Core' => '5.1.0-RC1'),
				'5.1.0' => Array ('Core' => '5.1.0'),
				'5.1.1-B1' => Array ('Core' => '5.1.1-B1'),
				'5.1.1-B2' => Array ('Core' => '5.1.1-B2'),
				'5.1.1-RC1' => Array ('Core' => '5.1.1-RC1'),
				'5.1.1' => Array ('Core' => '5.1.1'),
				'5.1.2-B1' => Array ('Core' => '5.1.2-B1'),
				'5.1.2-RC1' => Array ('Core' => '5.1.2-RC1'),
				'5.1.2' => Array ('Core' => '5.1.2'),
				'5.1.3-B1' => Array ('Core' => '5.1.3-B1'),
				'5.1.3-B2' => Array ('Core' => '5.1.3-B2'),
				'5.1.3-RC1' => Array ('Core' => '5.1.3-RC1'),
				'5.1.3-RC2' => Array ('Core' => '5.1.3-RC2'),
				'5.1.3' => Array ('Core' => '5.1.3'),
				'5.2.0-B1' => Array ('Core' => '5.2.0-B1'),
				'5.2.0-B2' => Array ('Core' => '5.2.0-B2'),
				'5.2.0-B3' => Array ('Core' => '5.2.0-B3'),
				'5.2.0-RC1' => Array ('Core' => '5.2.0-RC1'),
				'5.2.0' => Array ('Core' => '5.2.0'),
				'5.2.1-B1' => Array ('Core' => '5.2.1-B1'),
				'5.2.1-B2' => Array ('Core' => '5.2.1-B2'),
				'5.2.1-RC1' => Array ('Core' => '5.2.1-RC1'),
			);
		}

		/**
		 * Changes table structure, where multilingual fields of TEXT type are present
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_0($mode)
		{
			if ($mode == 'after') {
				$root_category = $this->Application->findModule('Name', 'In-Bulletin', 'RootCat');

				$sql = 'UPDATE ' . $this->Application->getUnitOption('c', 'TableName') . '
						SET UseMenuIconUrl = 1, MenuIconUrl = "in-bulletin/img/menu_topics.gif"
						WHERE ' . $this->Application->getUnitOption('c', 'IDField') . ' = ' . $root_category;
				$this->Conn->Query($sql);

				$this->_updateDetailTemplate('bb', 'inbulletin/post_list', 'in-bulletin/designs/detail');
			}
		}

		/**
		 * Update to 5.0.1, update details template
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_1($mode)
		{
			if ($mode == 'after') {
				$this->_updateDetailTemplate('bb', 'in-bulletin/designs/detail', 'in-bulletin/topics/topic_detail');
			}
		}
	}