<?php
/**
* @version	$Id: poll_comments_config.php 15559 2012-10-09 16:04:08Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array ( 'Prefix' => 'poll-comment',

		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'PollCommentEventHandler', 'file' => 'poll_comment_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
		),
		'IDField' => 'CommentId',
		'TableName' => TABLE_PREFIX . 'PollsComments',

		'ParentPrefix' => 'poll',
		'ForeignKey'  => 'PollId',
		'ParentTableKey' => 'PollId',
		'AutoDelete' => true,
		'AutoClone' => true,

		'StatusField' =>	Array('Status'),

		// key - special, value - list select sql
		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'Users pu ON pu.PortalUserId = %1$s.CreatedById',
				),

		'ItemSQLs' => Array ('' => 'SELECT * FROM %s'),

		'ListSortings' => Array (
			'' => Array(
				'ForcedSorting' => Array('Priority' => 'desc'),
				'Sorting' => Array('CreatedOn' => 'desc'),
			)
		),

		'Fields' => Array (
		   	'CommentId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'PollId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'AnswerId' => Array ('type' => 'int', 'default' => NULL),
		    'CreatedById' => Array (
				'type' => 'int',
				'formatter'=>'kLEFTFormatter',
				'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
				'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
				'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE %s',
				'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD,
				'required' => 1, 'default' => NULL
			),
		    'GuestName' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		    'GuestEmail' => Array('type' => 'string', 'max_len' => 255, 'formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i', 'sample_value' => 'email@domain.com', 'not_null' => '1', 'default' => '', 'error_msgs' => Array('invalid_format'=>'!la_invalid_email!', 'unique'=>'!lu_email_already_exist!'),'required' => 0 ),
		    'CommentBody' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL, 'required' => 1),
		    'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
		    'UserIP' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		    'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Status' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Active', 0 => 'la_opt_Disabled', 2 => 'la_opt_Pending'), 'use_phrases' => 1, 'required' => 1, 'not_null' => 1, 'default' => 1),
		),

		'VirtualFields' => Array (
			'CommentedByUser' => Array('type' => 'string', 'default' => ''),
			'CommentedByEmail' => Array ('type' => 'string', 'default' => ''),
		),

		'CalculatedFields' => Array (
			'' => Array (
					'CommentedByUser' => 'IF( ISNULL(pu.Username), IF (%1$s.CreatedById = ' . USER_ROOT . ', \'root\', IF (%1$s.CreatedById = ' . USER_GUEST . ', \'Guest\', \'n/a\')), IF(pu.Username = "", pu.Email, pu.Username))',
			),
		),

		'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								2 => 'icon16_pending.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'CommentId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'CommentBody' => Array ('title' => 'column:la_fld_PollComment', 'data_block' => 'grid_priority_td', 'filter_block' => 'grid_like_filter', 'width' => 250, ),

								'CommentedByUser' => Array( 'title'=>'la_col_CommentedByUser', 'filter_block' => 'grid_like_filter', 'width' => 150, ),

								'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145,  ),
								'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
							),
						),
		),

	);