<?php
/**
* @version	$Id: topics_config.php 15350 2012-05-18 10:18:41Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'bb',
					'ItemClass'			=>	Array ('class' => 'kCatDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kCatDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'TopicsEventHandler', 'file' => 'topics_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'TopicsTagProcessor', 'file' => 'topics_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'ConfigPriority' => 0,

					'RewritePriority' => 103,
					'RewriteListener' => 'CategoryItemRewrite:RewriteListener',

					'Hooks' => Array (
						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => 'cdata',
							'DoSpecial' => '*',
							'DoEvent' => 'OnDefineCustomFields',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'rev',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'fav',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'rel',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'img',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'ci',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),
					),

					'CatalogItem'			=>	true,
					'AdminTemplatePath'		=>	'topics',
					'AdminTemplatePrefix'	=>	'topics_',
					'SearchConfigPostfix' 	=>	'topics',

					'IDField'			=>	'TopicId',
   					'StatusField'		=>	Array ('Status'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'TopicText',		// field, used in bluebar when editing existing item
					'TitlePhrase'		=>	'la_Text_Topic',	// phrase used to specify item type in relationship list
					'OwnerField'		=>	'OwnerId',			// usually it is CreatedById

					'TitlePresets'		=>	Array (
   												'default'	=>	Array (	'new_status_labels'		=> Array ('bb' => '!la_title_AddingTopic!'),
																		'edit_status_labels'	=> Array ('bb' => '!la_title_EditingTopic!'),
																		'new_titlefield'		=> Array ('bb' => '!la_title_NewTopic!'),
																),

												'topics_edit' 		=>	Array ('prefixes' => Array ('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_General!"),
												'topics_categories'	=>	Array ('prefixes' => Array ('bb', 'bb-ci_List'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Categories!"),
												'topics_relations'	=>	Array ('prefixes' => Array ('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Relations!"),
												'topics_images'		=>	Array ('prefixes' => Array ('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Images!"),
												'topics_reviews'	=>	Array ('prefixes' => Array ('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Reviews!"),
												'topics_custom'		=>	Array ('prefixes' => Array ('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Custom!"),

												'images_edit'		=>	Array (	'prefixes'				=>	Array ('bb', 'bb-img'),
																				'new_status_labels'		=>	Array ('bb-img' => '!la_title_Adding_Image!'),
																				'edit_status_labels'	=>	Array ('bb-img' => '!la_title_Editing_Image!'),
																				'new_titlefield'		=>	Array ('bb-img' => '!la_title_New_Image!'),
																				'format'				=>	"#bb_status# '#bb_titlefield#' - #bb-img_status# '#bb-img_titlefield#'",
																		),

												'reviews_edit'	=>	Array (		'prefixes'				=>	Array ('bb', 'bb-rev'),
																				'new_status_labels'		=>	Array ('bb-rev' =>"!la_title_Adding_Review! '!la_title_New_Review!'"),
																				'edit_status_labels'	=>	Array ('bb-rev' => '!la_title_Editing_Review!'),
																				'format'				=>	"#bb_status# '#bb_titlefield#' - #bb-rev_status#",
																		),

												'relations_edit'	=>	Array (	'prefixes'				=>	Array ('bb', 'bb-rel'),
																				'new_status_labels'		=>	Array ('bb-rel' =>"!la_title_Adding_Relationship! '!la_title_New_Relationship!'"),
																				'edit_status_labels'	=>	Array ('bb-rel' => '!la_title_Editing_Relationship!'),
																				'format'				=>	"#bb_status# '#bb_titlefield#' - #bb-rel_status#",
																		),

   												'tree_in-bulletin'	=>	Array ('format' => '!la_Text_Version! '.$this->Application->findModule('Name', 'In-Bulletin', 'Version')),
											),

					'EditTabPresets' => Array (
   						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-bulletin/topics/topics_edit', 'priority' => 1),
							'categories' => Array ('title' => 'la_tab_Categories', 't' => 'in-bulletin/topics/topics_categories', 'priority' => 2),
							'relations' => Array ('title' => 'la_tab_Relations', 't' => 'in-bulletin/topics/topics_relations', 'priority' => 3),
							'images' => Array ('title' => 'la_tab_Images', 't' => 'in-bulletin/topics/topics_images', 'priority' => 4),
							'reviews' => Array ('title' => 'la_tab_Reviews', 't' => 'in-bulletin/topics/topics_reviews', 'priority' => 5),
							'custom' => Array ('title' => 'la_tab_Custom', 't' => 'in-bulletin/topics/topics_custom', 'priority' => 6),
   						),
   					),

   					'PermItemPrefix'	=>	'TOPIC',

   					'PermTabText'		=>	'In-Bulletin',
   					'PermSection'		=>	Array ('main' => 'CATEGORY:in-bulletin:topics_list', 'search' => 'in-bulletin:configuration_search', 'custom' => 'in-bulletin:configuration_custom'),

					'Sections'			=>	Array (
						/*'in-bulletin'	=>	Array (
							'parent'		=>	'in-portal:root',
							'icon'			=>	'settings_in-bulletin',
							'label'			=>	'la_title_In-Bulletin',
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.3,
							'container'		=>	true,
							'type'			=>	stTREE,
						),*/

						'in-bulletin:topics'	=>	Array (
							'parent'		=>	'in-portal:site',
							'icon'			=>	'topics',
							'label'			=>	'la_tab_Topics',
							'url'			=>	Array ('t' => 'catalog/advanced_view', 'anchor' => 'tab-bb.showall', 'pass' => 'm'),
							'onclick'		=>	'setCatalogTab(\'bb.showall\')',
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.4,
							'type'			=>	stTREE,
						),

						// topic settings
						'in-bulletin:setting_folder' => Array (
							'parent'		=>	'in-portal:system',
							'icon'			=>	'conf_topics',
							'label'			=>	'la_title_In-Bulletin',
						    'use_parent_header' => 1,
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.5,
							'container'		=>	true,
							'type'			=>	stTREE,
						),

						/*'in-bulletin:inbulletin_general'	=>	Array (
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:settings_general',
							'label'			=>	'la_tab_GeneralSettings',
							'url'			=>	Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	2.9,
							'type'			=>	stTREE,
						),*/

						'in-bulletin:configuration_output'	=>	Array (
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:conf_output',
							'label'			=>	'la_tab_ConfigOutput',
							'url'			=>	Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),

						'in-bulletin:configuration_search'	=>	Array (
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:conf_search',
							'label'			=>	'la_tab_ConfigSearch',
							'url'			=>	Array ('t' => 'config/config_search', 'module_key' => 'topics', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	4,
							'type'			=>	stTREE,
						),

						'in-bulletin:configuration_custom'	=>	Array (
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:conf_customfields',
							'label'			=>	'la_tab_ConfigCustom',
							'url'			=>	Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 3, 'pass_section' => true, 'pass' => 'm,cf'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	5,
							'type'			=>	stTREE,
						),
					),

					'FilterMenu'		=>	Array (
						'Groups' => Array (
							Array ('mode' => 'AND', 'filters' => Array ('show_new'), 'type' => kDBList::HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_hot'), 'type' => kDBList::HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_pop'), 'type' => kDBList::HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_pick'), 'type' => kDBList::WHERE_FILTER),
						),
						'Filters' => Array (
							'show_new'	=>	Array ('label' => 'la_Text_New', 'on_sql' => '', 'off_sql' => '`IsNew` != 1'  ),
							'show_hot'	=>	Array ('label' => 'la_Text_Hot', 'on_sql' => '', 'off_sql' => '`IsHot` != 1'  ),
							'show_pop'	=>	Array ('label' => 'la_Text_Pop', 'on_sql' => '', 'off_sql' => '`IsPop` != 1'  ),
							'show_pick'	=>	Array ('label' => 'la_prompt_EditorsPick', 'on_sql' => '', 'off_sql' => '%1$s.`EditorsPick` != 1'  ),
						),
					),

					'CatalogSelectorName'	=>	'topiclist',

					'ItemPropertyMappings'	=>	Array (
														'NewDays'		=>	'Topic_NewDays',	// number of days item to be NEW
														'MinPopVotes'	=>	'Topic_MinPopVotes',	// minimum number of votes for an item to be POP
														'MinPopRating'	=>	'Topic_MinPopRating',	// minimum rating for an item to be POP
														'MaxHotNumber'	=>	'Topic_MaxHotNumber',	// maximum number of HOT items

														'HotLimit'		=>	'Topic_HotLimit',	// variable name in inp_Cache table
														'ClickField'	=>	'Views',			// item click count is stored here (in item table)
												),

					'ItemType'			=>	3,	// this is used when relation to product is added from in-portal and via-versa

					'ViewMenuPhrase'	=>	'la_title_Topics',
					'CatalogTabIcon' => 'in-bulletin:icon16_topics.png',
					'UsePendingEditing'	=>	true, // item editing is controlled by TOPIC.ADD/EDIT, TOPIC.ADD/EDIT.PENDING permissions

					'StatisticsInfo'	=>	Array (
													'pending'	=>	Array (
																			'icon'		=>	'icon16_topic_pending.gif',
																			'label'		=>	'la_Text_Topics',
																			'js_url' 	=>	'#url#',
																			'url'		=>	Array ('t' => 'catalog/advanced_view', 'SetTab' => 'bb', 'pass' => 'm,bb.showall', 'bb.showall_event' => 'OnSetFilterPattern', 'bb.showall_filters' => 'show_active=0,show_pending=1,show_disabled=0,show_new=1,show_hot=1,show_pop=1,show_pick=1'),
																			'status'	=>	STATUS_PENDING,
																	),
											),

					'TableName'			=>	TABLE_PREFIX.'Topic',
					'CustomDataTableName' => TABLE_PREFIX . 'TopicCustomData',

					'CalculatedFields' => Array (
						'' => Array (
							'UserName' 		=> 'IF (ISNULL(u.Username), IF (%1$s.OwnerId = ' . USER_ROOT . ', "root", IF (%1$s.OwnerId = ' . USER_GUEST . ', "Guest", "n/a")), u.Username)',
							'CategoryId'	=>	TABLE_PREFIX.'%3$sCategoryItems.CategoryId',
							'Filename' => TABLE_PREFIX.'%3$sCategoryItems.Filename',
							'CategoryFilename' => TABLE_PREFIX.'Categories.NamedParentPath',
							'PrimaryCat'	=> TABLE_PREFIX.'%3$sCategoryItems.PrimaryCat',
							'ParentPath' => TABLE_PREFIX.'Categories.ParentPath',

							'AltName'		=>	'img.AltName',
							'SameImages'	=>	'img.SameImages',
							'LocalThumb'	=>	'img.LocalThumb',
							'ThumbPath'		=>	'img.ThumbPath',
							'ThumbUrl'		=>	'img.ThumbUrl',
							'LocalImage'	=>	'img.LocalImage',
							'LocalPath'		=>	'img.LocalPath',
							'FullUrl'		=>	'img.Url',

							'LastPoster' => 'IF (ISNULL(last_post.PosterAlias), "Guest", last_post.PosterAlias)',
							'LastPosterId' => 'last_post.CreatedById',
						),
					),

					'ListSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'CategoryPermissionsCache perm ON perm.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.OwnerId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'%3$sPosting last_post ON last_post.PostingId = %1$s.LastPostId
															LEFT JOIN '.TABLE_PREFIX.'%3$sTopicCustomData cust ON %1$s.ResourceId = cust.ResourceId',
											), // key - special, value - list select sql

					'ListSortings'	=> 	Array (
												'' => Array (
															'ForcedSorting' => Array ('EditorsPick' => 'desc', 'Priority' => 'desc'),
															'Sorting' => Array ('TopicText' => 'asc'),
														)
										),
					'ItemSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.OwnerId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'%3$sPosting last_post ON last_post.PostingId = %1$s.LastPostId
															LEFT JOIN '.TABLE_PREFIX.'%3$sTopicCustomData cust ON %1$s.ResourceId = cust.ResourceId'),

					'SubItems'			=>	Array ('bb-rev', 'bb-ci', 'bb-rel', 'bb-img', 'bb-cdata', 'bb-fav', 'bb-post'),

					'Fields' => Array (
			            'TopicId'				=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
			            'NotifyOwnerOnChanges'	=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (0 => 'lu_No', 1 => 'lu_Yes'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
						),
			            'Modified'				=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kDateFormatter',
			            	'required' => 1, 'default' => '#NOW#',
						),
			            'TopicText'				=>	Array (
			            	'type' => 'string',
			            	'required' => 1, 'default' => '', 'not_null' => 1,
						),
			            'AutomaticFilename'		=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 1),
			            'Posts'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Views'					=>	Array (
			            	'type' => 'double',
			            	'formatter' => 'kFormatter',
			            	'format' => '%d',
			            	'not_null' => 1, 'default' => 0,
						),
			            'EditorsPick'			=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
						),
			            'Status'				=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (
								0 => 'la_Disabled',
								1 => 'la_Active',
								2 => 'la_Pending',
							),
							'use_phrases' => 1,
							'not_null' => 1, 'default' => 2,
						),
			            'Priority'				=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'OwnerId'				=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kLEFTFormatter',
			            	'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			            	'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users
			            					WHERE `%s` = \'%s\' ',
			            	'left_key_field' => 'PortalUserId',
			            	'left_title_field' => 'Username',
			            	'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			            	'sample_value' => 'Guest', 'required' => 1, 'default' => NULL,
						),
			            'ModifiedById'			=> Array (
			            	'type' => 'int',
			            	'formatter' => 'kLEFTFormatter',
			            	'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			            	'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users
			            						WHERE `%s` = \'%s\' ',
			            	'left_key_field' => 'PortalUserId',
			            	'left_title_field' => 'Username',
			            	'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			            	'default' => NULL,
						),
			            'ResourceId'			=>	Array ('type' => 'int', 'default' => null),
			            'TopicType'				=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (0 => 'la_Yes', 1 => 'la_No'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 1,
						),
			            'CreatedOn'				=>	Array (
			            	'type' => 'double',
			            	'formatter' => 'kDateFormatter',
			            	'required' => 1, 'default' => '#NOW#',
						),
			            'CachedReviewsQty'		=>	Array ('type' => 'int' , 'not_null' => 1, 'default' => 0),
			            'CachedRating'			=>	Array ('type' => 'string', 'not_null' => 1, 'default' => 0),
			            'CachedVotesQty'		=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'NewItem'				=> Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
			            	'options' => Array (
								2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never',
							),
							'default' => 2, 'not_null' => 1,
						),
			            'PopItem'				=> Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
			            	'options' => Array (
								2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never',
							),
							'default' => 2, 'not_null' => 1,
						),
			            'HotItem'				=> Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
			            	'options' => Array (
								2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never',
							),
							'default' => 2, 'not_null' => 1,
						),
			            'PostedBy'				=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			            'OrgId'					=>	Array ('type' => 'int', 'default' => null),
			            'LastPostId'			=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'LastPostDate'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
			            'TodayDate'				=>	Array ('type' => 'string', 'default' => null),
			            'TodayPosts'			=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'MetaKeywords'			=>	Array ('type' => 'string', 'default' => null),
			            'MetaDescription'		=>	Array (
			            	'type' => 'string',
			            	'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
					),

					'VirtualFields' => Array (
						'Relevance' => Array ('type' => 'float', 'default' => 0),
						'UserName' => Array ('type' => 'string', 'default' => ''),
						'CategoryId' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (),
							'default' => 0,
						),
						'Filename' => Array ('type' => 'string', 'default' => ''),
						'CategoryFilename' => Array ('type' => 'string', 'default' => ''),
						'PrimaryCat' => Array ('type' => 'int', 'default' => 0),
						'IsHot' => Array ('type' => 'int', 'default' => 0),
						'IsNew' => Array ('type' => 'int', 'default' => 0),
						'IsPop' => Array ('type' => 'int', 'default' => 0),
						'CachedNavbar' => Array ('type' => 'string', 'default' => ''),
						'ParentPath' => Array ('type' => 'string', 'default' => ''),

						'LastPoster' => Array ('type' => 'string', 'default' => ''),
						'LastPosterId' => Array ('type' => 'int', 'default' => USER_GUEST),
						'PostingText' => Array (
							'type' => 'string',
							'formatter' => 'kFormatter', 'using_fck' => 1,
						 	'required' => 1, 'allow_html' => 1, 'default' => '',
						),
						'DisableBBCodes' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
							'default' => 0,
						),
						'DisableSmileys' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
							'default' => 0,
						),
						'ShowSignatures' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
							'default' => 1,
						),

						// for primary image
						'AltName'		=>	Array ('type' => 'string', 'default' => ''),
						'SameImages'	=>	Array ('type' => 'string', 'default' => ''),
						'LocalThumb'	=>	Array ('type' => 'string', 'default' => ''),
						'ThumbPath'		=>	Array ('type' => 'string', 'default' => ''),
						'ThumbUrl'		=>	Array ('type' => 'string', 'default' => ''),
						'LocalImage'	=>	Array ('type' => 'string', 'default' => ''),
						'LocalPath'		=>	Array ('type' => 'string', 'default' => ''),
						'FullUrl'		=>	Array ('type' => 'string', 'default' => ''),
					),

					'Grids'	=> Array (
						'Default'	=>	Array (
							'Icons' => Array (
								'default' => 'icon16_topic.png',
								0 => 'icon16_topic_disabled.png',
								1 => 'icon16_topic.png',
								2 => 'icon16_topic_pending.png',
								'NEW' => 'icon16_topic_new.png',
							),
							'Fields' => Array (
								'TopicId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'TopicText' => Array ('title' => 'la_col_TopicText', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter', 'width' => 300, 'first_chars' => 290, ),
								'Priority' => Array('filter_block' => 'grid_range_filter', 'width' => 65),
								'UserName' => Array ('title' => 'column:la_fld_PostedBy', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Status' =>	Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
								'LastPostDate' => Array ('title' => 'la_col_LastPostOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Posts' => Array ('title' => 'la_col_Posts', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'Views' =>	Array ('filter_block' => 'grid_range_filter', 'width' => 70, ),
							),
						),

						'Radio'	=>	Array (
							'Icons' => Array (
								'default' => 'icon16_topic.png',
								0 => 'icon16_topic_disabled.png',
								1 => 'icon16_topic.png',
								2 => 'icon16_topic_pending.png',
								'NEW' => 'icon16_topic_new.png',																		),
							'Selector' => 'radio',
							'Fields' => Array (
								'TopicId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'TopicText' => Array ('title' => 'la_col_TopicText', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter', 'width' => 300, 'first_chars' => 290, ),
								'Priority' => Array('filter_block' => 'grid_range_filter', 'width' => 65),
								'UserName' => Array ('title' => 'column:la_fld_PostedBy', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Status' =>	Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
								'LastPostDate' => Array ('title' => 'la_col_LastPostOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Posts' => Array ('title' => 'la_col_Posts', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'Views' =>	Array ('filter_block' => 'grid_range_filter', 'width' => 70, ),
							),
						),
					),

					'ConfigMapping' => 	Array (
												'PerPage'				=>	'Perpage_Topics',
												'ShortListPerPage'		=>	'Perpage_Topics_Short',
												'ForceEditorPick'		=>	'Topic_EditorPicksAbove',
												'DefaultSorting1Field'	=>	'Topic_SortField',
												'DefaultSorting2Field'	=>	'Topic_SortField2',
												'DefaultSorting1Dir'	=>	'Topic_SortOrder',
												'DefaultSorting2Dir'	=>	'Topic_SortOrder2',

												'RatingDelayValue'		=>	'topic_RatingDelay_Value',
												'RatingDelayInterval'	=>	'topic_RatingDelay_Interval',
										),
			);