<?php
/**
* @version	$Id: poll_comment_eh.php 15148 2012-03-04 09:04:48Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class PollCommentEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnCreate'		=>	Array ('self' => true, 'subitem' => true,),
				'OnItemBuild'	=>	Array ('self' => true, 'subitem' => true,),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Occurs, when config was parsed, allows to change config data dynamically
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterConfigRead(kEvent $event)
		{
			parent::OnAfterConfigRead($event);

			if ( $this->Application->RecallVar('user_id') == USER_GUEST ) {
				// make Guest Name and Email required for guests
				$fields = $this->Application->getUnitOption($event->Prefix, 'Fields');
				$fields['GuestName']['required'] = 1;
				$fields['GuestEmail']['required'] = 1;
				$this->Application->setUnitOption($event->Prefix, 'Fields', $fields);
			}
		}

		/**
		 * Applies special filter, that allows to select all commented from current poll
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			if ( $this->Application->isAdminUser ) {
				return;
			}

			$object = $event->getObject();
			/* @var $object kDBList */

			$object->addFilter('comment_status', '%1$s.Status = ' . STATUS_ACTIVE);
		}

		/**
		 * Occurs before creating item
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemCreate(kEvent $event)
		{
			if ( !$this->Application->isAdmin ) {
				$object = $event->getObject();
				/* @var $object kDBItem */

				$parent_info = $object->getLinkedInfo($event->Special);
				$poll_id = $parent_info['ParentId'];

				if ( $poll_id ) {
					$spam_helper = $this->Application->recallObject('SpamHelper');
					/* @var $spam_helper SpamHelper */

					$spam_helper->InitHelper($poll_id, 'PollComment', 0); // ResourceId used for SpamControl only

					if ( $spam_helper->InSpamControl() ) {
						$event->status = kEvent::erFAIL;
						$object->SetError('CommentText', 'too_frequent', 'lu_error_AlreadyCommented');
						return ;
					}

					$object->SetDBField('PollId', $poll_id); // PollId
				}

				$object->SetDBField('CreatedById', $this->Application->RecallVar('user_id'));
				$object->SetDBField('UserIP', $_SERVER['REMOTE_ADDR']);
				$object->SetDBField('Status', STATUS_ACTIVE);
			}

			parent::OnBeforeItemCreate($event);
		}

		/**
		 * Updates item review counter
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnCreate(kEvent $event)
		{
			parent::OnCreate($event);

			if ( !$this->Application->isAdmin && $event->status == kEvent::erSUCCESS ) {
				$event->setRedirectParam('opener', 's');
				$event->setRedirectParam('pass', 'm,poll');
				$event->redirect = $this->Application->GetVar('success_template');
			}
		}

		/**
		 * Protects against spam
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemCreate(kEvent $event)
		{
			parent::OnAfterItemCreate($event);

			if ( !$this->Application->isAdminUser ) {
				$spam_helper = $this->Application->recallObject('SpamHelper');
				/* @var $spam_helper SpamHelper */

				$object = $event->getObject();
				/* @var $object kDBItem */

				$comment_settings = 'poll_CommentDelay_Value:poll_CommentDelay_Interval';
				$spam_helper->InitHelper($object->GetDBField('PollId'), 'PollComment', $comment_settings);
				$spam_helper->AddToSpamControl();
			}
		}

	}