<?php
/**
* @version	$Id: topics_event_handler.php 13548 2010-05-11 19:50:00Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class TopicsEventHandler extends kCatDBEventHandler {


		/**
		 * Checks topic lock permission
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			if ($event->Name == 'OnTopicLockToggle') {
				$object =& $event->getObject();
				/* @var $object kCatDBItem */

				if (!$object->isLoaded()) {
					$event->status = erPERM_FAIL;
					return false;
				}

				$category_id = $object->GetDBField('CategoryId');
				$perm_status = $this->Application->CheckPermission('TOPIC.LOCK', 0, $category_id);

				if (!$perm_status) {
					$event->status = erPERM_FAIL;
				}

				return $perm_status;
			}

			return parent::CheckPermission($event);
		}

		/**
		 * Lock or unlock topic
		 *
		 * @param kEvent $event
		 */
		function OnToggleLock(&$event)
		{
			$object =& $event->getObject();

			$new_type = $object->GetDBField('TopicType') ? 0 : 1;
			$object->SetDBField('TopicType', $new_type);
			$object->Update();
		}

		/**
		 * Cache topic owner
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemUpdate(&$event)
		{
			parent::OnBeforeItemUpdate($event);

			$this->cacheItemOwner($event, 'OwnerId', 'PostedBy');
		}

		/**
		 * Cache topic owner
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			parent::OnBeforeItemCreate($event);

			$this->cacheItemOwner($event, 'OwnerId', 'PostedBy');

			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			if (!$object->GetDBField('TodayDate')) {
				$object->SetDBField('TodayDate', adodb_date('Y-m-d'));
			}

			$post_helper =& $this->Application->recallObject('PostHelper');
			/* @var $post_helper PostHelper */

			$object->SetDBField('TopicText', $post_helper->CensorText( $object->GetDBField('TopicText') ));
		}

		/**
		 * Creates 1st post when topic is created
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			parent::OnAfterItemCreate($event);

			if ($event->Special == '-item') {
				// don't create first post when cloning
				return ;
			}

			$object =& $event->getObject();
			/* @var $object kDBItem */

			$post =& $this->Application->recallObject($event->Prefix.'-post', null, Array ('skip_autoload' => true));
			/* @var $post kDBItem */

			$post->SetDBField('Pending', $object->GetDBField('Status') == STATUS_ACTIVE ? 0 : 1);
			$post->SetDBField('Subject', '');
			$post->SetDBField('PostingText', $object->GetDBField('PostingText'));

			$post->SetDBField('ShowSignatures', $object->GetDBField('ShowSignatures'));
			$post->SetDBField('DisableSmileys', $object->GetDBField('DisableSmileys'));
			$post->SetDBField('DisableBBCodes', $object->GetDBField('DisableBBCodes'));

			$post->Create();

			// need to update category topic count here
		}

		/**
		 * Approves 1st post when topic got approved
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemUpdate(&$event)
		{
			if (!$this->Application->isAdminUser) {
				return ;
			}

			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			if ($object->GetDBField('Posts') == 1) {
				$post =& $this->Application->recallObject($event->Prefix.'-post', null, Array('skip_autoload' => true));
				/* @var $post kDBItem */

				$main_status = $object->GetDBField('Status');
				$post->Load($object->GetDBField('LastPostId'));
				if ($post->isLoaded()) {
					$post->SetDBField('Pending', $main_status == STATUS_ACTIVE ? 0 : 1);
					$post->Update();
				}
			}
		}

		/**
		 * Makes first post body field non-requered when topic has posts already
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemLoad(&$event)
		{
			parent::OnAfterItemLoad($event);

			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			if ($object->GetDBField('Posts') > 0 || !$this->Application->isAdminUser) {
				$object->setRequired('PostingText', false);
			}
		}

		/**
		 * Locks or unlocks topic
		 *
		 * @param kEvent $event
		 */
		function OnTopicLockToggle(&$event)
		{
			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			$topic_type = $object->GetDBField('TopicType');
			$object->SetDBField('TopicType', $topic_type == 1 ? 0 : 1);
			$object->Update();
		}

		/**
		 * Sets default values to posting options based on persistent session
		 *
		 * @param kEvent $event
		 */
		function OnAfterConfigRead(&$event)
		{
			parent::OnAfterConfigRead($event);

			$fields = $this->Application->getUnitOption($event->Prefix, 'Fields');
			$fields['NotifyOwnerOnChanges']['default'] = (int)$this->Application->RecallPersistentVar('owner_notify');
			$this->Application->setUnitOption($event->Prefix, 'Fields', $fields);

			$virtual_fields = $this->Application->getUnitOption($event->Prefix, 'VirtualFields');
			$virtual_fields['DisableBBCodes']['default'] = (int)!$this->Application->RecallPersistentVar('bbcode');
			$virtual_fields['DisableSmileys']['default'] = (int)!$this->Application->RecallPersistentVar('smileys');
			$virtual_fields['ShowSignatures']['default'] = (int)$this->Application->RecallPersistentVar('show_sig');
			$this->Application->setUnitOption($event->Prefix, 'VirtualFields', $virtual_fields);
		}

		/**
		 * [HOOK] Allows to add cloned subitem to given prefix
		 *
		 * @param kEvent $event
		 */
		function OnCloneSubItem(&$event)
		{
			parent::OnCloneSubItem($event);

			if ($event->MasterEvent->Prefix == 'rev') {
				$clones = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'Clones');
				$subitem_prefix = $event->Prefix . '-' . $event->MasterEvent->Prefix;

				$clones[$subitem_prefix]['ConfigMapping'] = Array (
					'PerPage'				=>	'Perpage_TopicReviews',

					'ReviewDelayInterval'	=>	'topic_ReviewDelay_Interval',
					'ReviewDelayValue'		=>	'topic_ReviewDelay_Value',
				);

				$this->Application->setUnitOption($event->MasterEvent->Prefix, 'Clones', $clones);
			}
		}
	}