# ===== v 4.3.9 =====
ALTER TABLE Emoticon
	ADD EmotionImage VARCHAR(255) NOT NULL,
	ADD INDEX (EmotionImage),
	DROP ImageId;

UPDATE Emoticon SET EmotionImage = CONCAT('0_',EmoticonId,'.gif') WHERE EmoticonId < 21;

# ===== v 5.0.0 =====
CREATE TABLE Polls (
  PollId int(11) NOT NULL auto_increment,
  `Name` varchar(255) NOT NULL default '',
  l1_Question text,
  l2_Question text,
  l3_Question text,
  l4_Question text,
  l5_Question text,
  Image varchar(255) NOT NULL default '',
  CreatedOn int(11) unsigned NOT NULL,
  StartDate int(11) unsigned NOT NULL,
  EndDate int(11) unsigned default NULL,
  Priority tinyint(4) NOT NULL default '0',
  RequireLogin tinyint(4) NOT NULL default '0',
  AllowMultipleVotings tinyint(4) NOT NULL default '1',
  AllowComments tinyint(4) NOT NULL default '1',
  `Status` tinyint(4) NOT NULL default '1',
  CachedVotesQty int(11) NOT NULL,
  PRIMARY KEY  (PollId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY StartDate (StartDate),
  KEY EndDate (EndDate)
);

CREATE TABLE PollsAnswers (
  AnswerId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL,
  l1_Answer text,
  l2_Answer text,
  l3_Answer text,
  l4_Answer text,
  l5_Answer text,
  VotesQty int(11) NOT NULL,
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (AnswerId),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY VoteCount (VotesQty),
  KEY PollId (PollId)
);

CREATE TABLE PollsComments (
  CommentId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL,
  AnswerId int(11) default NULL,
  CreatedById int(11) NOT NULL default '-2',
  GuestName varchar(255) NOT NULL,
  GuestEmail varchar(255) NOT NULL,
  CommentBody text,
  CreatedOn int(11) NOT NULL,
  UserIP varchar(255) NOT NULL,
  Priority int(11) NOT NULL,
  `Status` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (CommentId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY CreatedOn (CreatedOn),
  KEY AnswerId (AnswerId),
  KEY PollId (PollId),
  KEY CreatedById (CreatedById)
);

CREATE TABLE PollsStatistics (
  StatisticsId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL default '0',
  AnswerId int(11) NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-2',
  UserIP varchar(255) NOT NULL,
  AnswerDate int(10) unsigned default NULL,
  PRIMARY KEY  (StatisticsId),
  KEY AnswerId (AnswerId,PollId),
  KEY CreatedById (CreatedById),
  KEY UserIP (UserIP)
);

INSERT INTO ConfigurationAdmin VALUES ('poll_CommentDelay_Value', 'la_Text_Polls', 'la_prompt_DupPollComments', 'text', '', '', 60.1, 1, 1);
INSERT INTO ConfigurationAdmin VALUES ('poll_CommentDelay_Interval', 'la_Text_Polls', 'la_prompt_DupPollComments', 'select', '', '1=la_Text_Second,60=la_Text_Minute,3600=la_Text_Hour,86400=la_Text_Day,604800=la_Text_Week,2419200=la_Text_Month,29030400=la_text_Year', 60.2, 2, 1);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'poll_CommentDelay_Interval', '60', 'In-Bulletin', 'in-bulletin:configuration_output');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'poll_CommentDelay_Value', '10', 'In-Bulletin', 'in-bulletin:configuration_output');

UPDATE Category SET Template = '/in-bulletin/designs/section' WHERE Template = 'inbulletin/index';
UPDATE Category SET CachedTemplate = '/in-bulletin/designs/section' WHERE CachedTemplate = 'inbulletin/index';

UPDATE ConfigurationValues SET VariableValue = '/in-bulletin/designs/section' WHERE VariableName = 'bb_CategoryTemplate';
UPDATE ConfigurationValues SET VariableValue = 'in-bulletin/designs/detail' WHERE VariableName = 'bb_ItemTemplate';

INSERT INTO Permissions VALUES (DEFAULT, 'in-bulletin:topics.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-bulletin:setting_folder.view', 11, 1, 1, 0);
DELETE FROM Permissions WHERE Permission LIKE 'in-bulletin:inbulletin_general.%';

UPDATE Phrase SET Module = 'In-Bulletin' WHERE ((Phrase LIKE '%Topic%' OR Phrase LIKE '%Post%' OR Phrase LIKE '%Forum%' OR Phrase LIKE '%Censor%' OR Phrase LIKE '%Smiley%' OR Phrase = 'la_title_In-Bulletin') AND (Module = 'Core'));

# ===== v 5.0.1 =====
UPDATE ConfigurationValues SET VariableValue = 'in-bulletin/topics/topic_detail' WHERE VariableName = 'bb_ItemTemplate';

UPDATE ConfigurationAdmin
SET ValueList = 'TopicText=la_opt_TopicText,Posts=la_opt_NumberOfPosts,CreatedOn=la_opt_CreatedOn,LastPostDate=la_opt_LastUpdated,Views=la_opt_TopicViews,CachedRating=la_opt_Rating,LastPoser=la_opt_LastPoster,<SQL>SELECT Prompt AS OptionName, CONCAT("cust_", FieldName) AS OptionValue FROM <PREFIX>CustomField WHERE (Type = 3) AND (IsSystem = 0)</SQL>'
WHERE VariableName IN ('Topic_SortField', 'Topic_SortField2');

UPDATE ConfigurationAdmin
SET ValueList = 'ASC=la_common_Ascending,DESC=la_common_Descending'
WHERE VariableName IN ('Topic_SortOrder', 'Topic_SortOrder2');

UPDATE ConfigurationAdmin SET ValueList = '1=la_opt_Sec,60=la_opt_Min,3600=la_opt_Hour,86400=la_opt_Day,604800=la_opt_Week,2419200=la_opt_Month,29030400=la_opt_Year' WHERE VariableName = 'topic_ReviewDelay_Interval';
UPDATE ConfigurationAdmin SET ValueList = '1=la_opt_Sec,60=la_opt_Min,3600=la_opt_Hour,86400=la_opt_Day,604800=la_opt_Week,2419200=la_opt_Month,29030400=la_opt_Year' WHERE VariableName = 'topic_RatingDelay_Interval';
UPDATE ConfigurationAdmin SET ValueList = '1=la_opt_Sec,60=la_opt_Min,3600=la_opt_Hour,86400=la_opt_Day,604800=la_opt_Week,2419200=la_opt_Month,29030400=la_opt_Year' WHERE VariableName = 'poll_CommentDelay_Interval';

UPDATE CustomField SET FieldLabel = 'la_fld_cust_bb_ItemTemplate', Prompt = 'la_fld_cust_bb_ItemTemplate' WHERE FieldName = 'bb_ItemTemplate';

INSERT INTO Events VALUES(DEFAULT, 'TOPIC.ADD', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.add', 0);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.ADD.PENDING', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.add.pending', 1);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.ADD.PENDING', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.add.pending', 0);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.MODIFY', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.modify', 1);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.MODIFY', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.modify', 0);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.MODIFY.PENDING', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.modify.pending', 1);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.MODIFY.PENDING', NULL, 1, 1, NULL, 'In-Bulletin', 'la_event_topic.modify.pending', 0);
INSERT INTO Events VALUES(DEFAULT, 'TOPIC.APPROVE', NULL, 1, 0, NULL, 'In-Bulletin', 'la_event_topic.approve', 0);

UPDATE ConfigurationAdmin SET ValueList = 'style="width: 50px;"' WHERE VariableName IN ('topic_ReviewDelay_Value', 'topic_RatingDelay_Value', 'poll_CommentDelay_Value');

# ===== v 5.0.2-B1 =====
ALTER TABLE PrivateMessageBody CHANGE Body Body text NULL;

ALTER TABLE Emoticon CHANGE EmotionImage EmotionImage VARCHAR(255) NOT NULL DEFAULT '';

ALTER TABLE Polls
	CHANGE CreatedOn CreatedOn INT(11) UNSIGNED NULL DEFAULT NULL ,
	CHANGE StartDate StartDate INT(11) UNSIGNED NULL DEFAULT NULL ,
	CHANGE CachedVotesQty CachedVotesQty INT(11) NOT NULL DEFAULT '0';

ALTER TABLE PollsAnswers
	CHANGE PollId PollId INT(11) NOT NULL DEFAULT '0',
	CHANGE VotesQty VotesQty INT(11) NOT NULL DEFAULT '0';

ALTER TABLE PollsComments
	CHANGE PollId PollId INT(11) NOT NULL DEFAULT '0',
	CHANGE GuestName GuestName VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE GuestEmail GuestEmail VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE CreatedOn CreatedOn INT(11) NULL DEFAULT NULL ,
	CHANGE UserIP UserIP VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE Priority Priority INT(11) NOT NULL DEFAULT '0';

ALTER TABLE PollsStatistics CHANGE UserIP UserIP VARCHAR(255) NOT NULL DEFAULT '';

ALTER TABLE Posting
	CHANGE CreatedOn CreatedOn INT(11) NULL DEFAULT NULL,
	CHANGE Modified Modified INT(11) NULL DEFAULT NULL;

ALTER TABLE PrivateMessages CHANGE CreatedOn CreatedOn INT(11) UNSIGNED NULL DEFAULT NULL;

ALTER TABLE Topic
	CHANGE Modified Modified INT(11) NULL DEFAULT NULL,
	CHANGE CreatedOn CreatedOn INT(11) NULL DEFAULT NULL;

# ===== v 5.0.2-B2 =====

# ===== v 5.0.2-RC1 =====

# ===== v 5.0.2 =====

# ===== v 5.0.3-B1 =====

# ===== v 5.0.3-B2 =====

# ===== v 5.0.3-RC1 =====

# ===== v 5.0.3 =====

# ===== v 5.0.4-B1 =====

# ===== v 5.0.4-B2 =====

# ===== v 5.0.4 =====

# ===== v 5.1.0-B1 =====
UPDATE Modules SET Path = 'modules/in-bulletin/' WHERE `Name` = 'In-Bulletin';
DELETE FROM ConfigurationValues WHERE VariableName IN (
	'Post_Sortfield', 'Post_SortOrder', 'Perpage_PrivateMessages', 'Topic_Root',
	'Topic_Background1', 'Topic_Background2', 'Post_Background1', 'Post_Background2',
	'Posting_SortOrder', 'Bulletin_TopCount', 'Bulletin_CatNewDays', 'Bulletin_Pick_First'
);
UPDATE ConfigurationValues SET ModuleOwner = 'In-Bulletin' WHERE VariableName = 'BBTags';

UPDATE Phrase SET Module = 'Core' WHERE Phrase = 'la_fld_Replacement';
DELETE FROM Permissions WHERE Permission LIKE 'in-bulletin:configuration_email%';

# ===== v 5.1.0-B2 =====

# ===== v 5.1.0-RC1 =====

# ===== v 5.1.0 =====