<?php
/**
* @version	$Id: poll_comment_eh.php 13577 2010-05-19 07:24:12Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class PollCommentEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();
			$permissions = Array(
									'OnCreate'		=>	Array('self' => true, 'subitem' => true,),
									'OnItemBuild'	=>	Array('self' => true, 'subitem' => true,),
							);
			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		function OnAfterConfigRead(&$event)
		{
			if ($this->Application->RecallVar('user_id') == USER_GUEST) {
				// make Guest Name and Email required for guests
				$fields = $this->Application->getUnitOption($event->Prefix, 'Fields');
				$fields['GuestName']['required'] = 1;
				$fields['GuestEmail']['required'] = 1;
				$this->Application->setUnitOption($event->Prefix, 'Fields', $fields);
			}
		}

		/**
		 * Applies special filter, that allows to select all commented from current poll
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			if ($this->Application->isAdminUser) {
				return ;
			}

			$object =& $event->getObject();
			/* @var $object kDBList */

			$object->addFilter('comment_status', '(%1$s.Status = ' .STATUS_ACTIVE. ')');
		}

		/**
		 * Before New PollComment created
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			if ($this->Application->isAdminUser) {
				return ;
			}

			$object =& $event->getObject();
			/* @var $object kDBItem */

			// get Poll info
			$parent_prefix = $this->Application->getUnitOption($this->Prefix, 'ParentPrefix');
			if($parent_prefix) {
				$main_object =& $this->Application->recallObject($parent_prefix.'.'.$special, null,Array('raise_warnings' => 0));
				/* @var $main_object kDBItem */

				if (!$main_object->isLoaded()) {
					$main_object =& $this->Application->recallObject($parent_prefix);
				}

				$poll_id = $main_object->GetDBField($this->Application->getUnitOption($event->Prefix, 'ForeignKey'));
			}

			if ($poll_id) {
				$spam_helper =& $this->Application->recallObject('SpamHelper');
				/* @var $spam_helper SpamHelper */

				$spam_helper->InitHelper($poll_id, 'PollComment', 0); // ResourceId used for SpamControl only

				if ($spam_helper->InSpamControl()) {
					$event->status = erFAIL;
					$object->SetError('CommentText', 'too_frequent', 'lu_error_AlreadyCommented');
					return ;
				}
			}

			$object->SetDBField('CreatedById', $this->Application->RecallVar('user_id'));
			$object->SetDBField('UserIP', $_SERVER['REMOTE_ADDR']);
			$object->SetDBField('PollId', $poll_id); // PollId
			$object->SetDBField('Status', STATUS_ACTIVE);

			parent::OnBeforeItemCreate($event);
		}

		/**
		 * Updates item review counter
		 *
		 * @param kEvent $event
		 */
		function OnCreate(&$event)
		{
			parent::OnCreate($event);

			if ($this->Application->isAdminUser) {
				return;
			}

			if ($event->status == erSUCCESS) {
				$event->setRedirectParam('opener', 's');
				$event->setRedirectParam('pass', 'm,poll');
				$event->redirect = $this->Application->GetVar('success_template');
			}
		}

		/**
		 * Updates item review counter
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			if (!$this->Application->isAdminUser) {
				$spam_helper =& $this->Application->recallObject('SpamHelper');
				/* @var $spam_helper SpamHelper */

				$object =& $event->getObject();

				$config_mapping = $this->Application->getUnitOption($event->Prefix, 'ConfigMapping');
				$comment_settings = $config_mapping['CommentDelayValue'].':'.$config_mapping['CommentDelayInterval'];
				$spam_helper->InitHelper($object->GetDBField('PollId'), 'PollComment', $comment_settings);
				$spam_helper->AddToSpamControl();
			}
		}

	}