<?php
/**
* @version	$Id: polls_config.php 13237 2010-03-15 22:23:52Z dmitrya $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'poll',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'PollEventHandler', 'file' => 'poll_eh.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'PollTagProcessor', 'file' => 'poll_tp.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array (
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
												4 	=>	'mode',
											),

					'IDField'			=>	'PollId',

					'TitleField'		=>	'Name',
					'StatusField'		=>	Array ('Status'),


					'TitlePresets'		=>	Array (
										'default'	=>	Array (
											'new_status_labels'		=> Array ('poll' => '!la_title_Adding_Poll!'),
											'edit_status_labels'	=> Array ('poll' => '!la_title_Editing_Poll!'),
											'new_titlefield'		=> Array ('poll' => '!la_title_NewPoll!'),
										),

										'poll_list' => Array ('prefixes' => Array ('poll_List'), 'format' => "!la_title_Polls!",	),
										'poll_edit' => Array ('prefixes' => Array ('poll'), 'format' => "#poll_status# '#poll_titlefield#' - !la_title_General!",	),
										'poll_edit_answers' => Array ('prefixes' => Array ('poll', 'poll-answer_List'), 'format' => "#poll_status# '#poll_titlefield#' - !la_title_PollAnswers!"),

										'poll_edit_comments' => Array ('prefixes' => Array ('poll', 'poll-comment_List'), 'format' => "#poll_status# '#poll_titlefield#' - !la_title_PollComments!"),


										'answer_edit' => Array (
											'prefixes' => Array ('poll', 'poll-answer'),
											'new_status_labels' => Array ('poll-answer' => '!la_title_Adding_Answer!'),
											'edit_status_labels' => Array ('poll-answer' => '!la_title_Editing_Answer!'),
											'new_titlefield' => Array ('poll-answer' => '!la_title_New_Answer!'),
											'format' => "#poll_status# '#poll_titlefield#' - #poll-answer_status# '#poll-answer_titlefield#'"
											),

										'comment_edit' => Array (
											'prefixes' => Array ('poll', 'poll-comment'),
											'new_status_labels' => Array ('poll-comment' => '!la_title_Adding_Comment!'),
											'edit_status_labels' => Array ('poll-comment' => '!la_title_Editing_Comment!'),
											'new_titlefield' => Array ('poll-comment' => '!la_title_NewComment!'),
											'format' => "#poll_status# '#poll_titlefield#' - #poll-comment_status#",
											),

									),

					'PermSection'		=>	Array ('main' => 'in-bulletin:polls'),

					'Sections' => Array (
						'in-bulletin:polls' => Array (
							'parent'		=>	'in-portal:site',
							'icon'			=>	'polls',
							'label'			=>	'la_title_Polls',
							'url'			=>	Array ('t' => 'in-bulletin/polls/poll_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	3.6,
							'type'			=>	stTREE,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'Polls',

					'ListSQLs'			=>	Array (''	=> 'SELECT %1$s.* %2$s
															FROM %1$s',

											),

					'ItemSQLs'			=>	Array (''	=> 'SELECT %1$s.* %2$s
															FROM %1$s',

											),

					'ListSortings'	=> 	Array (
												'' => 	Array (
																'Sorting' => Array ('PollId' => 'asc'),
														)
										),

					'Fields' 		=> Array (
						'PollId'	 	=> Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
           				'Name' 			=> Array ('type' => 'string', 'not_null' => '1', 'default' => '', 'required' => 1, 'max_len' => 255),
						'Question'		=> Array (
							'type' => 'string',
							'formatter' => 'kMultiLanguage', 'using_fck' => 1,
							'default' => null, 'required' => 1,
						),
						'CreatedOn' 	=> Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
						'StartDate'		=> Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
						'EndDate'		=> Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
						'Image' => Array (
			            	'type' => 'string',
			            	'formatter' => 'kPictureFormatter',
			            	'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => IMAGES_PATH . 'polls/',
			            	'file_types' => '*.jpg;*.gif;*.png', 'files_description' => '!la_hint_ImageFiles!',
			            	'multiple' => false,
			            	'max_len' => 255, 'not_null' => 1, 'default' => ''
			            ),
			            'Priority' 		=> Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'RequireLogin' 	=> Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
							'default' => 0, 'not_null' => 1,
						),
			            'AllowComments' 	=> Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
							'default' => 1, 'not_null' => 1,
						),						
						'AllowMultipleVotings' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
							'default' => 1, 'not_null' => 1,
						),
			            'CachedVotesQty' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Status' 		=> Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (0 => 'la_opt_Disabled', 1 => 'la_opt_Active',), 'use_phrases' => 1,
			            	'required' => 1, 'default' => 1, 'not_null' => 1,
			            ),

					),

					'SubItems'			=>	Array ('poll-answer', 'poll-comment'),

					'VirtualFields'		=> 	Array (
//									'PollId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
										),

					'CalculatedFields' => Array (
							'' => Array (
//								'DaysLeft' => 'IF( ISNULL(%1$s.EndDate), IF (%1$s.CreatedById = -1, \'root\', IF (%1$s.CreatedById = -2, %1$s.PosterAlias, \'n/a\')), \'Never\' )',
								),
							),

					'EditTabPresets' => Array (
								'Default' => Array (
									Array ('title' => 'la_tab_General', 't' => 'in-bulletin/polls/poll_edit', 'priority' => 1),
									Array ('title' => 'la_tab_PollAnswers', 't' => 'in-bulletin/polls/poll_edit_answers', 'priority' => 2),
									Array ('title' => 'la_tab_PollUserComments', 't' => 'in-bulletin/polls/poll_edit_comments', 'priority' => 3),
								),
							),

					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								2 => 'icon16_pending.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'PollId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Name' => Array ('title' => 'la_col_Name', 'data_block' => 'grid_priority_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'StartDate' => Array ('title' => 'la_col_StartDate', 'filter_block' => 'grid_date_range_filter', 'width' => 145,  ),
								'EndDate' => Array ('title' => 'la_col_EndDate', 'data_block' => 'poll_expire_td', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'CachedVotesQty' => Array ('title' => 'la_col_VoteCount', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
//								'DaysActive' => Array ('title' => 'la_col_NumberOfDaysActive', 'filter_block' => 'grid_range_filter',),
							),
						),
					),

	);