CREATE TABLE Posting (
  PostingId int(11) NOT NULL AUTO_INCREMENT,
  IPAddress varchar(255) NOT NULL DEFAULT '',
  PosterAlias varchar(255) NOT NULL DEFAULT '',
  Pending tinyint(4) NOT NULL DEFAULT '0',
  `Subject` varchar(255) DEFAULT NULL,
  PostingText text,
  GraphicsUrl varchar(255) DEFAULT NULL,
  CreatedOn int(11) DEFAULT NULL,
  Modified int(11) DEFAULT NULL,
  ModifiedById int(11) DEFAULT NULL,
  CreatedById int(11) DEFAULT NULL,
  TopicId int(11) NOT NULL DEFAULT '0',
  ResourceId int(11) NOT NULL DEFAULT '0',
  ReplyTo int(11) NOT NULL DEFAULT '0',
  `Options` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (PostingId),
  KEY TopicId (TopicId),
  KEY Pending (Pending),
  KEY CreatedById (CreatedById),
  KEY CreatedOn (CreatedOn),
  KEY ModifiedOn (Modified),
  KEY ModifiedById (ModifiedById)
);

CREATE TABLE Topic (
  TopicId int(11) NOT NULL AUTO_INCREMENT,
  NotifyOwnerOnChanges tinyint(4) NOT NULL DEFAULT '0',
  Modified int(11) DEFAULT NULL,
  TopicText varchar(255) NOT NULL DEFAULT '',
  AutomaticFilename tinyint(3) unsigned NOT NULL DEFAULT '1',
  Posts int(11) NOT NULL DEFAULT '0',
  Views double(20,6) NOT NULL DEFAULT '0.000000',
  EditorsPick tinyint(4) NOT NULL DEFAULT '0',
  `Status` tinyint(4) unsigned NOT NULL DEFAULT '2',
  Priority int(11) NOT NULL DEFAULT '0',
  OwnerId int(11) NOT NULL DEFAULT '-1',
  ModifiedById int(11) NOT NULL DEFAULT '0',
  ResourceId int(11) DEFAULT NULL,
  TopicType int(11) NOT NULL DEFAULT '1',
  CreatedOn int(11) DEFAULT NULL,
  CachedReviewsQty int(11) NOT NULL DEFAULT '0',
  CachedRating varchar(10) NOT NULL DEFAULT '0',
  CachedVotesQty int(11) NOT NULL DEFAULT '0',
  NewItem tinyint(4) NOT NULL DEFAULT '2',
  PopItem tinyint(4) NOT NULL DEFAULT '2',
  HotItem tinyint(4) NOT NULL DEFAULT '2',
  PostedBy varchar(255) NOT NULL DEFAULT '',
  OrgId int(11) DEFAULT NULL,
  LastPostId int(11) NOT NULL DEFAULT '0',
  LastPostDate int(11) DEFAULT NULL,
  TodayDate date DEFAULT NULL,
  TodayPosts int(11) NOT NULL DEFAULT '0',
  MetaKeywords varchar(255) DEFAULT NULL,
  MetaDescription text,
  PRIMARY KEY (TopicId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY OwnerId (OwnerId),
  KEY ModifiedById (ModifiedById),
  KEY Posts (Posts),
  KEY Modified (Modified),
  KEY Views (Views),
  KEY EditorsPick (EditorsPick),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY CreatedOn (CreatedOn),
  KEY NewItem (NewItem),
  KEY PopItem (PopItem),
  KEY HotItem (HotItem),
  KEY LastPostId (LastPostId)
);

CREATE TABLE Censorship (
  CensorshipId int(11) NOT NULL auto_increment,
  BadWord varchar(80) NOT NULL default '',
  Replacement varchar(80) NOT NULL default '',
  PRIMARY KEY  (CensorshipId)
);

CREATE TABLE Emoticon (
  EmoticonId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) NOT NULL DEFAULT '',
  KeyStroke varchar(20) NOT NULL DEFAULT '',
  Enabled int(11) NOT NULL DEFAULT '1',
  EmotionImage varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (EmoticonId),
  KEY Enabled (Enabled),
  KEY EmotionImage (EmotionImage)
);

CREATE TABLE PrivateMessageBody (
  PMBodyId int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Subject` varchar(255) NOT NULL DEFAULT '',
  Body text,
  `Options` tinyint(3) unsigned NOT NULL DEFAULT '0',
  ReferenceCount smallint(5) unsigned NOT NULL DEFAULT '2',
  PRIMARY KEY (PMBodyId),
  KEY ReferenceCount (ReferenceCount)
);

CREATE TABLE PrivateMessages (
  PmId int(11) unsigned NOT NULL AUTO_INCREMENT,
  FromId int(11) unsigned DEFAULT NULL,
  ToId int(11) unsigned DEFAULT NULL,
  FolderId tinyint(3) NOT NULL DEFAULT '-1',
  `Status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PMBodyId int(11) unsigned NOT NULL DEFAULT '0',
  CreatedOn int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (PmId),
  KEY FromId (FromId),
  KEY CreatedOn (CreatedOn),
  KEY ToId (ToId),
  KEY FolderId (FolderId)
);

CREATE TABLE TopicCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE Polls (
  PollId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  l1_Question text,
  l2_Question text,
  l3_Question text,
  l4_Question text,
  l5_Question text,
  Image varchar(255) NOT NULL DEFAULT '',
  CreatedOn int(11) unsigned DEFAULT NULL,
  StartDate int(11) unsigned DEFAULT NULL,
  EndDate int(11) unsigned DEFAULT NULL,
  Priority tinyint(4) NOT NULL DEFAULT '0',
  RequireLogin tinyint(4) NOT NULL DEFAULT '0',
  AllowMultipleVotings tinyint(4) NOT NULL DEFAULT '1',
  AllowComments tinyint(4) NOT NULL DEFAULT '1',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  CachedVotesQty int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (PollId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY StartDate (StartDate),
  KEY EndDate (EndDate)
);

CREATE TABLE PollsAnswers (
  AnswerId int(11) NOT NULL AUTO_INCREMENT,
  PollId int(11) NOT NULL DEFAULT '0',
  l1_Answer text,
  l2_Answer text,
  l3_Answer text,
  l4_Answer text,
  l5_Answer text,
  VotesQty int(11) NOT NULL DEFAULT '0',
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (AnswerId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY VoteCount (VotesQty),
  KEY PollId (PollId)
);

CREATE TABLE PollsComments (
  CommentId int(11) NOT NULL AUTO_INCREMENT,
  PollId int(11) NOT NULL DEFAULT '0',
  AnswerId int(11) DEFAULT NULL,
  CreatedById int(11) NOT NULL DEFAULT '-2',
  GuestName varchar(255) NOT NULL DEFAULT '',
  GuestEmail varchar(255) NOT NULL DEFAULT '',
  CommentBody text,
  CreatedOn int(11) DEFAULT NULL,
  UserIP varchar(255) NOT NULL DEFAULT '',
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (CommentId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY CreatedOn (CreatedOn),
  KEY AnswerId (AnswerId),
  KEY PollId (PollId),
  KEY CreatedById (CreatedById)
);

CREATE TABLE PollsStatistics (
  StatisticsId int(11) NOT NULL AUTO_INCREMENT,
  PollId int(11) NOT NULL DEFAULT '0',
  AnswerId int(11) NOT NULL DEFAULT '0',
  CreatedById int(11) NOT NULL DEFAULT '-2',
  UserIP varchar(255) NOT NULL DEFAULT '',
  AnswerDate int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (StatisticsId),
  KEY AnswerId (AnswerId,PollId),
  KEY CreatedById (CreatedById),
  KEY UserIP (UserIP)
);