<?php
/**
* @version	$Id: upgrades.php 12302 2009-08-17 01:53:35Z dmitrya $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	$upgrade_class = 'InBulletinUpgrades';

	/**
	 * Class, that holds all upgrade scripts for "Core" module
	 *
	 */
	class InBulletinUpgrades extends kHelper {

		/**
		 * Install toolkit instance
		 *
		 * @var kInstallToolkit
		 */
		var $_toolkit = null;

		/**
		 * Sets common instance of installator toolkit
		 *
		 * @param kInstallToolkit $instance
		 */
		function setToolkit(&$instance)
		{
			$this->_toolkit =& $instance;
		}

		/**
		 * Changes table structure, where multilingual fields of TEXT type are present
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_0($mode)
		{
			if ($mode == 'after') {
				$root_category = $this->Application->findModule('Name', 'In-Bulletin', 'RootCat');

				$sql = 'UPDATE ' . $this->Application->getUnitOption('c', 'TableName') . '
						SET UseMenuIconUrl = 1, MenuIconUrl = "in-bulletin/img/menu_topics.gif"
						WHERE ' . $this->Application->getUnitOption('c', 'IDField') . ' = ' . $root_category;
				$this->Conn->Query($sql);

				$this->_updateDetailTemplate('bb', 'inbulletin/post_list', 'in-bulletin/designs/detail');
			}
		}

		/**
		 * Replaces deprecated detail template design with new one
		 *
		 * @param string $prefix
		 * @param string $from_template
		 * @param string $to_template
		 */
		function _updateDetailTemplate($prefix, $from_template, $to_template)
		{
			$sql = 'SELECT CustomFieldId
					FROM ' . TABLE_PREFIX . 'CustomField
					WHERE FieldName = "' . $prefix . '_ItemTemplate"';
			$custom_field_id = $this->Conn->GetOne($sql);

			$ml_formatter =& $this->Application->recallObject('kMultiLanguage');
			/* @var $ml_formatter kMultiLanguage */

			$field = $ml_formatter->LangFieldName('cust_' . $custom_field_id, true);

			$sql = 'UPDATE ' . TABLE_PREFIX . 'CategoryCustomData
					SET ' . $field . ' = "' . $to_template . '"
					WHERE ' . $field . ' = "' . $from_template . '"';
			$this->Conn->Query($sql);
		}

		/**
		 * Update to 5.0.1, update details template
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_1($mode)
		{
			if ($mode == 'after') {
				$this->_updateDetailTemplate('bb', 'in-bulletin/designs/detail', 'in-bulletin/topics/topic_detail');
			}
		}
	}