<?php
/**
* @version	$Id: topics_config.php 11891 2009-07-01 08:08:17Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'bb',
					'ItemClass'			=>	Array('class' => 'kCatDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array('class' => 'kCatDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array('class' => 'TopicsEventHandler', 'file' => 'topics_event_handler.php', 'require_classes' => Array('kCatDBEventHandler'), 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array('class' => 'TopicsTagProcessor', 'file' => 'topics_tag_processor.php', 'require_classes' => Array('kCatDBTagProcessor'), 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'event',
												4 => 'mode',
											),

					'ConfigPriority' => 0,
					'Hooks' => Array (
						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnAfterConfigRead'),
							'DoPrefix' => 'cdata',
							'DoSpecial' => '*',
							'DoEvent' => 'OnDefineCustomFields',
						),
					),

					'CatalogItem'			=>	true,
					'AdminTemplatePath'		=>	'topics',
					'AdminTemplatePrefix'	=>	'topics_',
					'SearchConfigPostfix' 	=>	'topics',

					'IDField'			=>	'TopicId',
   					'StatusField'		=>	Array('Status'),	// field, that is affected by Approve/Decline events

					'TitleField'		=>	'TopicText',		// field, used in bluebar when editing existing item
					'TitlePhrase'		=>	'la_Text_Topic',	// phrase used to specify item type in relationship list
					'OwnerField'		=>	'OwnerId',			// usually it is CreatedById

					'TitlePresets'		=>	Array(
   												'default'	=>	Array(	'new_status_labels'		=> Array('bb' => '!la_title_AddingTopic!'),
																		'edit_status_labels'	=> Array('bb' => '!la_title_EditingTopic!'),
																		'new_titlefield'		=> Array('bb' => '!la_title_NewTopic!'),
																),

												'topics_edit' 		=>	Array('prefixes' => Array('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_General!"),
												'topics_categories'	=>	Array('prefixes' => Array('bb','bb-ci_List'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Categories!"),
												'topics_relations'	=>	Array('prefixes' => Array('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Relations!"),
												'topics_images'		=>	Array('prefixes' => Array('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Images!"),
												'topics_reviews'	=>	Array('prefixes' => Array('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Reviews!"),
												'topics_custom'		=>	Array('prefixes' => Array('bb'), 'format' => "#bb_status# '#bb_titlefield#' - !la_title_Custom!"),

												'images_edit'		=>	Array(	'prefixes'				=>	Array('bb', 'bb-img'),
																				'new_status_labels'		=>	Array('bb-img'=>'!la_title_Adding_Image!'),
																				'edit_status_labels'	=>	Array('bb-img'=>'!la_title_Editing_Image!'),
																				'new_titlefield'		=>	Array('bb-img'=>'!la_title_New_Image!'),
																				'format'				=>	"#bb_status# '#bb_titlefield#' - #bb-img_status# '#bb-img_titlefield#'",
																		),

												'reviews_edit'	=>	Array(		'prefixes'				=>	Array('bb', 'bb-rev'),
																				'new_status_labels'		=>	Array('bb-rev'=>"!la_title_Adding_Review! '!la_title_New_Review!'"),
																				'edit_status_labels'	=>	Array('bb-rev'=>'!la_title_Editing_Review!'),
																				'format'				=>	"#bb_status# '#bb_titlefield#' - #bb-rev_status#",
																		),

												'relations_edit'	=>	Array(	'prefixes'				=>	Array('bb', 'bb-rel'),
																				'new_status_labels'		=>	Array('bb-rel'=>"!la_title_Adding_Relationship! '!la_title_New_Relationship!'"),
																				'edit_status_labels'	=>	Array('bb-rel'=>'!la_title_Editing_Relationship!'),
																				'format'				=>	"#bb_status# '#bb_titlefield#' - #bb-rel_status#",
																		),

   												'tree_in-bulletin'	=>	Array('format' => '!la_Text_Version! '.$this->Application->findModule('Name', 'In-Bulletin', 'Version')),
											),

					'EditTabPresets' => Array (
   						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-bulletin/topics/topics_edit', 'priority' => 1),
							'categories' => Array ('title' => 'la_tab_Categories', 't' => 'in-bulletin/topics/topics_categories', 'priority' => 2),
							'relations' => Array ('title' => 'la_tab_Relations', 't' => 'in-bulletin/topics/topics_relations', 'priority' => 3),
							'images' => Array ('title' => 'la_tab_Images', 't' => 'in-bulletin/topics/topics_images', 'priority' => 4),
							'reviews' => Array ('title' => 'la_tab_Reviews', 't' => 'in-bulletin/topics/topics_reviews', 'priority' => 5),
							'custom' => Array ('title' => 'la_tab_Custom', 't' => 'in-bulletin/topics/topics_custom', 'priority' => 6),
   						),
   					),

   					'PermItemPrefix'	=>	'TOPIC',

   					'PermTabText'		=>	'In-Bulletin',
   					'PermSection'		=>	Array('main' => 'CATEGORY:in-bulletin:topics_list', 'search' => 'in-bulletin:configuration_search', 'email' => 'in-bulletin:configuration_email', 'custom' => 'in-bulletin:configuration_custom'),

					'Sections'			=>	Array(
						/*'in-bulletin'	=>	Array(
							'parent'		=>	'in-portal:root',
							'icon'			=>	'settings_in-bulletin',
							'label'			=>	'la_title_In-Bulletin',
							'url'			=>	Array('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array('view'),
							'priority'		=>	3.3,
							'container'		=>	true,
							'type'			=>	stTREE,
						),*/

						'in-bulletin:topics'	=>	Array(
							'parent'		=>	'in-portal:users',
							'icon'			=>	'settings_in-bulletin',
							'label'			=>	'la_tab_Topics',
							'url'			=>	Array('t' => 'catalog/advanced_view', 'anchor' => 'tab-bb.showall', 'pass' => 'm'),
							'onclick'		=>	'setCatalogTab(\'bb.showall\')',
							'permissions'	=>	Array('view'),
							'priority'		=>	4,
							'type'			=>	stTREE,
						),

						// topic settings
						'in-bulletin:setting_folder' => Array (
							'parent'		=>	'in-portal:system',
							'icon'			=>	'core:conf',
							'label'			=>	'la_title_In-Bulletin',
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.5,
							'container'		=>	true,
							'type'			=>	stTREE,
						),

						/*'in-bulletin:inbulletin_general'	=>	Array(
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:settings_general',
							'label'			=>	'la_tab_GeneralSettings',
							'url'			=>	Array('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array('view', 'edit'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),*/

						'in-bulletin:configuration_output'	=>	Array(
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:settings_output',
							'label'			=>	'la_tab_ConfigOutput',
							'url'			=>	Array('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array('view', 'edit'),
							'priority'		=>	4,
							'type'			=>	stTREE,
						),

						'in-bulletin:configuration_search'	=>	Array(
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:settings_search',
							'label'			=>	'la_tab_ConfigSearch',
							'url'			=>	Array('t' => 'config/config_search', 'module_key' => 'topics', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array('view', 'edit'),
							'priority'		=>	5,
							'type'			=>	stTREE,
						),


						'in-bulletin:configuration_email'	=>	Array(
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:settings_email',
							'label'			=>	'la_tab_ConfigE-mail',
							'url'			=>	Array('t' => 'config/config_email', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array('view', 'edit'),
							'priority'		=>	6,
							'type'			=>	stTREE,
						),

						'in-bulletin:configuration_custom'	=>	Array(
							'parent'		=>	'in-bulletin:setting_folder',
							'icon'			=>	'core:settings_custom',
							'label'			=>	'la_tab_ConfigCustom',
							'url'			=>	Array('t' => 'custom_fields/custom_fields_list', 'cf_type' => 3, 'pass_section' => true, 'pass' => 'm,cf'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
							'priority'		=>	7,
							'type'			=>	stTREE,
						),
					),

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array('show_active','show_pending','show_disabled'), 'type' => WHERE_FILTER),
													Array('mode' => 'AND', 'filters' => Array('show_new'), 'type' => HAVING_FILTER),
													Array('mode' => 'AND', 'filters' => Array('show_hot'), 'type' => HAVING_FILTER),
													Array('mode' => 'AND', 'filters' => Array('show_pop'), 'type' => HAVING_FILTER),
													Array('mode' => 'AND', 'filters' => Array('show_pick'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array(
													'show_active'	=>	Array('label' =>'la_Active', 'on_sql' => '', 'off_sql' => '%1$s.Status != 1' ),
													'show_pending'	=>	Array('label' => 'la_Pending', 'on_sql' => '', 'off_sql' => '%1$s.Status != 2'  ),
													'show_disabled'	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Status != 0'  ),
													's1'	=>	Array(),
													'show_new'	=>	Array('label' => 'la_Text_New', 'on_sql' => '', 'off_sql' => '`IsNew` != 1'  ),
													'show_hot'	=>	Array('label' => 'la_Text_Hot', 'on_sql' => '', 'off_sql' => '`IsHot` != 1'  ),
													'show_pop'	=>	Array('label' => 'la_Text_Pop', 'on_sql' => '', 'off_sql' => '`IsPop` != 1'  ),
													'show_pick'	=>	Array('label' => 'la_prompt_EditorsPick', 'on_sql' => '', 'off_sql' => '%1$s.`EditorsPick` != 1'  ),
												)
											),

					'CatalogSelectorName'	=>	'topiclist',

					'ItemPropertyMappings'	=>	Array(
														'NewDays'		=>	'Topic_NewDays',	// number of days item to be NEW
														'MinPopVotes'	=>	'Topic_MinPopVotes',	// minimum number of votes for an item to be POP
														'MinPopRating'	=>	'Topic_MinPopRating',	// minimum rating for an item to be POP
														'MaxHotNumber'	=>	'Topic_MaxHotNumber',	// maximum number of HOT items

														'HotLimit'		=>	'Topic_HotLimit',	// variable name in inp_Cache table
														'ClickField'	=>	'Views',			// item click count is stored here (in item table)
												),

					'ItemType'			=>	3,	// this is used when relation to product is added from in-portal and via-versa

					'ViewMenuPhrase'	=>	'la_title_Topics',
					'CatalogTabIcon' => 'in-bulletin:icon16_topic.gif',
					'UsePendingEditing'	=>	true, // item editing is controlled by TOPIC.ADD/EDIT, TOPIC.ADD/EDIT.PENDING permissions

					'StatisticsInfo'	=>	Array(
													'pending'	=>	Array(
																			'icon'		=>	'icon16_topic_pending.gif',
																			'label'		=>	'la_Text_Topics',
																			'js_url' 	=>	'#url#',
																			'url'		=>	Array('t' => 'catalog/advanced_view', 'SetTab' => 'bb', 'pass' => 'm,bb.showall', 'bb.showall_event' => 'OnSetFilterPattern', 'bb.showall_filters' => 'show_active=0,show_pending=1,show_disabled=0,show_new=1,show_hot=1,show_pop=1,show_pick=1'),
																			'status'	=>	STATUS_PENDING,
																	),
											),

					'TableName'			=>	TABLE_PREFIX.'Topic',

					'CalculatedFields' => Array (
						'' => Array (
							'UserName' 		=> 'IF (ISNULL(u.Login), IF (%1$s.OwnerId = -1, "root", IF (%1$s.OwnerId = -2, "Guest", "n/a")), u.Login)',
							'CategoryId'	=>	TABLE_PREFIX.'%3$sCategoryItems.CategoryId',
							'Filename' => TABLE_PREFIX.'%3$sCategoryItems.Filename',
							'PrimaryCat'	=> TABLE_PREFIX.'%3$sCategoryItems.PrimaryCat',
							'ParentPath' => TABLE_PREFIX.'Category.ParentPath',

							'SameImages'	=>	'img.SameImages',
							'LocalThumb'	=>	'img.LocalThumb',
							'ThumbPath'		=>	'img.ThumbPath',
							'ThumbUrl'		=>	'img.ThumbUrl',
							'LocalImage'	=>	'img.LocalImage',
							'LocalPath'		=>	'img.LocalPath',
							'FullUrl'		=>	'img.Url',

							'LastPoster' => 'IF (ISNULL(last_post.PosterAlias), "Guest", last_post.PosterAlias)',
							'LastPosterId' => 'last_post.CreatedById',
						),
					),

					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Category ON '.TABLE_PREFIX.'Category.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'Images img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'PermCache perm ON perm.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.OwnerId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'Posting last_post ON last_post.PostingId = %1$s.LastPostId
															LEFT JOIN '.TABLE_PREFIX.'%3$sTopicCustomData cust ON %1$s.ResourceId = cust.ResourceId',
											), // key - special, value - list select sql

					'ListSortings'	=> 	Array(
												'' => Array(
															'ForcedSorting' => Array('Priority' => 'desc'),
															'Sorting' => Array('TopicText' => 'asc'),
														)
										),
					'ItemSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Category ON '.TABLE_PREFIX.'Category.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'Images img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.OwnerId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'Posting last_post ON last_post.PostingId = %1$s.LastPostId
															LEFT JOIN '.TABLE_PREFIX.'%3$sTopicCustomData cust ON %1$s.ResourceId = cust.ResourceId'),

					'SubItems'			=>	Array('bb-rev', 'bb-ci', 'bb-rel', 'bb-img', 'bb-cdata', 'bb-fav', 'bb-post'),

					'Fields' => Array (
							            'TopicId'				=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
							            'NotifyOwnerOnChanges'	=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'lu_No', 1 => 'lu_Yes'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
							            'Modified'				=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'not_null' => 1, 'default' => '#NOW#'),
							            'TopicText'				=>	Array('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
							            'AutomaticFilename'		=>	Array('type' => 'int', 'not_null' => 1, 'default' => 1),
							            'Posts'					=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
							            'Views'					=>	Array('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%d', 'not_null' => 1, 'default' => 0),
							            'EditorsPick'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
							            'Status'				=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2),
							            'Priority'				=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
							            'OwnerId'				=>	Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array(-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'not_null' => 1, 'required' => 1, 'default' => -1),
							            'ModifiedById'			=>	Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array(-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'not_null' => 1, 'default' => 0),
							            'ResourceId'			=>	Array('type' => 'int', 'default' => null),
							            'TopicType'				=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(0 => 'la_Yes', 1 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
							            'CreatedOn'				=>	Array('type' => 'double', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#', 'not_null' => 1),
							            'CachedReviewsQty'		=>	Array('type' => 'int' ,'not_null' => 1, 'default' => 0),
							            'CachedRating'			=>	Array('type' => 'string', 'not_null' => 1, 'default' => 0),
							            'CachedVotesQty'		=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
							            'NewItem'				=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1,'default' => 2),
							            'PopItem'				=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1,'default' => 2),
							            'HotItem'				=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1,'default' => 2),
							            'PostedBy'				=>	Array('type' => 'string', 'not_null' => 1, 'default' => ''),
							            'OrgId'					=>	Array('type' => 'int', 'default' => null),
							            'LastPostId'			=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
							            'LastPostDate'			=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
							            'TodayDate'				=>	Array('type' => 'string', 'default' => null),
							            'TodayPosts'			=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
							            'MetaKeywords'			=>	Array('type' => 'string', 'default' => null),
							            'MetaDescription'		=>	Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
								),

					'VirtualFields' => Array (
						'UserName' => Array ('type'=>'string', 'default' => ''),
						'CategoryId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => 0),
						'Filename' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
						'CachedNavbar' => Array ('type' => 'string', 'default' => ''),

						'LastPoster' => Array ('type' => 'string', 'default' => ''),
						'LastPosterId' => Array ('type' => 'int', 'default' => -2),
						'PostingText' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'required' => 1, 'using_fck' => 1, 'allow_html' => 1, 'default' => ''),
						'DisableBBCodes' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
						'DisableSmileys' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
						'ShowSignatures' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 1),

						// for primary image
						'SameImages'	=>	Array('type' => 'string', 'default' => ''),
						'LocalThumb'	=>	Array('type' => 'string', 'default' => ''),
						'ThumbPath'		=>	Array('type' => 'string', 'default' => ''),
						'ThumbUrl'		=>	Array('type' => 'string', 'default' => ''),
						'LocalImage'	=>	Array('type' => 'string', 'default' => ''),
						'LocalPath'		=>	Array('type' => 'string', 'default' => ''),
						'FullUrl'		=>	Array('type' => 'string', 'default' => ''),
					),

					'Grids'	=> Array(
										'Default'	=>	Array(
																'Icons' => Array(1 => 'icon16_topic.gif', 2 => 'icon16_topic_pending.gif', 0 => 'icon16_topic_disabled.gif', 'HOT' => 'icon16_topic_hot.gif', 'POP' => 'icon16_topic_pop.gif', 'NEW' => 'icon16_topic_new.gif', 'PICK' => 'icon16_topic_pick.gif'),
																'Fields' => Array(
																					'TopicId'				=>	Array('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																					'TopicText'				=>	Array('title' => 'la_col_TopicText', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter'),
																					'UserName'				=>	Array('title' => 'la_col_PostedBy', 'filter_block' => 'grid_like_filter'),
																					'Modified'	=>	Array('title' => 'la_col_ModifiedDate', 'filter_block' => 'grid_date_range_filter'),
																					'Posts'					=>	Array('title' => 'la_col_Posts', 'filter_block' => 'grid_range_filter'),
																					'Views'					=>	Array('title' => 'la_col_Views', 'filter_block' => 'grid_range_filter'),
																			),
														),

										'Radio'	=>	Array(
																'Icons' => Array(1 => 'icon16_topic.gif', 2 => 'icon16_topic_pending.gif', 0 => 'icon16_topic_disabled.gif', 'HOT' => 'icon16_topic_hot.gif', 'POP' => 'icon16_topic_pop.gif', 'NEW' => 'icon16_topic_new.gif', 'PICK' => 'icon16_topic_pick.gif'),
																'Selector' => 'radio',
																'Fields' => Array(
																					'TopicId'				=>	Array('title' => 'la_col_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter'),
																					'TopicText'				=>	Array('title' => 'la_col_TopicText', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter'),
																					'UserName'				=>	Array('title' => 'la_col_PostedBy', 'filter_block' => 'grid_like_filter'),
																					'Modified'				=>	Array('title' => 'la_col_ModifiedDate', 'filter_block' => 'grid_date_range_filter'),
																					'Posts'					=>	Array('title' => 'la_col_Posts', 'filter_block' => 'grid_range_filter'),
																					'Views'					=>	Array('title' => 'la_col_Views', 'filter_block' => 'grid_range_filter'),
																			),
														),
								),

					'ConfigMapping' => 	Array(
												'PerPage'				=>	'Perpage_Topics',
												'ShortListPerPage'		=>	'Perpage_Topics_Short',
												'ForceEditorPick'		=>	'Topic_EditorPicksAbove',
												'DefaultSorting1Field'	=>	'Topic_SortField',
												'DefaultSorting2Field'	=>	'Topic_SortField2',
												'DefaultSorting1Dir'	=>	'Topic_SortOrder',
												'DefaultSorting2Dir'	=>	'Topic_SortOrder2',

												'RatingDelayValue'		=>	'topic_RatingDelay_Value',
												'RatingDelayInterval'	=>	'topic_RatingDelay_Interval',
										),
			);


?>