# ===== v 4.3.9 =====
ALTER TABLE Emoticon
	ADD EmotionImage VARCHAR(255) NOT NULL,
	ADD INDEX (EmotionImage),
	DROP ImageId;

UPDATE Emoticon SET EmotionImage = CONCAT('0_',EmoticonId,'.gif') WHERE EmoticonId < 21;

# ===== v 5.0.0 =====
CREATE TABLE Polls (
  PollId int(11) NOT NULL auto_increment,
  `Name` varchar(255) NOT NULL default '',
  l1_Question text,
  l2_Question text,
  l3_Question text,
  l4_Question text,
  l5_Question text,
  Image varchar(255) NOT NULL default '',
  CreatedOn int(11) unsigned NOT NULL,
  StartDate int(11) unsigned NOT NULL,
  EndDate int(11) unsigned default NULL,
  Priority tinyint(4) NOT NULL default '0',
  RequireLogin tinyint(4) NOT NULL default '0',
  AllowMultipleVotings tinyint(4) NOT NULL default '1',
  AllowComments tinyint(4) NOT NULL default '1',
  `Status` tinyint(4) NOT NULL default '1',
  CachedVotesQty int(11) NOT NULL,
  PRIMARY KEY  (PollId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY StartDate (StartDate),
  KEY EndDate (EndDate)
);

CREATE TABLE PollsAnswers (
  AnswerId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL,
  l1_Answer text,
  l2_Answer text,
  l3_Answer text,
  l4_Answer text,
  l5_Answer text,
  VotesQty int(11) NOT NULL,
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (AnswerId),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY VoteCount (VotesQty),
  KEY PollId (PollId)
);

CREATE TABLE PollsComments (
  CommentId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL,
  AnswerId int(11) default NULL,
  CreatedById int(11) NOT NULL default '-2',
  GuestName varchar(255) NOT NULL,
  GuestEmail varchar(255) NOT NULL,
  CommentBody text,
  CreatedOn int(11) NOT NULL,
  UserIP varchar(255) NOT NULL,
  Priority int(11) NOT NULL,
  `Status` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (CommentId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY CreatedOn (CreatedOn),
  KEY AnswerId (AnswerId),
  KEY PollId (PollId),
  KEY CreatedById (CreatedById)
);

CREATE TABLE PollsStatistics (
  StatisticsId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL default '0',
  AnswerId int(11) NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-2',
  UserIP varchar(255) NOT NULL,
  AnswerDate int(10) unsigned default NULL,
  PRIMARY KEY  (StatisticsId),
  KEY AnswerId (AnswerId,PollId),
  KEY CreatedById (CreatedById),
  KEY UserIP (UserIP)
);

INSERT INTO ConfigurationAdmin VALUES ('poll_CommentDelay_Value', 'la_Text_Polls', 'la_prompt_DupPollComments', 'text', '', '', 60.1, 1, 1);
INSERT INTO ConfigurationAdmin VALUES ('poll_CommentDelay_Interval', 'la_Text_Polls', 'la_prompt_DupPollComments', 'select', '', '1=la_Text_Second,60=la_Text_Minute,3600=la_Text_Hour,86400=la_Text_Day,604800=la_Text_Week,2419200=la_Text_Month,29030400=la_text_Year', 60.2, 2, 1);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'poll_CommentDelay_Interval', '60', 'In-Bulletin', 'in-bulletin:configuration_output');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'poll_CommentDelay_Value', '10', 'In-Bulletin', 'in-bulletin:configuration_output');

UPDATE Category SET Template = '/in-bulletin/designs/section' WHERE Template = 'inbulletin/index';
UPDATE Category SET CachedTemplate = '/in-bulletin/designs/section' WHERE CachedTemplate = 'inbulletin/index';

UPDATE ConfigurationValues SET VariableValue = '/in-bulletin/designs/section' WHERE VariableName = 'bb_CategoryTemplate';
UPDATE ConfigurationValues SET VariableValue = 'in-bulletin/designs/detail' WHERE VariableName = 'bb_ItemTemplate';

INSERT INTO Permissions VALUES (DEFAULT, 'in-bulletin:topics.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-bulletin:setting_folder.view', 11, 1, 1, 0);
DELETE FROM Permissions WHERE Permission LIKE 'in-bulletin:inbulletin_general.%';

UPDATE Phrase SET Module = 'In-Bulletin' WHERE ((Phrase LIKE '%Topic%' OR Phrase LIKE '%Post%' OR Phrase LIKE '%Forum%' OR Phrase LIKE '%Censor%' OR Phrase LIKE '%Smiley%' OR Phrase = 'la_title_In-Bulletin') AND (Module = 'Core'));
