<?php
/**
* @version	$Id: private_message_body_eh.php 16515 2017-01-20 14:12:04Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class PrivateMessageBodyEventHandler extends kDBEventHandler {

		/**
		 * Sets default values
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemCreate(kEvent $event)
		{
			parent::OnBeforeItemCreate($event);

			/** @var kDBItem $object */
			$object = $event->getObject();

			// set post options
			/** @var PostHelper $post_helper */
			$post_helper = $this->Application->recallObject('PostHelper');

			$options_map = $post_helper->getOptionsMap();
			$post_options = $object->GetDBField('Options');
			foreach ($options_map as $option_name => $field_name) {
				$option_value = $object->GetDBField($field_name);
				$post_helper->SetPostOption($option_name, $option_value, $post_options);
			}
			$object->SetDBField('Options', $post_options);
		}

		/**
		 * Deletes message body only when no message is using it
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemDelete(kEvent $event)
		{
			parent::OnBeforeItemDelete($event);

			/** @var kDBItem $object */
			$object = $event->getObject();

			if ( $object->GetDBField('ReferenceCount') > 0 ) {
				$event->status = kEvent::erFAIL;
			}
		}
	}