<?php
/**
* @version	$Id: install.php 16515 2017-01-20 14:12:04Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/
$module_folder = 'modules/in-bulletin';

if ( !defined('IS_INSTALL') ) {
	// separate module install
	define('IS_INSTALL', 1);
	define('ADMIN', 1);
	define('FULL_PATH', realpath(dirname(__FILE__) . '/../..'));

	include_once(FULL_PATH . '/core/kernel/startup.php');
	require_once FULL_PATH . '/core/install/install_toolkit.php';

	$constants_file = FULL_PATH . '/' . $module_folder . '/constants.php';

	if ( file_exists($constants_file) ) {
		require_once $constants_file;
	}

	$toolkit = new kInstallToolkit();
}
else {
	// install, using installation wizard
	/** @var kInstallToolkit $toolkit */
	$toolkit =& $this->toolkit;
}

$application =& kApplication::Instance();
$application->Init();

if ( $application->RecallVar('user_id') != USER_ROOT ) {
	die('restricted access!');
}

$category =& $toolkit->createModuleCategory('Forums', 'Discussion Forums', '#in-bulletin/section_design#', 'in-bulletin/img/menu_topics.gif');

$toolkit->RunSQL('/' . $module_folder . '/install/install_schema.sql');
$toolkit->RunSQL('/' . $module_folder . '/install/install_data.sql', '{TopicCatId}', $category->GetID());
$toolkit->ImportLanguage('/' . $module_folder . '/install/english', isset($constants_file));

$toolkit->SetModuleRootCategory(basename($module_folder), $category->GetID());

//$toolkit->linkCustomFields(basename($module_folder), 'bb', 3); // to create Custom Fields for Topics
$toolkit->linkCustomFields('KERNEL', 'c', 1); // to create ItemTemplate custom field
$toolkit->setModuleItemTemplate($category, 'bb', '#in-bulletin/item_design#');

$toolkit->finalizeModuleInstall($module_folder, true);
