<?php
/**
* @version	$Id: private_message_body_config.php 16384 2016-08-11 08:15:32Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'private-message-body',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'PrivateMessageBodyEventHandler', 'file' => 'private_message_body_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),

	'IDField' => 'PMBodyId',

	'TitleField' => 'Subject',

	'TableName' => TABLE_PREFIX.'PrivateMessageBody',

	'ForeignKey' => 'PMBodyId',
	'ParentTableKey' => 'PMBodyId',
	'ParentPrefix' => 'private-message',
	'AutoDelete' => true,
	'AutoClone' => true,

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'Fields' => Array (
		'PMBodyId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Subject' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'Body' => Array ('type' => 'string', 'default' => NULL),
		'Options' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'ReferenceCount' => Array ('type' => 'int', 'not_null' => 1, 'default' => 2),
	),

	'VirtualFields' => Array (
		'DisableBBCodes' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
		'DisableSmileys' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
		'ShowSignatures' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 1),
	),
);