<?php
/**
* @version	$Id: poll_tp.php 16515 2017-01-20 14:12:04Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class PollTagProcessor extends kDBTagProcessor {

		/**
		 * Allows to tell if user from current ip has voted already for current poll
		 *
		 * @param Array $params
		 * @return bool
		 */
		function HasVoted($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			if ( !$object->GetDBField('AllowMultipleVotings') ) {
				$where_clause = Array (
					'PollId = ' . $object->GetID(),
					'CreatedById = ' . $this->Application->RecallVar('user_id'),
					'UserIP = ' . $this->Conn->qstr($this->Application->getClientIp()),
				);

				$sql = 'SELECT StatisticsId
						FROM ' . TABLE_PREFIX . 'PollsStatistics
						WHERE (' . implode(') AND (', $where_clause) . ')';

				return $this->Conn->GetOne($sql) > 0;
			}

			return false;
		}

		/**
		 * Allows to tell if user from current ip has voted already for current poll
		 *
		 * @param Array $params
		 * @return bool
		 */
		function HasCommented($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			/** @var SpamHelper $spam_helper */
			$spam_helper = $this->Application->recallObject('SpamHelper');

			$spam_helper->InitHelper($object->GetID(), 'PollComment', 0); // PollId used for SpamControl only

			return $spam_helper->InSpamControl();
		}

		/**
		 * Prints out only filled in answers of current poll
		 *
		 * @param Array $params
		 * @return string
		 */
		function PrintPoll($params)
		{
			$object = $this->getObject($params);

			$sql = 'SELECT COUNT(AnswerNum), AnswerNum
					FROM '.TABLE_PREFIX.'PollsStatistics
					WHERE PollId = '.$object->GetID().'
					GROUP BY AnswerNum';
			$statistics = $this->Conn->GetCol($sql, 'AnswerNum');

			$total_votes = array_sum($statistics);

			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $params['render_as'];

			$i = 1;
			$ret = '';
			while ($i < 8) {
				$answer = $object->GetDBField('Answer'.$i);
				if ($answer) {
					$answer_votes = isset($statistics[$i]) ? $statistics[$i] : 0;
					if ($total_votes > 0) {
						$block_params['percent'] = round((100 * $answer_votes) / $total_votes, 0);
					}
					else {
						$block_params['percent'] = 0;
					}

					$block_params['answer'] = $answer;
					$block_params['answer_num'] = $i;

					$ret .= $this->Application->ParseBlock($block_params);
				}
				$i++;
			}

			return $ret;
		}

		/**
		 * Prints link to comments of of current poll
		 *
		 * @param Array $params
		 * @return string
		 */
		function CommentsLink($params)
		{
			$object = $this->getObject($params);

			$params['pass'] = 'm,poll';
			$params['poll_id']	= $object->GetID();

		 	return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}
	}