<?php
/**
* @version	$Id: topics_tag_processor.php 16515 2017-01-20 14:12:04Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class TopicsTagProcessor extends kCatDBTagProcessor {

		function TopicLink($params)
		{
			return $this->ItemLink($params, 'topic');
		}

		function ListTopics($params)
		{
			return $this->PrintList2($params);
		}

		function PostingLink($params)
		{
			$item_id = getArrayValue($params, 'posting_id');
			if (!$item_id) {
				$item_id = $this->Application->GetVar($this->Prefix.'_post_id');
			}
			$params[$this->Prefix.'_post_id'] = $item_id;
			return $this->TopicLink($params);
		}

		function PostingDeleteLink($params)
		{
			$params['Action'] = 'bb_post_delete';
			return $this->PostingLink($params);
		}

		/**
		 * Returns topic replies count
		 *
		 * @param Array $params
		 * @return int
		 */
		function TopicReplies($params)
		{
			$object = $this->getObject($params);

			// -1 - don't count post created together with topic
			return $object->GetDBField('Posts') ? $object->GetDBField('Posts') - 1 : 0;
		}

		/**
		 * Returns topic lock statis
		 *
		 * @param Array $params
		 * @return bool
		 */
		function IsLocked($params)
		{
			$object = $this->getObject($params);

			return $object->GetDBField('TopicType') == 0;
		}

		function LockToggleLink($params)
		{
			$params[$this->Prefix.'_event'] = 'OnTopicLockToggle';
			$params['pass'] = 'm,'.$this->Prefix;

			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

		/**
		 * Detects if current user is subscribed to new topics in this category
		 *
		 * @param Array $params
		 * @return bool
		 */
		function SubscribedToCategoryTopics($params)
		{
			static $subscribed = null;

			if ( !isset($subscribed) ) {
				/** @var PostHelper $post_helper */
				$post_helper = $this->Application->recallObject('PostHelper');

				$subscribed = $post_helper->getSubscriptionManager('CategoryTopics')->subscribed();
			}

			return $subscribed;
		}

		/**
		 * Detects if current user is subscribed to this topic posts
		 *
		 * @param Array $params
		 * @return bool
		 */
		function SubscribedToTopicPosts($params)
		{
			static $subscribed = null;

			if ( !isset($subscribed) ) {
				/** @var kDBItem $object */
				$object = $this->getObject($params);

				/** @var PostHelper $post_helper */
				$post_helper = $this->Application->recallObject('PostHelper');

				$subscribed = $post_helper->getSubscriptionManager('TopicPosts', Array ($object->GetID()))->subscribed();
			}

			return $subscribed;
		}
	}