<?php
/**
* @version	$Id: links_config.php 15759 2013-05-16 15:48:46Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'l',
					'ItemClass'			=>	Array ('class' => 'kCatDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kCatDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'LinksEventHandler', 'file' => 'links_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'LinkTagProcessor', 'file' => 'link_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'ConfigPriority' => 0,

					'RewritePriority' => 101,
					'RewriteListener' => 'CategoryItemRewrite:RewriteListener',

					'Hooks' => Array (
						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => 'cdata',
							'DoSpecial' => '*',
							'DoEvent' => 'OnDefineCustomFields',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '#file',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'rev',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'fav',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'rel',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'img',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'ci',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						Array (
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => 'captcha',
							'DoSpecial' => '*',
							'DoEvent' => 'OnPrepareCaptcha',
						),
					),

					'QueryString'		=>	Array (
												1	=>	'id',
												2	=>	'Page',
												3	=>	'PerPage',
												4	=>	'event',
												5	=>	'mode',
											),

					'AggregateTags' => Array (
						Array (
							'AggregateTo' => 'l',
							'AggregatedTagName' => 'ListLinks',
							'LocalTagName' => 'PrintList2',
						),
					),

					'CatalogItem'			=>	true,
					'AdminTemplatePath'		=>	'links',
					'AdminTemplatePrefix'	=>	'links_',
					'SearchConfigPostfix' 	=>	'links',

   					'IDField'			=>	'LinkId',
   					'StatusField'		=>	Array ('Status'),	// field, that is affected by Approve/Decline events

   					'ItemType'			=>	4,

   					'StatisticsInfo'	=>	Array (
													'pending'	=>	Array (
																			'icon'		=>	'icon16_link_pending.png',
																			'label'		=>	'la_Text_Links',
																			'js_url' 	=>	'#url#',
																			'url'		=>	Array ('t' => 'catalog/advanced_view', 'SetTab' => 'l', 'pass' => 'm,l.showall', 'l.showall_event' => 'OnSetFilterPattern', 'l.showall_filters' => 'show_active=0,show_pending=1,show_disabled=0,show_new=1,show_hot=1,show_pop=1,show_pick=1'),
																			'status'	=>	STATUS_PENDING,
																	),
											),

   					'TitlePhrase'		=>	'la_Text_Link',	// phrase used to specify item type in relationship list

   					'ViewMenuPhrase'	=>	'la_title_Links',
   					'CatalogTabIcon' => 'in-link:icon16_links.png',
   					'UsePendingEditing'	=>	true, // item editing is controlled by LINK.ADD/EDIT, LINK.ADD/EDIT.PENDING permissions

   					'CatalogSelectorName'	=>	'linklist', // used in old catalog section

   					'ItemPropertyMappings'	=>	Array (
													'NewDays'		=>	'Link_NewDays',		// number of days item to be NEW
													'MinPopVotes'	=>	'Link_MinPopVotes',	// minimum number of votes for an item to be POP
													'MinPopRating'	=>	'Link_MinPopRating',	// minimum rating for an item to be POP
													'MaxHotNumber'	=>	'Link_MaxHotNumber',	// maximum number of HOT items

													'HotLimit'		=>	'Link_HotLimit',	// variable name in inp_Cache table
													'ClickField'	=>	'Hits',				// item click count is stored here (in item table)
												),

   					'TitleField'		=>	'Name',

   					'TitlePresets'		=>	Array (
												'default' => Array (
													'new_status_labels'	=> Array ('l' => '!la_title_AddingLink!'),
													'edit_status_labels' => Array ('l' => '!la_title_EditingLink!'),
													'new_titlefield' => Array ('l' => '!la_title_NewLink!'),
													),

												'links_edit' => Array (
													'prefixes' => Array ('l'), 'format' => "#l_status# '#l_titlefield#' - !la_title_General!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
													),

												'link_list' => Array (
													'prefixes' => Array ('c_List', 'l_List'),
													'format' =>	"!la_title_Categories! (#c_recordcount#) - !la_title_Links!",
													'toolbar_buttons' => Array (),
													),

												'links_categories' => Array (
													'prefixes' => Array ('l', 'l-ci_List'), 'format' => "#l_status# '#l_titlefield#' - !la_title_Categories!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'delete', 'setprimary',),
													),

												'links_relations' => Array (
													'prefixes' => Array ('l'), 'format' => "#l_status# '#l_titlefield#' - !la_title_Relations!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'approve', 'decline', 'view', 'dbl-click'),
													),

												'links_images' => Array (
													'prefixes' => Array ('l'), 'format' => "#l_status# '#l_titlefield#' - !la_title_Images!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'move_up', 'move_down', 'setprimary', 'view', 'dbl-click'),
													),

												'links_files' => Array (
													'prefixes' => Array ('l'), 'format' => "#l_status# '#l_titlefield#' - !la_title_Files!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'view', 'dbl-click'),
													),

												'links_reviews'	=> Array (
													'prefixes' => Array ('l'), 'format' => "#l_status# '#l_titlefield#' - !la_title_Reviews!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'approve', 'decline', 'move_up', 'move_down', 'view', 'dbl-click'),
													),

												'links_custom' => Array (
													'prefixes' => Array ('l'), 'format' => "#l_status# '#l_titlefield#' - !la_title_Custom!",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
													),

												'images_edit' => Array (
													'prefixes' => Array ('l', 'l-img'),
													'new_status_labels'		=>	Array ('l-img' => '!la_title_Adding_Image!'),
													'edit_status_labels'	=>	Array ('l-img' => '!la_title_Editing_Image!'),
													'new_titlefield'		=>	Array ('l-img' => '!la_title_New_Image!'),
													'format'				=>	"#l_status# '#l_titlefield#' - #l-img_status# '#l-img_titlefield#'",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
													),

												'file_edit' => Array (
													'prefixes' => Array ('l', 'l-file'),
													'new_status_labels' => Array ('l-file' => "!la_title_AddingFile!"),
													'edit_status_labels' => Array ('l-file' => '!la_title_EditingFile!'),
													'new_titlefield' => Array ('l-file' => '!la_title_NewFile!'),
													'format' => "#l_status# '#l_titlefield#' - #l-file_status# '#l-file_titlefield#'",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
													),

												'reviews_edit' => Array (
													'prefixes' => Array ('l', 'l-rev'),
													'new_status_labels'	=>	Array ('l-rev' =>"!la_title_Adding_Review! '!la_title_New_Review!'"),
													'edit_status_labels' =>	Array ('l-rev' => '!la_title_Editing_Review!'),
													'format' =>	"#l_status# '#l_titlefield#' - #l-rev_status#",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
													),

												'relations_edit' =>	Array (
													'prefixes' => Array ('l', 'l-rel'),
													'new_status_labels' => Array ('l-rel' =>"!la_title_Adding_Relationship! '!la_title_New_Relationship!'"),
													'edit_status_labels' =>	Array ('l-rel' => '!la_title_Editing_Relationship!'),
													'format' =>	"#l_status# '#l_titlefield#' - #l-rel_status#",
													'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
													),

												'links_export' => Array ('format' => '!la_title_LinksExport!'),

												'links_import' => Array ('format' => '!la_title_ImportLinks!'),

												'duplicate_links' => Array (
													'prefixes' => Array ('l.duplicates_List'), 'format' => "!la_title_DuplicateLinks! - %s",
													'toolbar_buttons' => Array ('edit', 'view', 'dbl-click'),
													),

												'duplicate_links_view' => Array (
													'prefixes' => Array ('l.duplicates-sub_List'), 'format' => "!la_title_Links!",
													'toolbar_buttons' => Array ('cancel', 'edit', 'delete', 'merge_links', 'view', 'dbl-click'),
													),

												'tree_in-link' => Array ('format' => '!la_Text_Version! '.$this->Application->findModule('Name', 'In-Link', 'Version')),
											),

					'EditTabPresets' => Array (
   						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-link/links/links_edit', 'priority' => 1),
							'categories' => Array ('title' => 'la_tab_Categories', 't' => 'in-link/links/links_categories', 'priority' => 2),
							'relations' => Array ('title' => 'la_tab_Relations', 't' => 'in-link/links/links_relations', 'priority' => 3),
							'images' => Array ('title' => 'la_tab_Images', 't' => 'in-link/links/links_images', 'priority' => 4),
							'files' => Array ('title' => 'la_tab_Files', 't' => 'in-link/links/links_files', 'priority' => 5),
							'reviews' => Array ('title' => 'la_tab_Reviews', 't' => 'in-link/links/links_reviews', 'priority' => 6),
							'custom' => Array ('title' => 'la_tab_Custom', 't' => 'in-link/links/links_custom', 'priority' => 7),
   						),
   					),

					'PermItemPrefix'	=>	'LINK',

					'PermTabText'		=>	'In-Link',
					'PermSection'		=>	Array ('main' => 'CATEGORY:in-link:links_list', 'search' => 'in-link:configuration_search', 'custom' => 'in-link:configuration_custom'),

					'Sections'			=>	Array (
						'in-link'	=>	Array (
							'parent'		=>	'in-portal:root',
							'icon'			=>	'settings_in-link',
							'label'			=>	'la_title_In-Link',
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	2.3,
							'container'		=>	true,
							'type'			=>	stTREE,
						),

						'in-link:links'	=>	Array (
							'parent'		=>	'in-portal:site',
							'icon'			=>	'links',
							'label'			=>	'la_tab_Links',
							'url'			=>	Array ('t' => 'catalog/advanced_view', 'anchor' => 'tab-l.showall', 'pass' => 'm'),
							'onclick'		=>	'setCatalogTab(\'l.showall\')',
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.1,
							'type'			=>	stTREE,
						),

						'in-link:duplicate_checker'	=>	Array (
							'parent'		=>	'in-link',
							'icon'			=>	'duplicate_checker',
							'label'			=>	'la_tab_DuplicateChecker',
							'url'			=>	Array ('t' => 'in-link/duplicate_checker', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	2,
							'type'			=>	stTREE,
						),

						// link settings
						'in-link:setting_folder' => Array (
							'parent'		=>	'in-portal:system',
							'icon'			=>	'conf_directory',
							'label'			=>	'la_title_In-Link',
							'use_parent_header' => 1,
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	3.3,
							'container'		=>	true,
							'type'			=>	stTREE,
						),

						/*'in-link:inlink_general'	=>	Array (
							'parent'		=>	'in-link:setting_folder',
							'icon'			=>	'core:settings_general',
							'label'			=>	'la_tab_GeneralSettings',
							'url'			=>	Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit'),
							'priority'		=>	0.9,
							'type'			=>	stTREE,
						),*/

						'in-link:configuration_output'	=>	Array (
							'parent'		=>	'in-link:setting_folder',
							'icon'			=>	'core:conf_output',
							'label'			=>	'la_tab_ConfigOutput',
							'url'			=>	Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit'),
							'priority'		=>	1,
							'type'			=>	stTREE,
						),

						'in-link:configuration_search'	=>	Array (
							'parent'		=>	'in-link:setting_folder',
							'icon'			=>	'core:conf_search',
							'label'			=>	'la_tab_ConfigSearch',
							'url'			=>	Array ('t' => 'config/config_search', 'module_key' => 'links', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	2,
							'type'			=>	stTREE,
						),

						'in-link:configuration_custom'	=>	Array (
							'parent'		=>	'in-link:setting_folder',
							'icon'			=>	'core:conf_customfields',
							'label'			=>	'la_tab_ConfigCustom',
							'url'			=>	Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 4, 'pass_section' => true, 'pass' => 'm,cf'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),
					),

					'FilterMenu'		=>	Array (
						'Groups' => Array (
							Array ('mode' => 'AND', 'filters' => Array ('show_new'), 'type' => kDBList::HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_hot'), 'type' => kDBList::HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_pop'), 'type' => kDBList::HAVING_FILTER),
							Array ('mode' => 'AND', 'filters' => Array ('show_pick'), 'type' => kDBList::WHERE_FILTER),
						),
						'Filters' => Array (
							'show_new'	=>	Array ('label' => 'la_Text_New', 'on_sql' => '', 'off_sql' => '`IsNew` != 1'  ),
							'show_hot'	=>	Array ('label' => 'la_Text_Hot', 'on_sql' => '', 'off_sql' => '`IsHot` != 1'  ),
							'show_pop'	=>	Array ('label' => 'la_Text_Pop', 'on_sql' => '', 'off_sql' => '`IsPop` != 1'  ),
							'show_pick'	=>	Array ('label' => 'la_prompt_EditorsPick', 'on_sql' => '', 'off_sql' => '%1$s.`EditorsPick` != 1'  ),
						),
					),

					'TableName'			=>	TABLE_PREFIX.'Link',
					'CustomDataTableName' => TABLE_PREFIX . 'LinkCustomData',

					'CalculatedFields' => Array (
						'' => Array (
							'UserName' => 'IF (ISNULL(u.Username), IF (%1$s.CreatedById = ' . USER_ROOT . ', "root", IF (%1$s.CreatedById = ' . USER_GUEST . ', "Guest", "n/a")), IF(u.Username = "", u.Email, u.Username))',
							'CategoryId' => TABLE_PREFIX.'%3$sCategoryItems.CategoryId',
							'Filename' => TABLE_PREFIX.'%3$sCategoryItems.Filename',
							'CategoryFilename' => TABLE_PREFIX.'Categories.NamedParentPath',
							'PrimaryCat'	=> TABLE_PREFIX.'%3$sCategoryItems.PrimaryCat',
							'ParentPath' => TABLE_PREFIX.'Categories.ParentPath',

							'AltName'		=>	'img.AltName',
							'SameImages'	=>	'img.SameImages',
							'LocalThumb'	=>	'img.LocalThumb',
							'ThumbPath'		=>	'img.ThumbPath',
							'ThumbUrl'		=>	'img.ThumbUrl',
							'LocalImage'	=>	'img.LocalImage',
							'LocalPath'		=>	'img.LocalPath',
							'FullUrl'		=>	'img.Url',
						),
					),

					'CacheModRewrite' => true,

					'AggregatedCalculatedFields' => Array (

												'duplicates'	=>	Array (
																		'DupeCount'	=>	'COUNT(*)',
																	),
										),

					'ListSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															{PERM_JOIN}
															LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.CreatedById = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'%3$sLinkCustomData cust ON %1$s.ResourceId = cust.ResourceId',

											), // key - special, value - list select sql

					'ListSortings'	=> 	Array (
												'' => Array (
															'ForcedSorting' => Array ('EditorsPick' => 'desc', 'Priority' => 'desc'),
															'Sorting' => Array ('Name' => 'asc', 'Description' => 'desc'),
														)
										),
					'ItemSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
															LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
															LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.CreatedById = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'%3$sLinkCustomData cust ON %1$s.ResourceId = cust.ResourceId'),

					'SubItems'			=>	Array ('l-rev', 'l-ci', 'l-rel', 'l-img', 'l-cdata', 'l-fav', 'l-file'),

					'Fields' => Array (
			            'LinkId'			=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
			            'Name'				=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'required' => 1, 'max_len' => 255, 'default' => ''),
						'AutomaticFilename' =>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
			            'Description'		=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'using_fck' => 1, 'default' => null),
			            'Url'				=>	Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
			            'CreatedOn'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			            'Modified'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			            'Expire'			=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
			            'Hits'				=>	Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%d', 'not_null' => 1, 'default' => 0),
			            'CachedRating'		=>	Array ('type' => 'string', 'not_null' => 1, 'formatter' => 'kFormatter', 'default' => 0),
			            'CachedVotesQty'	=>	Array ('type' => 'int', 'formatter' => 'kFormatter', 'not_null' => 1, 'default' => 0),
			            'CachedReviewsQty'	=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'CreatedById' => Array (
			            	'type' => 'int',
			            	'formatter' => 'kLEFTFormatter',
			            	'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			            	'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE %s',
			            	'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD,
							'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			            	'sample_value' => 'Guest', 'required' => 1, 'default' => NULL,
						),
			            'ModifiedById'		=>	Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Users WHERE %s', 'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD, 'default' => NULL),
			            'Priority'			=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			            'Status'			=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 2,
						),
			            'EditorsPick'		=>	Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
						),
			            'ResourceId'		=>	Array ('type' => 'int', 'default' => null),
						'HotItem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
						'PopItem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
						'NewItem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
			            'OrgId'				=>	Array ('type' => 'int', 'default' => null),
			            'CustomTemplate'	=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			            'MetaKeywords'			=>	Array ('type' => 'string', 'default' => null),
						'MetaDescription'		=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
						'ReciprocalLinkFound' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_NotChecked', 1 => 'la_Yes', 2 => 'la_No'), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 0
						),
		        	),

					'VirtualFields'	=> 	Array (
						'Relevance'		=>	Array ('type' => 'float', 'default' => 0),
						'UserName'		=>	Array ('type' => 'string', 'default' => ''),
						'DupeCount'		=>	Array ('type' => 'string', 'default' => ''),

						'ListingTypeId'	=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %1$s FROM '.TABLE_PREFIX.'ListingTypes ORDER BY Name', 'option_title_field' => 'Name', 'option_key_field' => 'ListingTypeId', 'default' => 0),

						'MoreCategories' => Array ('type' => 'string', 'default' => ''),

						// export related fields: begin
						'CategoryId'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => 0),
						'ExportFormat'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CSV', /*2 => 'XML'*/), 'default' => 1),
						'ExportFilename'		=>	Array ('type' => 'string', 'default' => ''),
						'FieldsSeparatedBy'		=>	Array ('type' => 'string', 'default' => ','),
						'FieldsEnclosedBy'		=>	Array ('type' => 'string', 'default' => '"'),
						'LineEndings'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'Windows', 2 => 'UNIX'), 'default' => 1),
						'LineEndingsInside'		=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CRLF', 2 => 'LF'), 'default' => 2),
						'IncludeFieldTitles'	=>	Array (
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
					    	'use_phrases' => 1, 'default' => 1,
						),
						'ExportColumns'			=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
						'AvailableColumns'		=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
						'CategoryFormat'		=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_MixedCategoryPath', 2 => 'la_SeparatedCategoryPath'), 'use_phrases' => 1, 'default' => 1),
						'CategorySeparator'		=>	Array ('type' => 'string', 'error_field' => 'CategoryFormat', 'default' => ':'),
						'IsBaseCategory'		=>	Array (
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
					    	'use_phrases' => 1, 'default' => 0,
						),
						// export related fields: end

						// import related fields: begin
						'FieldTitles'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Automatic', 2 => 'la_Manual'), 'use_phrases' => 1, 'default' => 1),
						'ImportSource'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Upload', 2 => 'la_Local'), 'use_phrases' => 1, 'default' => 2),
						'ImportFilename'		=>	Array ('type' => 'string', 'formatter' => 'kUploadFormatter', 'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => EXPORT_BASE_PATH . '/', 'default' => ''),
						'ImportLocalFilename'	=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'default' => ''),
						'CheckDuplicatesMethod'	=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_IDField', 2 => 'la_OtherFields'), 'use_phrases' => 1, 'default' => 1),
						'ReplaceDuplicates'		=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 0),
						'DuplicateCheckFields'	=>	Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array ('Name' => 'NAME', 'Url' => 'URL'), 'default' => '|Name|Url|'),
						'SkipFirstRow'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 1),
						// import related fields: end

						'ThumbnailImage'		=>	Array ('type' => 'string', 'default' => ''),
						'FullImage'				=>	Array ('type' => 'string', 'default' => ''),
						'ImageAlt'				=>	Array ('type' => 'string', 'default' => ''),

						'Filename'				=>	Array ('type' => 'string', 'default' => ''),
						'CategoryFilename'		=>	Array ('type' => 'string', 'default' => ''),
						'PrimaryCat'			=>	Array ('type' => 'int', 'default' => 0),
						'IsHot'					=>	Array ('type' => 'int', 'default' => 0),
						'IsNew'					=>	Array ('type' => 'int', 'default' => 0),
						'IsPop'					=>	Array ('type' => 'int', 'default' => 0),
						'CachedNavbar'			=>	Array ('type' => 'string', 'default' => ''),
						'ParentPath'			=>	Array ('type' => 'string', 'default' => ''),

						// for primary image
						'AltName'		=>	Array ('type' => 'string', 'default' => ''),
						'SameImages'	=>	Array ('type' => 'string', 'default' => ''),
						'LocalThumb'	=>	Array ('type' => 'string', 'default' => ''),
						'ThumbPath'		=>	Array ('type' => 'string', 'default' => ''),
						'ThumbUrl'		=>	Array ('type' => 'string', 'default' => ''),
						'LocalImage'	=>	Array ('type' => 'string', 'default' => ''),
						'LocalPath'		=>	Array ('type' => 'string', 'default' => ''),
						'FullUrl'		=>	Array ('type' => 'string', 'default' => ''),
					),

					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								0 => 'icon16_link_disabled.png',
								1 => 'icon16_link.png',
								2 => 'icon16_link_pending.png',
								'NEW' => 'icon16_link_new.png',
							),
							'Fields' => Array (
								'LinkId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Name' => Array ('title' => 'column:la_fld_LinkName', 'data_block' => 'grid_catitem_td', 'width' => 200, ),
								'Priority' => Array('filter_block' => 'grid_range_filter', 'width' => 65),
								'Url' => Array ('title' => 'la_col_LinkUrl', 'width' => 200, ),
								'Description' => Array ('first_chars' => 100, 'width' => 100, ),
								'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
								'Hits' => Array ('filter_block' => 'grid_range_filter', 'width' => 60, ),
								'CachedRating' => Array ('title' => 'column:la_fld_Rating', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'CachedVotesQty' => Array ('title' => 'la_col_VoteCount', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'CachedReviewsQty' => Array ('title' => 'la_col_ReviewCount', 'filter_block' => 'grid_range_filter', 'width' => 85, ),
							),
						),

						'Radio' => Array (
							'Icons' => Array (
								0 => 'icon16_link_disabled.png',
								1 => 'icon16_link.png',
								2 => 'icon16_link_pending.png',
								'NEW' => 'icon16_link_new.png',
							),
							'Selector' => 'radio',
							'Fields' => Array (
								'LinkId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'Name' => Array ('title' => 'column:la_fld_LinkName', 'data_block' => 'grid_catitem_td', 'width' => 200, ),
								'Priority' => Array('filter_block' => 'grid_range_filter', 'width' => 65),
								'Url' => Array ('title' => 'la_col_LinkUrl', 'width' => 200, ),
								'Description' => Array ('first_chars' => 100, 'width' => 100, ),
								'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
								'Hits' => Array ('filter_block' => 'grid_range_filter', 'width' => 60, ),
								'CachedRating' => Array ('title' => 'column:la_fld_Rating', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'CachedVotesQty' => Array ('title' => 'la_col_VoteCount', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'CachedReviewsQty' => Array ('title' => 'la_col_ReviewCount', 'filter_block' => 'grid_range_filter', 'width' => 85, ),
							),
						),

						'Duplicates' => Array (
							'Icons' => Array (
								0 => 'icon16_link_disabled.png',
								1 => 'icon16_link.png',
								2 => 'icon16_link_pending.png',
								'NEW' => 'icon16_link_new.png',
							),

							'Fields' => Array (
								'Name' => Array ('title' => 'column:la_fld_LinkName', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
								'Url' => Array ('title' => 'la_col_LinkUrl', 'filter_block' => 'grid_like_filter', 'width' => 300, ),
								'DupeCount' => Array ('title' => 'la_col_DupeCount', 'filter_block' => 'grid_range_filter', 'width' => 100, ),
							),
						),
					),

					'ConfigMapping' => 	Array (
												'PerPage'				=>	'Perpage_Links',
												'ShortListPerPage'		=>	'Perpage_Links_Short',
												'ForceEditorPick'		=>	'Link_ShowPick',
												'DefaultSorting1Field'	=>	'Link_SortField',
												'DefaultSorting2Field'	=>	'Link_SortField2',
												'DefaultSorting1Dir'	=>	'Link_SortOrder',
												'DefaultSorting2Dir'	=>	'Link_SortOrder2',

												'RatingDelayValue'		=>	'link_RatingDelay_Value',
												'RatingDelayInterval'	=>	'link_RatingDelay_Interval',

										),
	);