<?php
/**
* @version	$Id: listings_tag_processor.php 12738 2009-10-20 19:36:22Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ListingsTagProcessor extends kDBTagProcessor  {

	/**
	 * Returns a link for editing product
	 *
	 * @param Array $params
	 * @return string
	 */
	function ListingTypeLink($params)
	{
		$object =& $this->Application->recallObject($this->getPrefixSpecial(), $this->Prefix, $params);

		return $this->Application->HREF($params['edit_template'],'', Array(
				'm_opener'		=>	'd',
				'lst_mode'		=>	't',
				'lst_event'		=>	'OnEdit',
				'lst_id'		=>	$object->GetDBField('ListingTypeId'),
				'pass'			=>	'all,lst'
			), 'index.php');
	}

	function LinkEditLink($params)
	{
		$object =& $this->Application->recallObject( $this->getPrefixSpecial(), $this->Prefix, $params );

		$sql = 'SELECT '.$this->Application->getUnitOption('l', 'IDField').'
				FROM '.$this->Application->getUnitOption('l', 'TableName').'
				WHERE ResourceId = '.$object->GetDBField('ItemResourceId');

		return $this->Application->HREF($params['edit_template'],'', Array(
				'm_opener'	=>	'd',
				'l_mode'	=>	't',
				'l_event'	=>	'OnEdit',
				'l_id'		=>	$this->Conn->GetOne($sql),
				'pass'		=>	'all,l'
			));
	}

	function ExpirationDate($params)
	{
		$object =& $this->Application->recallObject( $this->getPrefixSpecial(), $this->Prefix, $params );
		$listing_type =& $this->Application->recallObject( 'lst', 'lst', $params );

		$dur_type_mapping = Array(	1	=>	1,
									2	=>	60,
									3	=>	3600,
									4	=>	3600*24,
									5	=>	3600*24*7,
									6	=>	3600*24*365/12,
									7	=>	3600*24*365
								);
		$duration = $listing_type->GetDBField('Duration');
		$duration_type = $listing_type->GetDBField('DurationType');
		$expiration_interval = $duration * $dur_type_mapping[$duration_type];
		$expiration_date = adodb_mktime() + $expiration_interval;

		$lang =& $this->Application->recallObject('lang.current');
		$format = $lang->GetDBField('DateFormat');
		$expiration_date = adodb_date($format, $expiration_date);

		return $expiration_date;
	}

	function ExpirationTime($params)
	{
		$object =& $this->Application->recallObject( $this->getPrefixSpecial(), $this->Prefix, $params );
		$listing_type =& $this->Application->recallObject( 'lst', 'lst', $params );

		$dur_type_mapping = Array(	1	=>	1,
									2	=>	60,
									3	=>	3600,
									4	=>	3600*24,
									5	=>	3600*24*7,
									6	=>	3600*24*365/12,
									7	=>	3600*24*365
								);
		$duration = $listing_type->GetDBField('Duration');
		$duration_type = $listing_type->GetDBField('DurationType');
		$expiration_interval = $duration * $dur_type_mapping[$duration_type];
		$expiration_date = adodb_mktime() + $expiration_interval;

		$lang =& $this->Application->recallObject('lang.current');
		$format = $lang->GetDBField('TimeFormat');
		$expiration_date = adodb_date($format, $expiration_date);

		return $expiration_date;
	}
}