<!--##
<NAME>Link - Add Review</NAME>
<DESC>Add Link Review Form</DESC>
<SECTION>Platform||Links</SECTION>
##-->

<inp2:m_RequireLogin login_template="platform/login/register" permissions="LINK.REVIEW|LINK.REVIEW.PENDING"/>

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:l_Field name="Name"/>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<!--## SIDE-BAR ELEMENT ##-->
<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-link/elements/side_boxes/action_box.elm" item_actions="1" design="blue_box"/>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## //SIDE-BAR ELEMENT ##-->

<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="__item__,lu_title_Reviews" templates="__default__,in-link/links/add_review" show_category="1"/>
		</div>
		<div class="movable-element">
			<!-- LINK DETAILS -->
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_phrase name="lu_title_LinkDetails"/>
				</inp2:m_Capture>

				<table class="fullwidth table-border">
					<tr><td class="item-padding">

				<table class="fullwidth">
					<tr>
						<td width="25" valign="top">
							<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/link_icon.gif" width="16" height="23" alt="" />
						</td>
						<td valign="top">

							<span class="text-title"><inp2:l_Field name="Name"/></span>

							<inp2:m_if check="l_Field" name="IsHot"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_hot.gif" alt="<inp2:m_phrase name="lu_Hot"/>"/></inp2:m_if>
							<inp2:m_if check="l_Field" name="IsNew"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_new.gif" alt="<inp2:m_phrase name="lu_New"/>"/></inp2:m_if>
							<inp2:m_if check="l_Field" name="IsPop"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_popular.gif" alt="<inp2:m_phrase name="lu_Pop"/>"/></inp2:m_if>
							<inp2:m_if check="l_IsEditorsPick"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_pick.gif" alt="<inp2:m_phrase name="lu_Pick"/>"/></inp2:m_if>
							<inp2:m_if check="l_IsFavorite"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_favorite.gif" alt="<inp2:m_phrase name="lu_Favorite"/>"/></inp2:m_if>
							<inp2:l_VotesIndicator render_as="rating_element"/>

							<br />

							<span class="item-statistics">
								<inp2:m_phrase name="lu_Added"/>: <inp2:l_Field name="CreatedOn" format="_regional_DateFormat"/>,
								<inp2:m_phrase name="lu_Hits"/>: <inp2:l_Field name="Hits"/>,
								<inp2:m_phrase name="lu_Rating"/>: <inp2:l_Field name="CachedRating"/>,
								<inp2:m_phrase name="lu_Reviews"/>: <inp2:l_Field name="CachedReviewsQty"/>,
								<inp2:m_phrase name="lu_Votes"/>: <inp2:l_Field name="CachedVotesQty"/>
							</span>
						</td>
					</tr>
				</table>

				<table>
					<tr>
						<td class="picture-padding" style="padding-left:25px" valign="top">
							<inp2:m_if check="l_ImageSrc" MaxWidth="fullsize">
							<a href="<inp2:l_ImageSrc MaxWidth="fullsize" />" class="thickbox" rel="link-images" title="<inp2:l_Field name='Name' html_escape='1'/>">
								<inp2:l_Image render_as="image_element" Primary="1" MaxWidth="thumbnail" DefaultImage="platform/img/no_picture.gif" /><br />
							</a>
							<inp2:m_else/>
								<inp2:l_Image render_as="image_element" Primary="1" MaxWidth="thumbnail" DefaultImage="platform/img/no_picture.gif"/><br />
							</inp2:m_if>
						</td>
						<td class="text-padding" valign="top">
							<input type="button" class="button" value="<inp2:m_phrase name="lu_btn_VisitLink"/>" onclick="open_window('<inp2:l_LinkLink template="in-link/elements/visit_link.elm"/>', 'new_window', '800', '600');"/><br /><br />

							<br/><br/>
							<inp2:m_if check="l_IsFavorite">
								<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/ic_removefromfav.gif" width="11" height="10" alt="" /> <a class="item-action" href="<inp2:l_FavoriteToggleLink/>"><inp2:m_phrase name="lu_btn_RemoveFromWishList"/></a>
							<inp2:m_else/>
								<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/ic_addtofav.gif" width="11" height="10" alt="" /> <a class="item-action" href="<inp2:l_FavoriteToggleLink template="platform/my_account/my_favorites"/>"><inp2:m_phrase name="lu_btn_AddToWishList"/></a>
							</inp2:m_if>

						</td>
					</tr>
				</table>
			</td></tr>
			</table>
			</inp2:m_RenderElement>
			<!-- //LINK DETAILS -->
		</div>

		<div class="movable-element">
			<!-- ADD REVIEW -->
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_phrase name="lu_title_ReviewThisLink"/>
				</inp2:m_Capture>


				<inp2:m_if check="l_HasPermission" permissions="LINK.REVIEW|LINK.REVIEW.PENDING">
					<inp2:m_if check="l-rev_AlreadyReviewed">
						<inp2:m_Phrase label="lu_ErrorAlreadyReviewed"/>
						<table>
							<inp2:l-rev_PrintList render_as="review_element" type="current_user"/>
						</table>
						<inp2:m_include template="platform/elements/pagination.elm" prefix="l-rev"/>
					<inp2:m_else/>
						<inp2:l-rev_PresetFormFields/>
						<span class="field-required">*</span> <inp2:m_phrase name="lu_IndicatesRequired"/><br /><br />

						<inp2:m_if check="l-rev_HasError" field="any">
							<inp2:m_RenderElement name="error_message" />
						</inp2:m_if>

						<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/grey_pix.gif" width="100%" height="1" align="absmiddle" alt="" /><br /><br />

						<form method="post" action="<inp2:m_FormAction/>">
							<table class="form-data fullwidth">
								<inp2:m_RenderElement name="inp_edit_radio" prefix="l-rev" field="Rating" title="lu_fld_Rating"/>
								<inp2:m_RenderElement name="inp_edit_textarea" prefix="l-rev" field="ReviewText" rows="8" cols="40" title="lu_fld_ReviewText" is_last="1"/>

								<inp2:m_RenderElement design="inp_edit_buttons">
									<input type="hidden" name="success_template" value="in-link/links/add_review_confirm" />
										<input type="hidden" name="success_pending_template" value="in-link/links/add_review_pending_confirm" />
										<input class="button" type="submit" name="events[l-rev][OnCreate]" value="<inp2:m_phrase label="lu_btn_Create"/>" />
								</inp2:m_RenderElement>
							</table>
						</form>
					</inp2:m_if>
				<inp2:m_else/>
					<inp2:m_phrase name="lu_text_NoLinkReviewPermission"/>
				</inp2:m_if>
			</inp2:m_RenderElement>
			<!-- //ADD REVIEW -->
		</div>
	</div>
</inp2:m_DefineElement>

<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>