<?php
/**
* @version	$Id: link_validation_tp.php 11889 2009-07-01 07:56:32Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class LinkValidationTagProcessor extends kDBTagProcessor {

		function FormatUrl($params)
		{
			$object =& $this->getObject($params);

			$url = $object->GetDBField($params['field']);
			if (!preg_match('/^(http|ftp|mailto:)(.*)/U', $url)) {
				$url = 'http://' . $url;
			}

			return $url;
		}

		/**
		 * Show CachedNavbar of current item primary category
		 *
		 * @param Array $params
		 * @return string
		 */
		function CategoryName($params)
		{
			// show category cachednavbar of
			$object =& $this->getObject($params);
			$category_id = isset($params['cat_id']) ? $params['cat_id'] : $object->GetDBField('CategoryId');

			$category_path = $this->Application->getCache('category_paths', $category_id);
			if ($category_path === false) {
				// not chached
				if ($category_id > 0) {

					$cached_navbar = preg_replace('/^(Content&\|&|Content)/i', '', $object->GetDBField('CachedNavbar'));
					$category_path = trim($this->CategoryName( Array('cat_id' => 0) ).' > '.str_replace('&|&', ' > ', $cached_navbar), ' > ');
				}
				else {
					$category_path = $this->Application->Phrase( $this->Application->ConfigValue('Root_Name') );
				}
				$this->Application->setCache('category_paths', $category_id, $category_path);
			}
			return $category_path;
		}
	}