<?php
/**
* @version	$Id: listing_types_tag_processor.php 16517 2017-01-20 14:12:38Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ListingTypesTagProcessor extends kDBTagProcessor  {

		function CategoryPath($params)
		{
			$object = $this->getObject($params);
			$params['cat_id'] = $object->GetDBField($params['field']);

			/** @var kNavigationBar $navigation_bar */
			$navigation_bar = $this->Application->recallObject('kNavigationBar');

			return $navigation_bar->build($params);
		}

		/**
		 * Makes 1st listing type default
		 *
		 * @param Array $params
		 * @return bool
		 */
		function IsDefault($params)
		{
			static $listing_type_id = null;

			/** @var kDBItem $object */
			$object = $this->getObject($params);

			if (!isset($listing_type_id)) {
				$listing_type_id = $object->GetID();
			}

			return $listing_type_id == $object->GetID();
		}
	}