<?php

	/**
	 * Custom-sections prefix
	 *
	 * @author dmitrya
	 * @package Custom (Development Kit)
	 */

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (

		'Prefix' => 'custom-sections',

		'ConfigPriority' => 2,

		# Event handler class used for HOOKing to existing events (ie. )
		'EventHandlerClass'	=> Array ('class' => 'CustomEventHandler', 'file' => 'custom_eh.php', 'build_event' => 'OnBuild'),

		# Defined to draw new sections (if any) in left nav. tree, normally each unit has it's own Tag Processor
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		# Extend/override already existing classes (ie. Event Handlers, Tag Processors, Helpers)
		'RegisterClasses' => Array (

			# extend default User core/units/users/users_tag_processor.php / users_event_handler.php
//			Array ('pseudo' => 'u_TagProcessor', 'class' => 'EUserTagProcessor', 'file' => 'users/e_user_tp.php'),
//			Array ('pseudo' => 'u_EventHandler', 'class' => 'EUserEventHandler', 'file' => 'users/e_user_eh.php'),

			# extend default Product classes /in-commerce/units/products/products_tag_processor.php / products_event_handler.php
//			Array ('pseudo' => 'p_TagProcessor', 'class' => 'EProductTagProcessor', 'file' => 'products/e_product_tp.php'),
//			Array ('pseudo' => 'p_EventHandler', 'class' => 'EProductEventHandler', 'file' => 'products/e_product_eh.php'),

			# extend default Link /in-link/units/links/link_tag_processor.php / links_event_handler.php
//			Array ('pseudo' => 'l_TagProcessor', 'class' => 'ELinkTagProcessor', 'file' => 'links/e_link_tp.php'),
//			Array ('pseudo' => 'l_EventHandler', 'class' => 'ELinkEventHandler', 'file' => 'links/e_link_eh.php'),

			# extend default Category /core/units/categories/categories_tag_processor.php / categories_event_handler.php
//			Array ('pseudo' => 'c_TagProcessor', 'class' => 'ECategoryTagProcessor', 'file' => 'categories/e_category_tp.php'),
//			Array ('pseudo' => 'c_EventHandler', 'class' => 'ECategoryEventHandler', 'file' => 'categories/e_category_eh.php'),

			# extend default Article /in-news/units/articles/article_tag_processor.php / articles_event_handler.php
//			Array ('pseudo' => 'n_TagProcessor', 'class' => 'EArticleTagProcessor', 'file' => 'articles/e_article_tp.php'),
//			Array ('pseudo' => 'n_EventHandler', 'class' => 'EArticleEventHandler', 'file' => 'articles/e_article_eh.php'),

		),

		# Replace/substiture any admin default templates with custom ones
		'ReplacementTemplates'	=>	Array (
			# replace default image block with custom template
//			'incs/image_blocks' => 'custom/incs/image_blocks',

			# replace default edit link template
//			'in-links/links/links_edit' => 'custom/links/links_edit',

			# replace default edit category template
//			'categories/categories_edit' => 'custom/categories/categories_edit',
		),

		# Hooks to events that may call any other events
		'Hooks' => Array (

			# hook to OnAfterCacheRebuild event of "adm" prefix (tiggered when unit cache is rebuild and stored) called
			# to override cloned sub-items (ie. register extended classes for cloned unit configs such as n-img, n-rev)
			/*Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'adm',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterCacheRebuild'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnOverrideClonedSubItems',
			),*/

			# hook to category OnAfterConfigRead event called to customize category configuration settings
			/*Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'c',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnModifyCategoriesConfig',
			),*/
		),

		'PermSection' => Array ('main' => 'custom', 'email' => 'custom:configuration_email'),

		# New sections in left navigation
		'Sections' => Array (
			'custom' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'conf_custom',
				'label'			=>	'la_title_Custom',
				'url'			=>	Array ('t' => 'index', 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	2.4,
				'container'		=>	true,
				'show_mode'		=>	smDEBUG,
				'type'			=>	stTREE,
			),

			'custom:setting_folder' => Array (
				'parent'		=>	'in-portal:system',
				'icon'			=>	'conf_custom',
				'label'			=>	'la_title_Custom',
				'use_parent_header' => 1,
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	3.6,
				'container'		=>	true,
				'show_mode'		=>	smDEBUG,
				'type'			=>	stTREE,
			),

			'custom:configuration_custom' => Array (
				'parent'		=>	'custom:setting_folder',
				'icon'			=>	'custom',
				'label'			=>	'la_tab_ConfigOutput',
				'url'			=>	Array('t' => 'config/config_universal', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array('view', 'edit'),
				'priority'		=>	50,
				'type'			=>	stTREE,
			),
		),

	);