<?php

	/**
	 * Sample config file for widgets
	 *
	 * @author dmitrya
	 * @package Development Kit
	 */

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (

		'Prefix' =>	'widget',

		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),

		'EventHandlerClass'	=>	Array ('class' => 'WidgetEventHandler', 'file' => 'widget_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' =>	Array ('class' => 'WidgetTagProcessor', 'file' => 'widget_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		// in case, when one method does everything
 		'RewriteListener' => 'WidgetRewriteListener',

		// in case, when building and parsing is done by separate methods
//		'RewriteListener' => Array ('WidgetRewriteBuilder', 'WidgetRewriteParser'),

		'IDField' => 'WidgetId',

		'StatusField' => Array ('Status'),

		'TableName'	=> TABLE_PREFIX.'Widgets',

	/*
		'ForeignKey' =>	'ParentId', // field title in TableName, linking record to a parent
		'ParentTableKey' =>	'ParentId', // id (or other key) field title in parent's table
		'ParentPrefix' => 'parent',
		'AutoDelete' => true, // delete these items when parent is being deleted
		'AutoClone' => true, // clone these items when parent is being cloned
	*/

		// used to build editing links in admin grids
		'AdminTemplatePath' => 'widgets',
		'AdminTemplatePrefix' => 'widget_',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('widget' => '!la_title_AddingWidget!'),
				'edit_status_labels' => Array ('widget' => '!la_title_EditingWidget!'),
				'new_titlefield' => Array ('widget' => '!la_title_NewWidget!'),
			),

			'widget_list' => Array (
				'prefixes' => Array ('widget_List'), 'format' => '#section_label#',
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'export', 'import', 'view', 'dbl-click',),
			),

			'widget_edit' => Array (
				'prefixes' => Array ('widget'), 'format' => '#widget_status# - #widget_titlefield#',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array ('main' => 'custom:widgets'),

		'Sections' => Array (
			'custom:widgets' => Array (
				'parent' =>	'custom',
				'icon' => 'custom',
				'label' => 'la_tab_Widgets',
				'url' => Array ('t' => 'custom/widgets/widget_list', 'pass' => 'm'),
				'permissions' => Array ('view', 'add', 'edit', 'delete'),
				'priority' => 1,
				'type' => stTREE,
			),
		),

		'TitleField' =>	'Title',	// field, used in bluebar when editing existing item

		// Use %1$s for local table name with prefix, %2$s for calculated fields
		'ListSQLs' => Array (	// key - special, value - list select sql
			'' => 'SELECT %1$s.* %2$s
						 FROM %1$s',
		),

		'ItemSQLs' => Array (
			'' => 'SELECT %1$s.* %2$s
						 FROM %1$s',
		),

		'ListSortings'	=> 	Array (
			'' => Array (
	//			'ForcedSorting' => Array ('Priority' => 'desc'),
				'Sorting' => Array ('Title' => 'asc'),
			)
		),

		'VirtualFields' =>	Array (
			'VirtualActionField' => Array ('type' => 'string', 'default' => ''),
		),

		'Fields' =>	Array (
			'WidgetId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Title' => Array (
				'type' => 'string', 'max_len' => 255,
				'required' => 1, 'default' => '', 'not_null' => 1,
			),
			'Description' => Array (
				'type' => 'string',
				'formatter' => 'kFormatter', 'using_fck' => 1,
				'default' => null,
			),
			'Email' => Array (
				'type' => 'string', 'formatter' => 'kFormatter',
				'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
				'sample_value' => 'email@domain.com',
				'not_null' => 1, 'default' => '',
				'error_msgs' => Array ('invalid_format' => '!la_invalid_email!'),
			),
			'Type' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
				'options' => Array (
					1 => 'la_opt_Default',
					2 => 'la_opt_Custom',
				),
				'not_null' => 1,
				'default' => 1,
				'required' => 1,
			),
			'Phone' => Array (
				'type' => 'string',
				'formatter' => 'kFormatter',
				'default' => '', 'using_fck' => 1, 'not_null' => 1),
			'Qty' => Array (
				'type' => 'double',
				'required' => 0, 'not_null' => 1, 'default' => 0
			),
			'Status' =>	Array (
				'type' => 'int', 'formatter' => 'kOptionsFormatter',
				'options' => array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'),
				'use_phrases' => 1, 'not_null' => 1, 'default' => 2,
			),
			'CreatedOn' => Array (
				'type' => 'int',
				'formatter' => 'kDateFormatter',
				'time_format' => '', 'input_time_format' => '',
				'default' => '#NOW#',
			),
			'Good' => Array (
				'type' => 'int', 'formatter' => 'kOptionsFormatter',
				'options' => Array (1 => 'la_Yes', 0 => 'la_No'),
				'use_phrases' => 1, 'not_null' => 1, 'default' => 0
			),
			'BirthTime' => Array (
				'type' => 'int', 'formatter' => 'kDateFormatter',
				'date_format' => '', 'input_date_format' => '',
				'default' => null
			),
			'Image' => Array (
				'type' => 'string', 'formatter' => 'kUploadFormatter',
				'max_size' => MAX_UPLOAD_SIZE, // in Bytes !
				'file_types' => '*.jpg;*.gif;*.png', 'files_description' => '!la_hint_ImageFiles!',
				'upload_dir' => '/system/user_files/', // relative to project's home
				'as_image' => true, 'thumb_format' => 'resize:100x100',
				'multiple' => false, // false or max number of files - will be stored as serialized array of paths
				'direct_links' => false, // use direct file urls or send files through wrapper (requires mod_mime_magic)
				'required' => 1, 'default' => null
			),
			'DataFile' => Array (
				'type' => 'string', 'formatter' => 'kUploadFormatter',
				'max_size' => MAX_UPLOAD_SIZE, // in Bytes !
				'file_types' => '*.*',
				'files_description' => '!la_hint_AllFiles!',
				'upload_dir' => '/system/user_files/', // relative to project's home
				'as_image' => false,
				'multiple' => 5, // false or max number of files - will be stored as serialized array of paths
				'direct_links' => true, // use direct file urls or send files through wrapper (requires mod_mime_magic)
				'default' => null
			),
		),

		'Grids'	=> Array (
			'Default' => Array (
	//			'Icons' => Array ('default' => 'icon16_custom.gif'),
				'Fields' => Array (
					'WidgetId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
					'Title' => Array ('title' => 'column:la_fld_Name', 'data_block' => 'grid_custom_td'),
					'Image' => Array ('data_block' => 'grid_image_td'),
					'Type' => Array ('filter_block' => 'grid_options_filter'),
					'Status' => Array ('filter_block' => 'grid_options_filter'),
					'Good' => Array ('filter_block' => 'grid_like_filter'),
					'Qty' => Array ('header_block' => 'grid_column_title_no_sorting', 'filter_block' => 'grid_float_range_filter'),
					'Email' => Array ('filter_block' => 'grid_like_filter'),
					'Phone' => Array ('filter_block' => 'grid_like_filter'),
					'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter'),
					'Description' => Array ('filter_block' => 'grid_like_filter'),
					'VirtualActionField' => Array ('title' => 'column:la_fld_Action', 'data_block' => 'grid_delete_td'),
				),
			),
		),

		/*'ConfigMapping' => Array (
			'PerPage' => 'Perpage_Widgets',
			'ShortListPerPage' => 'Perpage_Widgets_Short',
		),*/
	);
