<?php

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Widgets Event Handler (sample)
	 *
	 */
	class WidgetEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnItemBuild' => Array ('self' => true),
				'OnCustomEvent' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Permission exceptions
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$skip_permissions_check_events = Array (
				'OnAnotherCustomEvent',
			);

			if (in_array($event->Name, $skip_permissions_check_events)) {
				return true;
			}

			return parent::CheckPermission($event);
		}

		/**
		 * Set custom query for the list
		 *
		 * @param kEvent $event
		 */
		function OnCustomEvent(&$event)
		{
			$object =& $event->getObject();
			/* @var $object kDBList */

		}

		/**
		 * Set custom query for the list
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			parent::SetCustomQuery($event);

			$object =& $event->getObject();
			/* @var $object kDBList */

			# identifying event based on special and setting filter
			if ($event->Special == 'custom-special') {
//				$object->addFilter('primary_filter', '%1$s.Status = '.STATUS_DISABLED);
			}
		}

		/**
		 * Before new item created
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			parent::OnBeforeItemCreate($event);

		}

		/**
		 * Before existing item updated
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemUpdate(&$event)
		{
			parent::OnBeforeItemUpdate($event);

		}

		/**
		 * Before item deleted
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemDelete(&$event)
		{
			parent::OnBeforeItemDelete($event);


		}

		/**
		 * After item loaded
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemLoad(&$event)
		{
			parent::OnBeforeItemLoad($event);


		}


		/**
		 * After new item created
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			parent::OnAfterItemCreate($event);


		}

		/**
		 * After existing item updated
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemUpdate(&$event)
		{
			parent::OnAfterItemUpdate($event);


		}

		/**
		 * After item deleted
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemDelete(&$event)
		{
			parent::OnAfterItemDelete($event);


		}

		/**
		 * After item loaded
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemLoad(&$event)
		{
			parent::OnAfterItemLoad($event);


		}

		/**
		 * Builds/parses widget part of url
		 *
		 * @param int $rewrite_mode Mode in what rewrite listener was called. Possbile two modes: REWRITE_MODE_BUILD, REWRITE_MODE_PARSE.
		 * @param string $prefix Prefix, that listener uses for system integration
		 * @param Array $params Params, that are used for url building or created during url parsing.
		 * @param Array $url_parts Url parts to parse (only for parsing).
		 * @param bool $keep_events Keep event names in resulting url (only for building).
		 * @return bool Return true to continue to next listener; return false (when building) not to rewrite given prefix; return false (when parsing) to stop processing at this listener.
		 */
		function WidgetRewriteListener($rewrite_mode = REWRITE_MODE_BUILD, $prefix, &$params, &$url_parts, $keep_events = false)
		{
			if ($rewrite_mode == REWRITE_MODE_BUILD) {
				return $this->WidgetRewriteBuilder($rewrite_mode, $prefix, $params, $url_parts, $keep_events);
			}

			if ($rewrite_mode == REWRITE_MODE_PARSE) {
				return $this->WidgetRewriteParser($rewrite_mode, $prefix, $params, $url_parts);
			}

			return true;
		}

		/**
		 * Builds/parses widget part of url
		 *
		 * @param int $rewrite_mode Mode in what rewrite listener was called. Possbile two modes: REWRITE_MODE_BUILD, REWRITE_MODE_PARSE.
		 * @param string $prefix Prefix, that listener uses for system integration
		 * @param Array $params Params, that are used for url building or created during url parsing.
		 * @param Array $url_parts Url parts to parse (only for parsing).
		 * @param bool $keep_events Keep event names in resulting url (only for building).
		 * @return bool Return true to continue to next listener; return false (when building) not to rewrite given prefix; return false (when parsing) to stop processing at this listener.
		 */
		function WidgetRewriteBuilder($rewrite_mode = REWRITE_MODE_BUILD, $prefix, &$params, &$url_parts, $keep_events = false)
		{
			if ($params['t'] == 'widgets/widget_detail') {
				// this is default template for this prefix, so don't add it to resulting url
				$params['pass_template'] = false;
			}

			$mod_rewrite_helper =& $this->Application->recallObject('ModRewriteHelper');
			/* @var $mod_rewrite_helper kModRewriteHelper */

			$processed_params = $mod_rewrite_helper->getProcessedParams($prefix, $params, $keep_events);

			if ($processed_params === false) {
				return '';
			}

			$ret = Array ('', '');

			if ($processed_params[$prefix . '_id'] > 0) {
				// add id
				$sql = 'SELECT Title
						FROM ' . TABLE_PREFIX . 'Widgets
						WHERE WidgetId = ' . $processed_params[$prefix . '_id'];
				$ret[0] .= 'widgets/' . $this->Conn->GetOne($sql) . '/';
			} elseif ($processed_params[$prefix . '_Page'] > 1) {
				// add page, only when ID is missing
				$ret[1] .= $processed_params[$prefix . '_Page'] . '/';
			}

			$ret[0] = rtrim($ret[0], '/');
			$ret[1] = rtrim($ret[1], '/');

			return array_map('mb_strtolower', $ret);
		}

		/**
		 * Builds/parses widget part of url
		 *
		 * @param int $rewrite_mode Mode in what rewrite listener was called. Possbile two modes: REWRITE_MODE_BUILD, REWRITE_MODE_PARSE.
		 * @param string $prefix Prefix, that listener uses for system integration
		 * @param Array $params Params, that are used for url building or created during url parsing.
		 * @param Array $url_parts Url parts to parse (only for parsing).
		 * @return bool Return true to continue to next listener; return false (when building) not to rewrite given prefix; return false (when parsing) to stop processing at this listener.
		 */
		function WidgetRewriteParser($rewrite_mode = REWRITE_MODE_BUILD, $prefix, &$params, &$url_parts)
		{
			if ($url_parts[0] == 'widgets') {
				$sql = 'SELECT WidgetId
						FROM ' . TABLE_PREFIX . 'Widgets
						WHERE Title = ' . $this->Conn->qstr($url_parts[1]);
				$id = $this->Conn->GetOne($sql);
				$to_parse = $url_parts;

				if ($id > 0) {
					// id found
					$params[$prefix . '_id'] = $id;
					$to_parse = array_slice($to_parse, 2); // cut off first two parts - "widgets/<widget+name>"
					$params['pass'][] = $prefix; // otherwise this prefix won't passed when pass="all" parameter used
				}

				$template = implode('/', $to_parse);

				if ($template) {
					// let others guess what template is
					return true;
				}

				// template missing -> set default
				$params['t'] = 'widgets/widget_detail';
				return false;
			}

			return true;
		}
	}