<?php

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Widgets Tag Processor (sample)
	 *
	 */
	class WidgetTagProcessor extends kDBTagProcessor {

		/**
		 * Custom tag to output "Hello World!"
		 *
		 * @param Array $params
		 * @return string
		 */
		function NewTag($params)
		{
			return 'Hello world!';
		}
		
		/**
		 * Returns a link for editing product
		 *
		 * @param Array $params
		 * @return string
		 */
		function ItemEditLink($params)
		{
			$object =& $this->getObject();
			/* @var $object kDBList */
	
			$edit_template = $this->Application->getUnitOption($this->Prefix, 'AdminTemplatePath') . '/' . $this->Application->getUnitOption($this->Prefix, 'AdminTemplatePrefix') . 'edit';
	
			$url_params = Array (
				'm_opener'				=>	'd',
				$this->Prefix.'_mode'	=>	't',
				$this->Prefix.'_event'	=>	'OnEdit',
				$this->Prefix.'_id'		=>	$object->GetID(),				
				'pass'					=>	'all,'.$this->Prefix,
				'no_pass_through'		=>	1,
			);
	
			return $this->Application->HREF($edit_template, '', $url_params);
		}

	}