<?php

	/**
	 * Widgets Event Handler (sample)
	 *
	 */
	class WidgetEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnCustomEvent' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Permission exceptions
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$skip_permissions_check_events = Array (
				'OnAnotherCustomEvent',
			);

			if (in_array($event->Name, $skip_permissions_check_events)) {
				return true;
			}

			return parent::CheckPermission($event);
		}

		/**
		 * Set custom query for the list
		 *
		 * @param kEvent $event
		 */
		function OnCustomEvent(&$event)
		{
			$object =& $event->getObject();
			/* @var $object kDBList */

		}

		/**
		 * Set custom query for the list
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			parent::SetCustomQuery($event);

			$object =& $event->getObject();
			/* @var $object kDBList */

			# identifying event based on special and setting filter
			if ($event->Special == 'custom-special') {
//				$object->addFilter('primary_filter', '%1$s.Status = '.STATUS_DISABLED);
			}
		}

		/**
		 * Before new item created
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			parent::OnBeforeItemCreate($event);

		}

		/**
		 * Before existing item updated
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemUpdate(&$event)
		{
			parent::OnBeforeItemUpdate($event);

		}

		/**
		 * Before item deleted
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemDelete(&$event)
		{
			parent::OnBeforeItemDelete($event);


		}

		/**
		 * After item loaded
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemLoad(&$event)
		{
			parent::OnBeforeItemLoad($event);


		}


		/**
		 * After new item created
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			parent::OnAfterItemCreate($event);


		}

		/**
		 * After existing item updated
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemUpdate(&$event)
		{
			parent::OnAfterItemUpdate($event);


		}

		/**
		 * After item deleted
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemDelete(&$event)
		{
			parent::OnAfterItemDelete($event);


		}

		/**
		 * After item loaded
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemLoad(&$event)
		{
			parent::OnAfterItemLoad($event);


		}

	}