<?php
$module_folder = 'modules/custom';

if ( !defined('IS_INSTALL') ) {
	// separate module install
	define('IS_INSTALL', 1);
	define('ADMIN', 1);
	define('FULL_PATH', realpath(dirname(__FILE__) . '/../..'));

	include_once(FULL_PATH . '/core/kernel/startup.php');
	require_once FULL_PATH . '/core/install/install_toolkit.php';

	$constants_file = FULL_PATH . '/' . $module_folder . '/constants.php';

	if ( file_exists($constants_file) ) {
		require_once $constants_file;
	}

	$toolkit = new kInstallToolkit();
}
else {
	// install, using installation wizard
	/** @var kInstallToolkit $toolkit */
	$toolkit =& $this->toolkit;
}

$application =& kApplication::Instance();
$application->Init();

if ( $application->RecallVar('user_id') != USER_ROOT ) {
	die('restricted access!');
}

$toolkit->RunSQL('/' . $module_folder . '/install/install_schema.sql');
$toolkit->RunSQL('/' . $module_folder . '/install/install_data.sql');
$toolkit->ImportLanguage('/' . $module_folder . '/install/english', isset($constants_file));

$toolkit->finalizeModuleInstall($module_folder, false);
