<?php
defined('FULL_PATH') or die('restricted access!');

/**
 * Widgets Tag Processor (sample)
 *
 */
class WidgetTagProcessor extends kDBTagProcessor {

	/**
	 * Custom tag to output "Hello World!"
	 *
	 * @param Array $params
	 * @return string
	 */
	function NewTag($params)
	{
		return 'Hello world!';
	}

	/**
	 * Returns a link for editing product
	 *
	 * @param Array $params
	 * @return string
	 */
	function ItemEditLink($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBList */

		$edit_template = $this->Application->getUnitOption($this->Prefix, 'AdminTemplatePath') . '/' . $this->Application->getUnitOption($this->Prefix, 'AdminTemplatePrefix') . 'edit';

		$url_params = Array (
			'm_opener'				=>	'd',
			$this->Prefix.'_mode'	=>	't',
			$this->Prefix.'_event'	=>	'OnEdit',
			$this->Prefix.'_id'		=>	$object->GetID(),
			'pass'					=>	'all,'.$this->Prefix,
			'no_pass_through'		=>	1,
		);

		return $this->Application->HREF($edit_template, '', $url_params);
	}


	/**
	 * Creates link to an item including only it's id
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function ItemLink($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$params['pass'] = 'm,' . $this->Prefix;
		$params[$object->Prefix . '_id'] = $object->GetID();
		$params[$object->Prefix . '_filename'] = $object->GetDBField('Title');

		return $this->Application->ProcessParsedTag('m', 'Link', $params);
	}

}