<inp2:m_Set skip_last_template="1"/>
<inp2:m_include t="incs/header" nobody="yes" noform="yes"/>
<inp2:m_NoDebug/>

<body class="tree-body" onresize="onTreeFrameResize();">

<script type="text/javascript">
	var $save_timer = null,
		$last_width = parseInt('<inp2:m_GetConfig name="MenuFrameWidth"/>');

	function credits(url) {
		openwin(url, 'credits', 280, 520);
	}

	function onTreeFrameResize() {
		var $frameset = $('#sub_frameset', window.parent.document);
		if (!$frameset.length) {
			return ;
		}

		var $width = $frameset.attr('cols').split(',')[0];
		if (($width <= 0) || ($width == $last_width)) {
			// don't save zero width
			return ;
		}

		clearTimeout($save_timer);
		$save_timer = setTimeout( function() {saveFrameWidth($width);}, 2000);
	}

	function saveFrameWidth($width) {
		getFrame('head').$FrameResizer.OpenWidth = $width;

		$.get(
			'<inp2:m_Link template="index" adm_event="OnSaveMenuFrameWidth" pass="m,adm" js_escape="1" no_amp="1"/>',
			{width: $width}
		);

		$last_width = $width;
	}
</script>

<script type="text/javascript" src="<inp2:m_Compress files='js/tree.js'/>"></script>

<table style="height: 100%; width: 100%; border-right: 1px solid #777; border-bottom: 1px solid #777;">
	<tr>
		<td colspan="2" style="vertical-align: top; padding: 5px;">
			<inp2:m_DefineElement name="xml_node" icon_module="">
				<inp2:m_if check="m_ParamEquals" param="children_count" value="0">
					<item href="<inp2:m_param name='section_url' html_escape='1'/>" priority="<inp2:m_param name='priority' html_escape='1'/>" onclick="<inp2:m_param name='onclick' html_escape='1'/>" icon="<inp2:$SectionPrefix_ModulePath module='$icon_module'/>img/icons/icon24_<inp2:m_param name='icon'/>.png"<inp2:m_if check="m_Param" name="debug_only"> debug_only="1"</inp2:m_if>><inp2:m_phrase name="$label" html_escape="1"/></item>
				<inp2:m_else/>
					<folder href="<inp2:m_param name='section_url' html_escape='1'/>" priority="<inp2:m_param name='priority' html_escape='1'/>" container="<inp2:m_param name='container' html_escape='1'/>" onclick="<inp2:m_param name='onclick' html_escape='1'/>" name="<inp2:m_phrase name='$label' html_escape='1'/>" icon="<inp2:$SectionPrefix_ModulePath module="$icon_module"/>img/icons/icon24_<inp2:m_param name='icon'/>.png" load_url="<inp2:m_param name='late_load' html_escape='1'/>"<inp2:m_if check="m_Param" name="debug_only"> debug_only="1"</inp2:m_if>><inp2:adm_PrintSections render_as="xml_node" section_name="$section_name"/></folder>
				</inp2:m_if>
			</inp2:m_DefineElement>

			<table class="tree">
				<tbody id="tree">
				</tbody>
			</table>
			<script type="text/javascript">
				var TREE_ICONS_PATH = 'img/tree';
				var TREE_SHOW_PRIORITY = <inp2:m_if check="adm_ConstOn" name="DBG_SHOW_TREE_PRIORITY" debug_mode="1">1<inp2:m_else/>0</inp2:m_if>;
				var TREE_LOADING_NODE = {
					text: '<inp2:m_Phrase name="la_title_Loading" no_editing="1"/>',
					icon: '<inp2:adm_ModulePath module="core"/>img/icons/icon24_loading.gif'
				};

				<inp2:m_DefineElement name="root_node">
					var the_tree = new TreeFolder('tree', '<inp2:m_param name="label" js_escape="1"/>', '<inp2:m_param name="section_url" js_escape="1"/>', '<inp2:$SectionPrefix_ModulePath module="$icon_module"/>img/icons/icon24_<inp2:m_param name="icon"/>.png', null, null, '<inp2:m_param name="priority" js_escape='1'/>', '<inp2:m_param name="container" js_escape="1"/>');
				</inp2:m_DefineElement>
				<inp2:adm_PrintSection render_as="root_node" section_name="in-portal:root"/>

				the_tree.AddFromXML('<tree><inp2:adm_PrintSections render_as="xml_node" section_name="in-portal:root" js_escape="1"/></tree>');

				<inp2:m_if check="adm_MainFrameLink">
					var fld = the_tree.locateItemByURL('<inp2:adm_MainFrameLink m_opener="r" no_amp="1"/>');
					if (fld) {
						fld.highLight();
					}
					else {
						the_tree.highLight();
					}
				<inp2:m_else/>
					the_tree.highLight();
				</inp2:m_if>
			</script>
		</td>
	</tr>
</table>

<script type="text/javascript">
	function checkCatalog($cat_id) {
		var $ret = checkEditMode(false);
		var $right_frame = getFrame('main');

		if ($ret && $right_frame.$is_catalog) {
			$right_frame.$Catalog.go_to_cat($cat_id);
			return 1; // this opens folder, but disables click
		}

		return $ret;
	}

	function setCatalogTab($prefix) {
		var $ret = checkEditMode(false);

		if ($ret) {
			var $right_frame = getFrame('main');
			var $catalog_type = (typeof $right_frame.$Catalog != 'undefined') ? $right_frame.$Catalog.type : '';

			// highlight "Structure & Data" node, when one of it's shortcut nodes are clicked
			<inp2:m_DefineElement name="section_url_element"><inp2:m_param name="section_url"/></inp2:m_DefineElement>
			var $structure_node = the_tree.locateItemByURL('<inp2:adm_PrintSection render_as="section_url_element" section_name="in-portal:browse"/>');

			if ($catalog_type == 'AdvancedView') {
				$right_frame.$Catalog.switchTab($prefix);
				return $structure_node; // this opens folder, but disables click
			}

			// this disabled click and causes other node to be highlighted
			return $structure_node;
		}

		return $ret;
	}

	function checkEditMode($reset_toolbar)
	{
		if (!isset($reset_toolbar)) {
			$reset_toolbar = true;
		}

		if ($reset_toolbar) {
			getFrame('head').$('#extra_toolbar').html('');
		}

		var $phrase = '<inp2:m_Phrase label="la_EditingInProgress" js_escape="1"/>';

		if (getFrame('main').$edit_mode) {
			return confirm($phrase) ? true : false;
		}

		return true;
	}

	function ReloadFolder(url, with_late_load)
	{
		if (!with_late_load) with_late_load = false;

		var fld = the_tree.locateItemByURL(url.replace(/&amp;/g, '&'), with_late_load);
		if (fld) {
			fld.reload();
		}
	}

	function ShowStructure($url, $visible)
	{
		var fld = the_tree.locateItemByURL($url, true);
		if (fld) {
			if ($visible) {
				fld.expand();
			}
			else {
				fld.collapse();
			}

		}
	}

	function SyncActive(url) {
		var fld = the_tree.locateItemByURL(url);
		if (fld) {
			fld.highLight();
		}
	}

	<inp2:m_DefineElement name="container_node">
		var $container_node = the_tree.locateItemByURL('<inp2:m_param name="section_url" js_escape="1"/>');
		$container_node.Container = true;
	</inp2:m_DefineElement>

	<inp2:m_DefineElement name="container_node_fix">
			<inp2:m_if check="m_GetConfig" name="$config_var">
			<inp2:m_ifnot check="m_IsDebugMode">
				<inp2:adm_PrintSection render_as="container_node" section_name="$section"/>
			</inp2:m_ifnot>
		</inp2:m_if>
	</inp2:m_DefineElement>

	<inp2:m_RenderElement name="container_node_fix" config_var="DebugOnlyFormConfigurator" section="in-portal:forms"/>
	<inp2:m_RenderElement name="container_node_fix" config_var="DebugOnlyPromoBlockGroupConfigurator" section="in-portal:promo_block_groups"/>
</script>

<!--## when form is on top, then 100% height is broken ##-->
<inp2:m_RenderElement name="kernel_form"/>
<inp2:m_include t="incs/footer"/>