<?php
/**
* @version	$Id: system_log_tp.php 15552 2012-10-02 17:13:27Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class SystemLogTagProcessor extends kDBTagProcessor {

	/**
	 * Displays filename
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function Filename($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$filename = $object->GetDBField('LogSourceFilename');

		if ( !$filename ) {
			return '';
		}

		return preg_replace('/^' . preg_quote(FULL_PATH, '/') . '/', '...', $filename, 1);
	}

	/**
	 * Displays filename
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function RequestURI($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$request_uri = $object->GetDBField('LogRequestURI');

		if ( !$request_uri ) {
			return '';
		}

		return preg_replace('/^' . preg_quote(BASE_PATH, '/') . '/', '...', $request_uri, 1);
	}

	/**
	 * Displays used memory
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function MemoryUsage($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		return kUtil::formatSize($object->GetDBField('LogMemoryUsed'));
	}

	/**
	 * Prints serialized array
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function PrintArray($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$field = $params['field'];
		$value = $object->GetDBField($field);

		if ( !$value ) {
			return '';
		}

		$value = print_r(unserialize($value), true);

		return $this->highlightString($value);
	}

	/**
	 * Prints backtrace result
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function PrintBacktrace($params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$value = $object->GetDBField('LogBacktrace');

		if ( !$value ) {
			return '';
		}

		$ret = '';
		$trace = unserialize($value);
		$include_args = isset($params['include_args']) ? $params['include_args'] : false;
		$strip_tags = isset($params['strip_tags']) ? $params['strip_tags'] : false;

		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $params['render_as'];

		foreach ($trace as $index => $trace_info) {
			$block_params['index'] = $index;

			if ( isset($trace_info['file']) ) {
				$function_name = isset($trace_info['class']) ? $trace_info['class'] . $trace_info['type'] . $trace_info['function'] : $trace_info['function'];
				$block_params['file_info'] = $function_name . ' in <b>' . basename($trace_info['file']) . '</b> on line <b>' . $trace_info['line'] . '</b>';

				if ( $strip_tags ) {
					$block_params['file_info'] = strip_tags($block_params['file_info']);
				}
			}
			else {
				$block_params['file_info'] = 'no file information available';
			}

			$block_params['has_args'] = isset($trace_info['args']);

			if ( $include_args ) {
				$block_params['args'] = $block_params['has_args'] ? $this->highlightString(print_r($trace_info['args'], true)) : '';
			}

			$ret .= $this->Application->ParseBlock($block_params);
		}

		return $ret;
	}

	/**
	 * Prints backtrace record index
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function BacktraceIndex($params)
	{
		$index = $this->Application->Parser->GetParam('index') + 1;

		return str_pad($index, 3, ' ', STR_PAD_LEFT);
	}

	public function highlightString($string)
	{
		$string = str_replace(Array ('\\', '/'), Array ('_nms1_', '_nms2_'), $string);
		$string = highlight_string('<?php ' . $string . ' ?>', true);
		$string = str_replace(Array ('_nms1_', '_nms2_'), Array ('\\', '/'), $string);

		return str_replace(Array ('&lt;?php&nbsp;', '?&gt;'), '', $string);
	}
}
