<?php
/**
* @version	$Id: debugger_responce.php 15588 2012-10-18 15:30:36Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	set_time_limit(0);
	ini_set('memory_limit', -1);

	define('FULL_PATH', realpath(dirname(__FILE__) . '/../../../..'));

	$sid = $_GET['sid'];
	$path = isset($_GET['path']) ? $_GET['path'] : '/system/cache';

	if ( (strpos($path, '../') !== false) || (trim($path) !== $path) ) {
		// when relative paths or special chars are found template names from url, then it's hacking attempt
		exit;
	}

	if ( !preg_match('/^@([\d]+)@$/', $sid) ) {
		exit;
	}

	$debug_file = FULL_PATH . $path . '/debug_' . $sid . '.txt';
	if ( file_exists($debug_file) ) {
		$ret = file_get_contents($debug_file);
		$ret = str_replace('#DBG_FILESIZE#', formatSize(filesize($debug_file)), $ret);
		unlink($debug_file);
	}
	else {
		$ret = 'file not found';
	}

	$accept_encoding = isset($_SERVER['HTTP_ACCEPT_ENCODING']) ? $_SERVER['HTTP_ACCEPT_ENCODING'] : '';

	if ( function_exists('gzencode') && strstr($accept_encoding, 'gzip') ) {
		header('Content-Encoding: gzip');
		echo gzencode($ret);
	}
	else {
		echo $ret;
	}

	/**
	 * Formats file/memory size in nice way
	 *
	 * @param int $bytes
	 * @return string
	 * @access public
	 */
	function formatSize($bytes)
	{
		if ( $bytes >= 1099511627776 ) {
			$return = round($bytes / 1024 / 1024 / 1024 / 1024, 2);
			$suffix = "TB";
		}
		elseif ( $bytes >= 1073741824 ) {
			$return = round($bytes / 1024 / 1024 / 1024, 2);
			$suffix = "GB";
		}
		elseif ( $bytes >= 1048576 ) {
			$return = round($bytes / 1024 / 1024, 2);
			$suffix = "MB";
		}
		elseif ( $bytes >= 1024 ) {
			$return = round($bytes / 1024, 2);
			$suffix = "KB";
		}
		else {
			$return = $bytes;
			$suffix = "Byte";
		}
		$return .= ' ' . $suffix;
		return $return;
	}
