<inp2:m_include t="incs/header"/>

<inp2:conf_InitList name="Default" per_page="-1"/>
<inp2:m_Get name="section" result_to_var="section"/>
<inp2:m_RenderElement name="combined_header" prefix="conf" section="$section" title_preset="section_label" perm_event="conf:OnLoad"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tbody>
		<tr>
			<td>
				<script type="text/javascript">
					function validate_password_fields() {
						var $validated = true;

						$("input[primarytype='password']", '#' + $form_name).each(
							function ($e) {
								if ( !validate_password_field(this.id) ) {
									$validated = false;
								}
							}
						);

						return $validated;
					}

					function validate_password_field($field_id) {
						var password_field = document.getElementById($field_id),
							password_verify_field = document.getElementById('verify_' + $field_id);

						if ( password_field && password_verify_field && password_field.value == password_verify_field.value ) {
							return true;
						}
						else {
							var password_error_cell = document.getElementById('error_' + $field_id);

							if ( password_error_cell ) {
								$(window).scrollTop($(password_field).position().top - 15);
								password_error_cell.innerHTML = '<inp2:m_Phrase name="la_error_PasswordMatch"/>';
							}

							return false;
						}
					}

					function toggle_section($label) {
						var $row = null,
							$is_visible = false,
							$table = document.getElementById('config_table');

						for (var $i = 0; $i < $table.rows.length; $i++) {
							$row = $table.rows[$i];
							if ( $row.getAttribute('header_label') != $label ) {
								continue;
							}

							if ( !$row.style.display ) {
								$row.style.display = document.all ? 'block' : 'table-row';
							}

							$is_visible = !($row.style.display == 'none');
							$row.style.display = $is_visible ? 'none' : (document.all ? 'block' : 'table-row');

							document.getElementById('toggle_mark[' + $label + ']').innerHTML = '[' + ($is_visible ? '+' : '-') + ']';
						}
					}

					var a_toolbar = new ToolBar();

					a_toolbar.AddButton(
						new ToolBarButton(
							'select',
							'<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>',
							function () {
								submit_event('conf', '<inp2:conf_SaveEvent/>');
							}
						)
					);

					a_toolbar.AddButton(
						new ToolBarButton(
							'cancel',
							'<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>',
							function () {
								submit_event('conf', 'OnCancel');
							}
						)
					);

					<inp2:m_if check="m_IsDebugMode">
						a_toolbar.AddButton( new ToolBarSeparator('sep1') );

						a_toolbar.AddButton(
							new ToolBarButton(
								'new_item',
								'<inp2:m_phrase label="la_ToolTip_NewSystemSetting" escape="1"/>::<inp2:m_phrase label="la_ToolTip_Add" escape="1"/>',
								function() {
									std_precreate_item('conf', 'config/config_edit');
								}
							)
						);
					</inp2:m_if>

					<inp2:m_ModuleInclude template = "config/custom_toolbar"/>

					a_toolbar.Render();
				</script>
			</td>
		</tr>
	</tbody>
</table>

<inp2:m_include t="incs/config_blocks"/>

<inp2:m_RenderElement name="config_updated_notice"/>
<inp2:conf_SaveWarning name="grid_save_warning"/>

<table width="100%" border="0" cellspacing="0" cellpadding="4" class="bordered" id="config_table">
	<inp2:conf_PrintList list_name="default" block="config_block" full_block="config_block" half_block1="config_block1" half_block2="config_block2" value_render_as="cf_default_value"/>
</table>

<script type="text/javascript">
	<inp2:m_if check="m_Get" name="refresh_tree">
		getFrame('menu').location.reload();
	</inp2:m_if>

	<inp2:m_if check="m_Get" name="refresh_all">
		var $menu_frame = getFrame('menu');

		$menu_frame.parent.location.href = $menu_frame.parent.location.href;
	</inp2:m_if>

	Application.setHook(
		'conf:*',
		function ($event) {
			$event.status = $event.Name == 'OnCancel' ? true : validate_password_fields();
		}
	);

	<inp2:m_if check="m_Get" name="first_error">
		$(document).ready(function () {
			var $error_cell = $('.field-<inp2:m_Get name="first_error"/>.error');

			if ( $error_cell.length ) {
				$(window).scrollTop($error_cell.position().top - 15);
			}
		});
	</inp2:m_if>
</script>

<inp2:m_include t="incs/footer"/>