<?php
/**
* @version	$Id: structure_config.php 15390 2012-06-12 16:25:51Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix'			=>	'st',
		'ItemClass'			=>	Array('class'=>'CategoriesItem','file'=>'structure_item.php', 'build_event'=>'OnItemBuild'),
		'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
		'EventHandlerClass'	=>	Array('class'=>'CategoriesEventHandler','file'=>'structure_eh.php', 'build_event'=>'OnBuild'),
		'TagProcessorClass' =>	Array('class'=>'CategoriesTagProcessor','file'=>'structure_tp.php', 'build_event'=>'OnBuild'),

		'AutoLoad'				=>	true,

		'QueryString' => Array(
			1	=>	'id',
			2	=>	'Page',
			3	=>	'PerPage',
			4	=>	'event',
			5	=>	'mode',
		),
		'ConfigPriority' => 0,
		'Hooks' => Array(
			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => '',
				'HookToSpecial' => '*',
				'HookToEvent' => Array('OnAfterConfigRead'),
				'DoPrefix' => 'cdata',
				'DoSpecial' => '*',
				'DoEvent' => 'OnDefineCustomFields',
			),

			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => 'rel',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnCloneSubItem',
			),

			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => 'img',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnCloneSubItem',
			),
		),

		'IDField' 			=> 	'CategoryId',

		'StatusField'		=>	Array('Status'),

		'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item

		'TableName'			=>	TABLE_PREFIX.'Categories',
		'CustomDataTableName' => TABLE_PREFIX . 'CategoryCustomData',

		'TitlePresets'		=>	Array(
			'default'		=>	Array(	'new_status_labels'		=> Array('st'=>'!la_title_Adding_Category!'),
										'edit_status_labels'	=> Array('st'=>'!la_title_Editing_Category!'),
										'new_titlefield'		=> Array('st'=>'!la_title_New_Category!'),
								),
			'structure_list'	=>	Array(
				'prefixes' =>	Array('st_List', 'st.current'),
				'format' => "!la_title_Structure! - '#st.current_Name#'"
			),
			'structure_edit'	=>	Array(
				'prefixes' => Array('st'),
				'format' => "#st_status# '#st_titlefield#'",
			),

			'edit_content' => array('format' => '!la_EditingContent!'),

/*			'categories_edit'		=>	Array('prefixes' => Array('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_General!"),*/

		),

		'PermItemPrefix'	=>	'CATEGORY',
		'PermSection'		=>	Array('main' => 'CATEGORY:in-portal:structure', 'email' => 'in-portal:configemail'),

		'ListSQLs'			=>	Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'CategoryPermissionsCache ON '.TABLE_PREFIX.'CategoryPermissionsCache.CategoryId = %1$s.CategoryId',
			'-virtual' => 'SELECT %1$s.* %2$s FROM %1$s',
		),

		'SubItems'			=>	Array('content', 'page-revision'),

		'ListSortings'	=> 	Array(
			'' => Array(
							'ForcedSorting' => Array('Priority' => 'desc'),
							'Sorting' => Array('Name' => 'asc'),
					)
		),

		'CalculatedFields'	=>	Array(
			''	=>	Array(
					'CurrentSort'	=>	"REPLACE(ParentPath, CONCAT('|', ".'%1$s'.".CategoryId, '|'), '')",
				),
			'-virtual' => Array (),
		),

		'Fields' 			=> 	Array (
            'CategoryId'				=>	Array('type' => 'int', 'not_null' => 1,'default' => 0),
            'Type'						=>	Array (
		    	'type' => 'int',
		    	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Virtual', 2 => 'la_opt_Template'), 'use_phrases' => 1,
		    	'not_null' => 1,'default' => 1
		    ),
		    'SymLinkCategoryId'			=>	Array ('type' => 'int', 'default' => NULL),
            'ParentId'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'not_null' => 1,'default' => 0, 'required'=>1),
            'Name'						=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'required' => 1, 'default' => ''),
            'Filename'					=>	Array('type' => 'string', 'not_null' => 1, 'default' => '', 'required' => 1),
			'AutomaticFilename'			=>	Array('type' => 'int', 'not_null' => 1, 'default' => 1),
            'Description'				=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => null),
            'CreatedOn'					=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
            'EditorsPick'				=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
            'Status'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled' ), 'use_phrases' => 1, 'not_null' => 1,'default' => 1),
            'Priority'					=>	Array('type' => 'int', 'not_null' => 1, 'formatter' => 'kOptionsFormatter', 'options' => array(), 'required' => 1, 'default' => 0),
            'MetaKeywords'				=>	Array('type' => 'string', 'default' => null),
            'CachedDescendantCatsQty'	=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
            'CachedNavbar'				=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => null),
            'CreatedById'				=>	Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'options' => Array(USER_ROOT => 'root', USER_GUEST => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'Users WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Username', 'default' => NULL),
            'ResourceId'				=>	Array('type' => 'int', 'default' => null),
            'ParentPath'				=>	Array('type' => 'string', 'default' => null),
		    'TreeLeft'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'TreeRight'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'NamedParentPath'			=>	Array('type' => 'string', 'default' => null),
			'NamedParentPathHash'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => 0),
            'MetaDescription'			=>	Array('type' => 'string', 'default' => null),
            'HotItem'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
            'NewItem'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
            'PopItem'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
            'Modified'					=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
            'ModifiedById'				=>	Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'options' => Array(USER_ROOT => 'root', USER_GUEST => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'Users WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Username', 'default' => NULL),
            'CachedTemplate'			=>	Array('type' => 'string', 'not_null' => 1, 'default' => ''),
			'CachedTemplateHash'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => 0),


            // fields from Pages
		    'Template'			=>	Array (
		    	'type' => 'string',
		    	'formatter' => 'kOptionsFormatter', 'options_sql' => '	SELECT	CONCAT(tf.Description, " (", TRIM(TRAILING ".des" FROM TRIM(TRAILING ".tpl" FROM FileName) ), ")") AS Title,
																					 	CONCAT(FilePath, "/", TRIM(TRAILING ".tpl" FROM FileName)) AS Value
																		FROM ' . TABLE_PREFIX . 'ThemeFiles AS tf
																		LEFT JOIN ' . TABLE_PREFIX . 'Themes AS t ON t.ThemeId = tf.ThemeId
																		WHERE (t.Enabled = 1) AND (tf.FileName NOT LIKE "%%.elm.tpl") AND (tf.FileName NOT LIKE "%%.des.tpl") AND (tf.FilePath = "/designs")',
				'option_key_field' => 'Value', 'option_title_field' => 'Title',
				'not_null' => 1, 'default' => CATEGORY_TEMPLATE_INHERIT
			),

			'UseExternalUrl'	=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'ExternalUrl'		=>	Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'UseMenuIconUrl'	=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'MenuIconUrl'		=>	Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'Title'				=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => '', 'not_null'=>1),
			'MenuTitle'			=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'default' => ''),
			'MetaTitle'			=>	Array('type' => 'string', 'default' => null),
			'IndexTools'		=>	Array('type' => 'string','default' => null),
			'IsMenu'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Show', 0 => 'la_Hide'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
			'Protected'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
	    	'FormId'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter',
		    												'options' => array('' => ''),
															'options_sql' => 'SELECT Title, FormId FROM '.TABLE_PREFIX.'Forms ORDER BY Title',
															'option_key_field' => 'FormId', 'option_title_field' => 'Title', 'default' => NULL),
			'FormSubmittedTemplate'	=>	Array('type' => 'string', 'default' => null),
			'FriendlyURL'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'ThemeId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

			'EnablePageCache' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'OverridePageCacheKey' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'PageCacheKey' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'PageExpiration' => Array ('type' => 'int', 'default' => NULL),
			'LiveRevisionNumber' => Array ('type' => 'int', 'not_null' => 1, 'default' => 1),
			'DirectLinkEnabled' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 1
			),
			'DirectLinkAuthKey' => Array ('type' => 'string', 'max_len' => 20, 'not_null' => 1, 'default' => '')
        ),

		'VirtualFields'		=>	Array(
			'CurrentSort'	=>	Array('type' => 'string', 'default' => ''),
			'IsNew'			=>	Array('type' => 'int', 'default' => 0),
			'OldPriority'	=>	Array('type' => 'int', 'default' => 0),
		),

		'Grids'	=> Array(
			'Default'		=>	Array(
				'Icons' => Array(1 => 'icon16_folder.gif', 0 => 'icon16_folder-red.gif'),
				'Fields' => Array(
					'CategoryId' => Array ('title'=>'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 55),
					'Name' => Array ('title'=>'column:la_fld_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter', 'width' => 250),
					'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 170),
					'Template' => Array ('title' => 'column:la_fld_TemplateType', 'filter_block' => 'grid_options_filter', 'width' => 220),
					'IsMenu' => Array ('title' => 'la_col_Visible', 'filter_block' => 'grid_options_filter', 'width' => 70),
					'Path' => Array ('title'=>'la_col_Path', 'data_block' => 'page_entercat_td', 'filter_block' => 'grid_like_filter' ),
					'Protected' => Array ('filter_block' => 'grid_options_filter', 'width' => 100),
				),
			),

			'Radio'		=>	Array(
				'Icons' => Array(1 => 'icon16_folder.gif', 0 => 'icon16_folder-red.gif'),
				'Selector' => 'radio',
				'Fields' => Array(
					'CategoryId' => Array ('title'=>'column:la_fld_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 55),
					'Name' => Array ('title'=>'column:la_fld_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter', 'width' => 250),
					'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 170),
					'Template' => Array ('title' => 'column:la_fld_TemplateType', 'filter_block' => 'grid_options_filter', 'width' => 220),
					'IsMenu' => Array ('title' => 'la_col_Visible', 'filter_block' => 'grid_options_filter', 'width' => 70),
					'Path' => Array ('title'=>'la_col_Path', 'data_block' => 'page_entercat_td', 'filter_block' => 'grid_like_filter' ),
					'Protected' => Array ('filter_block' => 'grid_options_filter', 'width' => 100),
				),
			),

			'AllPages'		=>	Array(
				'Icons' => Array(1 => 'icon16_folder.gif', 0 => 'icon16_folder-red.gif'),
				'Fields' => Array(
					'CategoryId' => Array ('title'=>'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 55),
					'Name' => Array ('title'=>'column:la_fld_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter', 'width' => 250),
					'Path' => Array ('title'=>'la_col_Path', 'data_block' => 'page_path_td', 'sort_field' => 'CachedNavbar', 'filter_block' => 'grid_like_filter' ),
					'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 170),
					'Template' => Array ('title' => 'column:la_fld_TemplateType', 'filter_block' => 'grid_options_filter', 'width' => 220),
					'IsMenu' => Array ('title' => 'la_col_Visible', 'filter_block' => 'grid_options_filter', 'width' => 70),
					'Protected' => Array ('filter_block' => 'grid_options_filter', 'width' => 100),
				),
			),
		),

		'ConfigMapping' => 	Array(
			'PerPage'				=>	'Perpage_Category',
			'ShortListPerPage'		=>	'Perpage_Category_Short',
			'DefaultSorting1Field'	=>	'Category_Sortfield',
			'DefaultSorting2Field'	=>	'Category_Sortfield2',
			'DefaultSorting1Dir'	=>	'Category_Sortorder',
			'DefaultSorting2Dir'	=>	'Category_Sortorder2',
		),
	);