<?php
/**
* @version	$Id: constants.php 15421 2012-06-29 13:06:20Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	// item statuses
	define('STATUS_DISABLED', 0);
	define('STATUS_ACTIVE', 1);
	define('STATUS_PENDING', 2);
	define('STATUS_PENDING_EDITING', -2);

	// sections
	define('stTREE', 1);
	define('stTAB', 2);

	define('smHIDE', 0); // always hide section from tree
	define('smNORMAL', 1); // show section even, if they were marked as smDEBUG or smSUPER_ADMIN before
	define('smDEBUG', 2); // show section in debug mode only
	define('smSUPER_ADMIN', 4); // show section in super admin & debug mode

	// permission types
	define('ptCATEGORY', 	0);
	define('ptSYSTEM', 		1);

	define('EDIT_MARK', '&|edit|&'); // replace this sequence inside filters to SID[_main_wid]

	$application =& kApplication::Instance();
	$spacer_url = $application->BaseURL().'core/admin_templates/img/spacer.gif';
	define('SPACER_URL', $spacer_url);

	if (!$application->isAdmin) {
		// don't show debugger buttons on front (if not overridden in "debug.php")
		kUtil::safeDefine('DBG_TOOLBAR_BUTTONS', 0);
	}

	// common usage regular expressions
	define('REGEX_EMAIL_USER', '[-a-zA-Z0-9!\#$%&*+\/=?^_`{|}~.]+');
	define('REGEX_EMAIL_DOMAIN', '[a-zA-Z0-9]{1}[-.a-zA-Z0-9_]*\.[a-zA-Z]{2,6}');
	define('ALLOW_DEFAULT_SETTINGS', '_USE_DEFAULT_USER_DATA_'); //Allow persistent vars to take data from default user's persistent data

	class ChangeLog {
		const CREATE = 1;
		const UPDATE = 2;
		const DELETE = 3;
	}

	// Separator for ValueList fields
	define('VALUE_LIST_SEPARATOR', '||');

	// template editing modes
	define('EDITING_MODE_BROWSE', 1); // no changes, front-end as users see it
	define('EDITING_MODE_CONTENT', 2); // content blocks + phrase editing
	define('EDITING_MODE_DESIGN', 3); // all other blocks

	class ScheduledTask {
		const TYPE_USER = 1;
		const TYPE_SYSTEM =  2;

		const LAST_RUN_SUCCEEDED = 1;
		const LAST_RUN_FAILED = 0;
		const LAST_RUN_RUNNING = 2;
	}

	// place for product file uploads (sort of "/system/images" but for all other files)
	define('ITEM_FILES_PATH', WRITEBALE_BASE . '/downloads/');

	class MailingList {
		const NOT_PROCESSED = 1;
		const PARTIALLY_PROCESSED = 2;
		const PROCESSED = 3;
		const CANCELLED = 4;
	}

	// theme file statuses (related to structure creation process)
	define('SMS_MODE_AUTO', 1);
	define('SMS_MODE_FORCE', 2);

	// Means, that actual category Template field value should inherited from parent category
	define('CATEGORY_TEMPLATE_INHERIT', '#inherit#');

	define('REWRITE_MODE_BUILD', 1);
	define('REWRITE_MODE_PARSE', 2);

	define('SESSION_LOG_ACTIVE', 0);
	define('SESSION_LOG_LOGGED_OUT', 1);
	define('SESSION_LOG_EXPIRED', 2);

	class LoginResult {
		const OK = 0;
		const INVALID_LOGIN = 1;
		const INVALID_PASSWORD = 2;
		const BANNED = 3;
		const NO_PERMISSION = 4;
	}

	define('DESTINATION_TYPE_COUNTRY', 1);
	define('DESTINATION_TYPE_STATE', 2);

	class SubmissionFormField {
		const VISIBILITY_EVERYONE = 1;
		const VISIBILITY_UNREGISTERED = 2;

		const COMMUNICATION_ROLE_NAME = 1;
		const COMMUNICATION_ROLE_EMAIL = 2;
		const COMMUNICATION_ROLE_SUBJECT = 3;
		const COMMUNICATION_ROLE_BODY = 4;
	}

	// form submission statuses
	define('SUBMISSION_REPLIED', 1);		// submission was replied by admin
	define('SUBMISSION_NOT_REPLIED', 2);	// submission has no client replies (no messages at all)
	define('SUBMISSION_NEW_EMAIL', 3);		// submission have new reply/email from client
	define('SUBMISSION_BOUNCE', 4);			// submission have bounce from client

	// submission log statuses
	define('SUBMISSION_LOG_SENT', 1);
	define('SUBMISSION_LOG_BOUNCE', 2);
	define('SUBMISSION_LOG_REPLIED', 1);

	define('SUBMISSION_LOG_ATTACHMENT_PATH', WRITEBALE_BASE . '/user_files/submission_log/');

	define('TIMENOW', adodb_mktime()); // for faster message processing

	// site domains
	define('SITE_DOMAIN_REDIRECT_CURRENT', 1);
	define('SITE_DOMAIN_REDIRECT_EXTERNAL', 2);

	class EmailEvent {
		const EVENT_TYPE_FRONTEND = 0;
		const EVENT_TYPE_ADMIN = 1;

		const ADDRESS_TYPE_EMAIL = 1;
		const ADDRESS_TYPE_USER = 2;
		const ADDRESS_TYPE_GROUP = 3;

		const RECIPIENT_TYPE_TO = 1;
		const RECIPIENT_TYPE_CC = 2;
		const RECIPIENT_TYPE_BCC = 3;
	}

	define('PAGE_TYPE_VIRTUAL', 1);
	define('PAGE_TYPE_TEMPLATE', 2);

	define('CONTENT_LASTAUTOSAVE_UPDATE_INTERVAL', 5 * 60); // 5 minutes
	define('CONTENT_LASTAUTOSAVE_REFRESH_INTERVAL', 20); // 20 seconds

	define('hBEFORE', 1);
	define('hAFTER', 2);

	class UserType {
		const USER = 0;
		const ADMIN = 1;
	}

	// selectors
	define('STYLE_BASE', 1);
	define('STYLE_BLOCK', 2);

	class Language {
		const SYNCHRONIZE_TO_OTHERS = 1;
		const SYNCHRONIZE_FROM_OTHERS = 2;
		const SYNCHRONIZE_DEFAULT = '|1|2|';

		const PHRASE_TYPE_FRONT = 0;
		const PHRASE_TYPE_ADMIN = 1;
		const PHRASE_TYPE_COMMON = 2;
	}

	class PromoBlockType {
		const INTERNAL = 1;
		const EXTERNAL = 2;
	}

	class StorageEngine {
		const HASH = 1;
		const TIMESTAMP = 2;

		const PS_DATE_TIME = 'DATE-TIME';
		const PS_PREFIX = 'PREFIX';
		const PS_USER = 'USER';
	}

class CategoryPermissionRebuild {
	const MANUAL = 1;
	const SILENT = 2;
	const AUTOMATIC = 3;
}
