<?php
/**
* @version	$Id: sections_config.php 15471 2012-07-23 17:10:50Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'core-sections',
		'EventHandlerClass' => Array ('class' => 'SiteConfigEventHandler', 'file' => 'site_config_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'SiteConfigTagProcessor', 'file' => 'site_config_tp.php', 'build_event' => 'OnBuild'),

		'Hooks' => Array (
			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => '*',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnApplySiteConfigChanges',
			),
		),

		'Sections' => Array (
			'in-portal:site' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'struct',
				'label'			=>	'la_tab_Site_Structure',
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	1,
				'container'		=>	true,
				'type'			=>	stTREE,
				'SectionPrefix' => 'c',
			),

			'in-portal:browse_site'	=> Array(
				'parent'		=>	'in-portal:site',
				'icon'			=>	'browse-site',
				'label'			=>	'la_tab_BrowsePages',
				'url'			=>	Array('t' => 'index', 'index_file' => '../index.php', 'admin' => 1, 'pass' => 'm'),
				'permissions'	=>	Array('view'),
				'priority'		=>	1,
				'type'			=>	stTREE,
			),

			'in-portal:browse' => Array (
				'parent'		=>	'in-portal:site',
				'icon'			=>	'structure', // 'catalog'
				'label'			=>	'la_title_Structure', // 'la_tab_Browse',
				'url'			=>	Array ('t' => 'catalog/catalog', 'pass' => 'm'),
				'late_load'		=>	Array ('t' => 'categories/xml/tree_categories', 'pass' => 'm', 'm_cat_id' => 0),
				'onclick'		=>	'checkCatalog(0)',
				'permissions'	=>	Array ('view'),
				'priority'		=>	2,
				'type'			=>	stTREE,
			),

			'in-portal:reviews' => Array (
				'parent'		=>	'in-portal:site',
				'icon'			=>	'reviews',
				'label'			=>	'la_tab_Reviews',
				'url'			=>	Array ('t' => 'reviews/reviews', 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	3.5,
				'type'			=>	stTREE,
			),

			'in-portal:users' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'user_management',
				'label'			=>	'la_tab_Community',
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	3,
				'container'		=>	true,
				'type'			=>	stTREE,
				'SectionPrefix' => 'u',
			),

			'in-portal:user_groups' => Array (
				'parent'		=>	'in-portal:users',
				'icon'			=>	'usergroups',
				'label'			=>	'la_tab_User_Groups',
				'url'			=>	Array ('t' => 'groups/groups_list', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'add', 'edit', 'delete', 'advanced:send_email', 'advanced:manage_permissions'),
				'SectionPrefix' => 'g',
				'priority'		=>	3,
				'type'			=>	stTREE,
			),

			// "Help" section
			/*
			'in-portal:help' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'help',
				'label'			=>	'la_tab_Help',
				'url'			=>	Array ('index_file' => 'help/manual.pdf', 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	7,
				'type'			=>	stTREE,
			),
			*/

			// "Summary & Logs" section
			'in-portal:reports' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'summary_logs',
				'label'			=>	'la_tab_Reports',
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	4,
				'container'		=>	true,
				'type'			=>	stTREE,
				'SectionPrefix' => 'adm',
			),

			/*'in-portal:log_summary' => Array (
				'parent'		=>	'in-portal:reports',
				'icon'			=>	'summary',
				'label'			=>	'la_tab_Summary',
				'url'			=>	Array ('index_file' => 'logs/summary.php', 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	1,
				'type'			=>	stTREE,
			),*/

			// "Configuration" section
			'in-portal:system' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'conf',
				'label'			=>	'la_tab_Sys_Config',
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	5,
				'container'		=>	true,
				'type'			=>	stTREE,
				'SectionPrefix' => 'adm',
			),

			'in-portal:website_setting_folder' => Array (
				'parent'		=>	'in-portal:system',
				'icon'			=>	'conf_website',
				'label'			=>	'la_title_Website',
				'use_parent_header' => 1,
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	1,
				'container'		=>	true,
				'type'			=>	stTREE,
				'SectionPrefix' => 'adm',
			),

			'in-portal:configure_general' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_general',
				'label'			=>	'la_tab_General',
				'url'			=>	Array ('t' => 'config/config_universal', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'add', 'edit'),
				'priority'		=>	1,
				'type'			=>	stTREE,
			),

			'in-portal:configure_advanced' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_advanced',
				'label'			=>	'la_title_Advanced',
				'url'			=>	Array ('t' => 'config/config_universal', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'add', 'edit'),
				'priority'		=>	2,
				'type'			=>	stTREE,
			),

			// "Tools" section
			'in-portal:tools' => Array (
				'parent'		=>	'in-portal:root',
				'icon'			=>	'tools',
				'label'			=>	'la_tab_Tools',
				'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	6,
				'container'		=>	true,
				'type'			=>	stTREE,
				'SectionPrefix' => 'adm',
			),

			'in-portal:backup' => Array (
				'parent'		=>	'in-portal:tools',
				'icon'			=>	'backup',
				'label'			=>	'la_tab_Backup',
				'url'			=>	Array ('t' => 'tools/backup1', 'section' => 'in-portal:configure_general', 'module' => 'In-Portal',  'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	1,
				'type'			=>	stTREE,
			),

			'in-portal:restore' => Array (
				'parent'		=>	'in-portal:tools',
				'icon'			=>	'restore',
				'label'			=>	'la_tab_Restore',
				'url'			=>	Array ('t' => 'tools/restore1', 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	2,
				'type'			=>	stTREE,
			),

			'in-portal:main_import' => Array (
				'parent'		=>	'in-portal:tools',
				'icon'			=>	'import_data',
				'label'			=>	'la_tab_ImportData',
				'url'			=>	Array ('t' => 'tools/import1'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	3,
				'type'			=>	stTREE,
			),

			'in-portal:sql_query' => Array (
				'parent'		=>	'in-portal:tools',
				'icon'			=>	'query_database',
				'label'			=>	'la_tab_QueryDB',
				'url'			=>	Array ('t' => 'tools/sql_query', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'edit'),
				'priority'		=>	4,
				'type'			=>	stTREE,
			),

			'in-portal:server_info' => Array (
				'parent'		=>	'in-portal:tools',
				'icon'			=>	'server_info',
				'label'			=>	'la_tab_ServerInfo',
				'url'			=>	Array ('t' => 'tools/server_info', 'pass' => 'm'),
				'permissions'	=>	Array ('view'),
				'priority'		=>	5,
				'type'			=>	stTREE,
			),
		),
	);