<?php
/**
* @version	$Id: options_formatter.php 15109 2012-02-10 09:00:00Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class kOptionsFormatter extends kFormatter {

	/**
	 * Formats value of a given field
	 *
	 * @param string $value
	 * @param string $field_name
	 * @param kDBItem|kDBList $object
	 * @param string $format
	 * @return string
	 */
	function Format($value, $field_name, &$object, $format=null)
	{
		if ( is_null($value) ) {
			return '';
		}

		$field_options = $object->GetFieldOptions($field_name);
		if (!array_key_exists('options', $field_options) || !is_array($field_options['options'])) {
			trigger_error('Options not defined for <strong>'.$object->Prefix.'</strong> field <strong>'.$field_name.'</strong>', E_USER_WARNING);
			return $value;
		}

		$options = $field_options['options'];
		$use_phrases = array_key_exists('use_phrases', $field_options) ? $field_options['use_phrases'] : false;

		if (strpos($value, '|') !== false) {
			// multiple checkboxes OR multiselect
			$values = Array ();
			$values_unsorted = explode('|', substr($value, 1, -1) );

			// 1. sort values using options order from unit config
			$key_indexes = array_keys($options);
			foreach ($values_unsorted as $value) {
				$values[ array_search($value, $key_indexes) ] = $value;
			}
			ksort($values);

			// 2. convert values to titles
			$labels = Array ();
			foreach ($values as $value) {
				$label = $this->formatOption($value, $options, $use_phrases);
				if ($label) {
					$labels[] = $label;
				}
			}

			return implode($format, $labels);
		}
		else {
			return $this->formatOption($value, $options, $use_phrases);
		}
	}

	function formatOption($value, $options, $use_phrases = true)
	{
		$label = getArrayValue($options, $value);
		if ($label !== false) {
			// option_id found in options array
			return $use_phrases ? $this->Application->Phrase($label) : $label;
		}
		else {
			// option_id not found
			return "$value" == "0" ? '' : $value;
		}
	}

	/**
	 * Performs basic type validation on form field value
	 *
	 * @param mixed $value
	 * @param string $field_name
	 * @param kDBItem $object
	 * @return mixed
	 * @access public
	 */
	public function Parse($value, $field_name, &$object)
	{
		if ( $value == '' ) {
			return NULL;
		}

		$found = $option_key = false;
		$options = $object->GetFieldOptions($field_name);
		$use_phrases = getArrayValue($options, 'use_phrases');

		foreach ($options['options'] as $option_key => $option_value) {
			if ( $use_phrases ) {
				$option_value = $this->Application->Phrase($option_value);
			}

			if ( "$option_value" === "$value" ) {
				$found = true;
				break;
			}
		}

		return $found ? $option_key : $value;
	}
}