<?php
/**
 * @version    $Id: configuration_validator.php 15471 2012-07-23 17:10:50Z alex $
 * @package    In-Portal
 * @copyright    Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
 * @license      GNU/GPL
 * In-Portal is Open Source software.
 * This means that this software may have been modified pursuant
 * the GNU General Public License, and as distributed it includes
 * or is derivative of works licensed under the GNU General Public License
 * or other free or open source software licenses.
 * See http://www.in-portal.org/license for copyright notices and details.
 */

defined('FULL_PATH') or die('restricted access!');

class ConfigurationValidator extends kValidator {

	/**
	 * Set's field error, if pseudo passed not found then create it with message text supplied.
	 * Don't overwrite existing pseudo translation.
	 *
	 * @param string $field
	 * @param string $pseudo
	 * @param string $error_label
	 * @param Array $error_params
	 *
	 * @return bool
	 * @access public
	 */
	public function SetError($field, $pseudo, $error_label = null, $error_params = null)
	{
		if ( !parent::SetError($field, $pseudo, $error_label, $error_params) ) {
			// this field already has an error -> don't overwrite it
			return false;
		}

		if ( $field == 'VariableValue' ) {
			$item_prefix = $this->dataSource->getPrefixSpecial();

			$list_errors = $this->Application->GetVar('errors_' . $item_prefix, Array ());
			$list_errors[$this->dataSource->GetDBField('VariableName')] = $this->GetErrorMsg($field);
			$this->Application->SetVar('errors_' . $item_prefix, $list_errors);
		}

		return true;
	}
}
