<?php
	$settings = Array (
		'WebsitePath' => Array ('type' => 'text', 'title' => 'Web Path to Installation', 'section' => 'Misc', 'required' => 1, 'default' => ''),
		'WriteablePath' => Array ('type' => 'text', 'title' => 'Path to Writable folder', 'section' => 'Misc', 'required' => 1, 'default' => '/system'),
		'RestrictedPath' => Array ('type' => 'text', 'title' => 'Path to Restricted folder', 'section' => 'Misc', 'required' => 1, 'default' => '/system/.restricted'),
		'AdminDirectory' => Array ('type' => 'text', 'title' => 'Path to Admin folder', 'section' => 'Misc', 'default' => '/admin'),
		'AdminPresetsDirectory' => Array ('type' => 'text', 'title' => 'Path to Admin Interface Presets folder', 'section' => 'Misc', 'default' => '/admin'),
		'ApplicationClass' => Array ('type' => 'text', 'title' => 'Name of Base Application Class', 'section' => 'Misc', 'default' => 'kApplication'),
		'ApplicationPath' => Array ('type' => 'text', 'title' => 'Path to Base Application Class file', 'section' => 'Misc', 'default' => '/core/kernel/application.php'),
		'CacheHandler' => Array ('type' => 'select', 'title' => 'Output Caching Engine', 'section' => 'Misc', 'default' => 'Fake'),
		'MemcacheServers' => Array ('type' => 'text', 'title' => 'Location of Memcache Servers', 'section' => 'Misc', 'default' => 'localhost:11211'),
		'CompressionEngine' => Array ('type' => 'select', 'title' => 'CSS/JS Compression Engine', 'section' => 'Misc', 'default' => ''),
		'WebsiteCharset' => Array ('type' => 'text', 'title' => 'Website Charset', 'section' => 'Misc', 'required' => 1, 'default' => 'utf-8'),
	);

	$settings['CacheHandler']['options'] = $this->toolkit->getWorkingCacheHandlers();
	$settings['CompressionEngine']['options'] = $this->toolkit->getWorkingCompressionEngines();

	$row_class = 'table-color2';

	foreach ($settings as $config_var => $output_params) {
		$row_class = $row_class == 'table-color1' ? 'table-color2' : 'table-color1';
		?>
		<tr class="<?php echo $row_class; ?>">
			<td class="text">
				<b><?php echo ($output_params['title'] ? $output_params['title'] : $config_var) . (isset($output_params['required']) ? ' <span class="error">*</span>' : ''); ?>:</b>
			</td>
			<td>
				<?php
					$config_value =  $this->toolkit->getSystemConfig($output_params['section'], $config_var, $output_params['default']);

					if ( $output_params['type'] == 'text' ) {
						echo '<input type="text" name="system_config[' . $output_params['section'] . '][' . $config_var . ']" value="' . $config_value . '" class="text" style="width: 200px;"/>';
					}
					else {
						echo '<select name="system_config[' . $output_params['section'] . '][' . $config_var . ']">';

						if ( $output_params['options'][$config_value] == 'None' ) {
							$tmp_values = array_keys($output_params['options']);

							if ( count($tmp_values) > 1 ) {
								$config_value = $tmp_values[1];
							}
						}

						foreach($output_params['options'] as $option_key => $option_value) {
							$selected = $option_key == $config_value ? ' selected' : '';
							echo '<option value="' . $option_key . '"' . $selected . '>' . $option_value . '</option>';
						}

						echo '</select>';
					}
				?>
			</td>
		</tr>
		<?php
	}
?>
