<inp2:m_DefineElement name="cf_Config_Site_Time_value">
	<script type="text/javascript">
		var $timezones = {
			'Africa': ['Africa/Abidjan', 'Africa/Accra', 'Africa/Addis_Ababa', 'Africa/Algiers', 'Africa/Asmara', 'Africa/Asmera', 'Africa/Bamako', 'Africa/Bangui', 'Africa/Banjul', 'Africa/Bissau', 'Africa/Blantyre', 'Africa/Brazzaville', 'Africa/Bujumbura', 'Africa/Cairo', 'Africa/Casablanca', 'Africa/Ceuta', 'Africa/Conakry', 'Africa/Dakar', 'Africa/Dar_es_Salaam', 'Africa/Djibouti', 'Africa/Douala', 'Africa/El_Aaiun', 'Africa/Freetown', 'Africa/Gaborone', 'Africa/Harare', 'Africa/Johannesburg', 'Africa/Kampala', 'Africa/Khartoum', 'Africa/Kigali', 'Africa/Kinshasa', 'Africa/Lagos', 'Africa/Libreville', 'Africa/Lome', 'Africa/Luanda', 'Africa/Lubumbashi', 'Africa/Lusaka', 'Africa/Malabo', 'Africa/Maputo', 'Africa/Maseru', 'Africa/Mbabane', 'Africa/Mogadishu', 'Africa/Monrovia', 'Africa/Nairobi', 'Africa/Ndjamena', 'Africa/Niamey', 'Africa/Nouakchott', 'Africa/Ouagadougou', 'Africa/Porto-Novo', 'Africa/Sao_Tome', 'Africa/Timbuktu', 'Africa/Tripoli', 'Africa/Tunis', 'Africa/Windhoek'],
			'America': ['America/Adak', 'America/Anchorage', 'America/Anguilla', 'America/Antigua', 'America/Araguaina', 'America/Argentina/Buenos_Aires', 'America/Argentina/Catamarca', 'America/Argentina/ComodRivadavia', 'America/Argentina/Cordoba', 'America/Argentina/Jujuy', 'America/Argentina/La_Rioja', 'America/Argentina/Mendoza', 'America/Argentina/Rio_Gallegos', 'America/Argentina/Salta', 'America/Argentina/San_Juan', 'America/Argentina/San_Luis', 'America/Argentina/Tucuman', 'America/Argentina/Ushuaia', 'America/Aruba', 'America/Asuncion', 'America/Atikokan', 'America/Atka', 'America/Bahia', 'America/Barbados', 'America/Belem', 'America/Belize', 'America/Blanc-Sablon', 'America/Boa_Vista', 'America/Bogota', 'America/Boise', 'America/Buenos_Aires', 'America/Cambridge_Bay', 'America/Campo_Grande', 'America/Cancun', 'America/Caracas', 'America/Catamarca', 'America/Cayenne', 'America/Cayman', 'America/Chicago', 'America/Chihuahua', 'America/Coral_Harbour', 'America/Cordoba', 'America/Costa_Rica', 'America/Cuiaba', 'America/Curacao', 'America/Danmarkshavn', 'America/Dawson', 'America/Dawson_Creek', 'America/Denver', 'America/Detroit', 'America/Dominica', 'America/Edmonton', 'America/Eirunepe', 'America/El_Salvador', 'America/Ensenada', 'America/Fort_Wayne', 'America/Fortaleza', 'America/Glace_Bay', 'America/Godthab', 'America/Goose_Bay', 'America/Grand_Turk', 'America/Grenada', 'America/Guadeloupe', 'America/Guatemala', 'America/Guayaquil', 'America/Guyana', 'America/Halifax', 'America/Havana', 'America/Hermosillo', 'America/Indiana/Indianapolis', 'America/Indiana/Knox', 'America/Indiana/Marengo', 'America/Indiana/Petersburg', 'America/Indiana/Tell_City', 'America/Indiana/Vevay', 'America/Indiana/Vincennes', 'America/Indiana/Winamac', 'America/Indianapolis', 'America/Inuvik', 'America/Iqaluit', 'America/Jamaica', 'America/Jujuy', 'America/Juneau', 'America/Kentucky/Louisville', 'America/Kentucky/Monticello', 'America/Knox_IN', 'America/La_Paz', 'America/Lima', 'America/Los_Angeles', 'America/Louisville', 'America/Maceio', 'America/Managua', 'America/Manaus', 'America/Marigot', 'America/Martinique', 'America/Matamoros', 'America/Mazatlan', 'America/Mendoza', 'America/Menominee', 'America/Merida', 'America/Mexico_City', 'America/Miquelon', 'America/Moncton', 'America/Monterrey', 'America/Montevideo', 'America/Montreal', 'America/Montserrat', 'America/Nassau', 'America/New_York', 'America/Nipigon', 'America/Nome', 'America/Noronha', 'America/North_Dakota/Center', 'America/North_Dakota/New_Salem', 'America/Ojinaga', 'America/Panama', 'America/Pangnirtung', 'America/Paramaribo', 'America/Phoenix', 'America/Port-au-Prince', 'America/Port_of_Spain', 'America/Porto_Acre', 'America/Porto_Velho', 'America/Puerto_Rico', 'America/Rainy_River', 'America/Rankin_Inlet', 'America/Recife', 'America/Regina', 'America/Resolute', 'America/Rio_Branco', 'America/Rosario', 'America/Santa_Isabel', 'America/Santarem', 'America/Santiago', 'America/Santo_Domingo', 'America/Sao_Paulo', 'America/Scoresbysund', 'America/Shiprock', 'America/St_Barthelemy', 'America/St_Johns', 'America/St_Kitts', 'America/St_Lucia', 'America/St_Thomas', 'America/St_Vincent', 'America/Swift_Current', 'America/Tegucigalpa', 'America/Thule', 'America/Thunder_Bay', 'America/Tijuana', 'America/Toronto', 'America/Tortola', 'America/Vancouver', 'America/Virgin', 'America/Whitehorse', 'America/Winnipeg', 'America/Yakutat', 'America/Yellowknife'],
			'Antarctica': ['Antarctica/Casey', 'Antarctica/Davis', 'Antarctica/DumontDUrville', 'Antarctica/Macquarie', 'Antarctica/Mawson', 'Antarctica/McMurdo', 'Antarctica/Palmer', 'Antarctica/Rothera', 'Antarctica/South_Pole', 'Antarctica/Syowa', 'Antarctica/Vostok'],
			'Arctic': ['Arctic/Longyearbyen'],
			'Asia': ['Asia/Aden', 'Asia/Almaty', 'Asia/Amman', 'Asia/Anadyr', 'Asia/Aqtau', 'Asia/Aqtobe', 'Asia/Ashgabat', 'Asia/Ashkhabad', 'Asia/Baghdad', 'Asia/Bahrain', 'Asia/Baku', 'Asia/Bangkok', 'Asia/Beirut', 'Asia/Bishkek', 'Asia/Brunei', 'Asia/Calcutta', 'Asia/Choibalsan', 'Asia/Chongqing', 'Asia/Chungking', 'Asia/Colombo', 'Asia/Dacca', 'Asia/Damascus', 'Asia/Dhaka', 'Asia/Dili', 'Asia/Dubai', 'Asia/Dushanbe', 'Asia/Gaza', 'Asia/Harbin', 'Asia/Ho_Chi_Minh', 'Asia/Hong_Kong', 'Asia/Hovd', 'Asia/Irkutsk', 'Asia/Istanbul', 'Asia/Jakarta', 'Asia/Jayapura', 'Asia/Jerusalem', 'Asia/Kabul', 'Asia/Kamchatka', 'Asia/Karachi', 'Asia/Kashgar', 'Asia/Kathmandu', 'Asia/Katmandu', 'Asia/Kolkata', 'Asia/Krasnoyarsk', 'Asia/Kuala_Lumpur', 'Asia/Kuching', 'Asia/Kuwait', 'Asia/Macao', 'Asia/Macau', 'Asia/Magadan', 'Asia/Makassar', 'Asia/Manila', 'Asia/Muscat', 'Asia/Nicosia', 'Asia/Novokuznetsk', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Oral', 'Asia/Phnom_Penh', 'Asia/Pontianak', 'Asia/Pyongyang', 'Asia/Qatar', 'Asia/Qyzylorda', 'Asia/Rangoon', 'Asia/Riyadh', 'Asia/Saigon', 'Asia/Sakhalin', 'Asia/Samarkand', 'Asia/Seoul', 'Asia/Shanghai', 'Asia/Singapore', 'Asia/Taipei', 'Asia/Tashkent', 'Asia/Tbilisi', 'Asia/Tehran', 'Asia/Tel_Aviv', 'Asia/Thimbu', 'Asia/Thimphu', 'Asia/Tokyo', 'Asia/Ujung_Pandang', 'Asia/Ulaanbaatar', 'Asia/Ulan_Bator', 'Asia/Urumqi', 'Asia/Vientiane', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yekaterinburg', 'Asia/Yerevan'],
			'Atlantic': ['Atlantic/Azores', 'Atlantic/Bermuda', 'Atlantic/Canary', 'Atlantic/Cape_Verde', 'Atlantic/Faeroe', 'Atlantic/Faroe', 'Atlantic/Jan_Mayen', 'Atlantic/Madeira', 'Atlantic/Reykjavik', 'Atlantic/South_Georgia', 'Atlantic/St_Helena', 'Atlantic/Stanley'],
			'Australia': ['Australia/ACT', 'Australia/Adelaide', 'Australia/Brisbane', 'Australia/Broken_Hill', 'Australia/Canberra', 'Australia/Currie', 'Australia/Darwin', 'Australia/Eucla', 'Australia/Hobart', 'Australia/LHI', 'Australia/Lindeman', 'Australia/Lord_Howe', 'Australia/Melbourne', 'Australia/North', 'Australia/NSW', 'Australia/Perth', 'Australia/Queensland', 'Australia/South', 'Australia/Sydney', 'Australia/Tasmania', 'Australia/Victoria', 'Australia/West', 'Australia/Yancowinna'],
			'Europe': ['Europe/Amsterdam', 'Europe/Andorra', 'Europe/Athens', 'Europe/Belfast', 'Europe/Belgrade', 'Europe/Berlin', 'Europe/Bratislava', 'Europe/Brussels', 'Europe/Bucharest', 'Europe/Budapest', 'Europe/Chisinau', 'Europe/Copenhagen', 'Europe/Dublin', 'Europe/Gibraltar', 'Europe/Guernsey', 'Europe/Helsinki', 'Europe/Isle_of_Man', 'Europe/Istanbul', 'Europe/Jersey', 'Europe/Kaliningrad', 'Europe/Kiev', 'Europe/Lisbon', 'Europe/Ljubljana', 'Europe/London', 'Europe/Luxembourg', 'Europe/Madrid', 'Europe/Malta', 'Europe/Mariehamn', 'Europe/Minsk', 'Europe/Monaco', 'Europe/Moscow', 'Europe/Nicosia', 'Europe/Oslo', 'Europe/Paris', 'Europe/Podgorica', 'Europe/Prague', 'Europe/Riga', 'Europe/Rome', 'Europe/Samara', 'Europe/San_Marino', 'Europe/Sarajevo', 'Europe/Simferopol', 'Europe/Skopje', 'Europe/Sofia', 'Europe/Stockholm', 'Europe/Tallinn', 'Europe/Tirane', 'Europe/Tiraspol', 'Europe/Uzhgorod', 'Europe/Vaduz', 'Europe/Vatican', 'Europe/Vienna', 'Europe/Vilnius', 'Europe/Volgograd', 'Europe/Warsaw', 'Europe/Zagreb', 'Europe/Zaporozhye', 'Europe/Zurich'],
			'Indian': ['Indian/Antananarivo', 'Indian/Chagos', 'Indian/Christmas', 'Indian/Cocos', 'Indian/Comoro', 'Indian/Kerguelen', 'Indian/Mahe', 'Indian/Maldives', 'Indian/Mauritius', 'Indian/Mayotte', 'Indian/Reunion'],
			'Pacific': ['Pacific/Apia', 'Pacific/Auckland', 'Pacific/Chatham', 'Pacific/Easter', 'Pacific/Efate', 'Pacific/Enderbury', 'Pacific/Fakaofo', 'Pacific/Fiji', 'Pacific/Funafuti', 'Pacific/Galapagos', 'Pacific/Gambier', 'Pacific/Guadalcanal', 'Pacific/Guam', 'Pacific/Honolulu', 'Pacific/Johnston', 'Pacific/Kiritimati', 'Pacific/Kosrae', 'Pacific/Kwajalein', 'Pacific/Majuro', 'Pacific/Marquesas', 'Pacific/Midway', 'Pacific/Nauru', 'Pacific/Niue', 'Pacific/Norfolk', 'Pacific/Noumea', 'Pacific/Pago_Pago', 'Pacific/Palau', 'Pacific/Pitcairn', 'Pacific/Ponape', 'Pacific/Port_Moresby', 'Pacific/Rarotonga', 'Pacific/Saipan', 'Pacific/Samoa', 'Pacific/Tahiti', 'Pacific/Tarawa', 'Pacific/Tongatapu', 'Pacific/Truk', 'Pacific/Wake', 'Pacific/Wallis', 'Pacific/Yap'],
			'Others': ['UTC']
		}

		function change_timezone_group($timezone_group) {
			var $target = $( jq('#<inp2:InputName name="VariableValue"/>, #config[<inp2:Field name="VariableName"/>]') );

			$target.hide().empty();
			$target.append('<option value=""></option>');

			if ($timezone_group == '') {
				return ;
			}

			for (var $i = 0; $i < $timezones[$timezone_group].length; $i++) {
				var $timezone = $timezones[$timezone_group][$i];
				var $selected = $timezone == $current_timezone ? ' selected="selected"' : '';

				$target.append('<option value="' + $timezone + '" ' + $selected + '>' + $timezone + '</option>');
			}

			$target.show();
		}

		var $current_timezone = '<inp2:Field name="VariableValue"/>';

		$(document).ready(
			function () {
				$('#timezone_group').change(
					function ($e) {
						change_timezone_group( $(this).val() );
					}
				);

				var $current_timezone_group = '';

				for (var $timezone_group in $timezones) {
					if (in_array($current_timezone, $timezones[$timezone_group])) {
						$current_timezone_group = $timezone_group;
						break;
					}
				}

				$('#timezone_group').val($current_timezone_group).change();
			}
		);
	</script>

	<select id="timezone_group">
		<option value=""></option>
		<option value="Africa">Africa</option>
		<option value="America">America</option>
		<option value="Antarctica">Antarctica</option>
		<option value="Arctic">Arctic</option>
		<option value="Asia">Asia</option>
		<option value="Atlantic">Atlantic</option>
		<option value="Australia">Australia</option>
		<option value="Europe">Europe</option>
		<option value="Indian">Indian</option>
		<option value="Pacific">Pacific</option>
		<option value="Others">Others</option>
	</select>
	&nbsp;&nbsp;

	<inp2:ConfigFormElement PrefixSpecial="$PrefixSpecial" field="VariableValue" blocks_prefix="config_edit_" element_type_field="ElementType" value_list_field="ValueList"/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="cf_MaxUserName_value">
	- <inp2:m_RenderElement name="cf_default_value" pass_params="1"/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="cf_HardMaintenanceTemplate_value">
	<inp2:m_RenderElement name="cf_default_value" pass_params="1"/>

	<input type="button" class="button" id="generate-maintenance-template" value="<inp2:m_Phrase name='la_btn_GeneratePage' html_escape='1'/>"/>

	<script type="text/javascript">
		$(document).ready(
			function () {
				$('#generate-maintenance-template').click(
					function ($e) {
						submit_event('conf', 'OnGenerateMaintenancePage');
					}
				);
			}
		);
	</script>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="inp_edit_field_caption" title="la_fld_{$field}" title_text="" hint_label="" NamePrefix="">
	<inp2:m_inc param="tab_index" by="1"/>
	<td class="label-cell">
		<inp2:m_RenderElement name="$caption_render_as" pass_params="1"/>
	</td>

	<script type="text/javascript">
		if (typeof(fields['<inp2:m_Param name="prefix" js_escape="1"/>']) == 'undefined') {
			fields['<inp2:m_Param name="prefix" js_escape="1"/>'] = new Object();
		}
		fields['<inp2:m_Param name="prefix" js_escape="1"/>']['<inp2:m_Param name="field" js_escape="1"/>'] = '<inp2:m_if check="m_Param" name="title"><inp2:m_phrase label="$title" js_escape="1"/></inp2:m_else/><inp2:m_Param name="title_text" js_escape="1"/></inp2:m_if>'
	</script>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="cf_DefaultEmailRecipients_value">
	<inp2:emailevents.{$PrefixSpecial}_PresetFormFields/>

	<style type="text/css">
		.grid-edit-table {
			border: 1px solid black;
			border-collapse: collapse;
		}

		.grid-edit-table td.label-cell, .grid-edit-table td.control-cell {
			background-image: none;
			border-right-width: 0px;
			width: auto;
		}
	</style>

	<table class="grid-edit-table">
		<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents.{$PrefixSpecial}" field="RecipientType" title="la_fld_RecipientType"/>
		<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents.{$PrefixSpecial}" field="RecipientAddress" title="la_fld_RecipientAddress" has_empty="1"/>
		<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents.{$PrefixSpecial}" field="RecipientName" title="la_fld_RecipientName" style="width: 318px;"/>
		<inp2:m_RenderElement name="inp_edit_minput" prefix="emailevents.{$PrefixSpecial}" field="Recipients" title="la_fld_Recipients" format="auto" style="width: 400px; height: 150px;"/>
	</table>

	<input type="hidden" name="<inp2:InputName field='VariableValue'/>" value="<inp2:Field field='VariableValue' />"/>

	<inp2:m_RenderElement name="email_recipients_js" prefix="emailevents.{$PrefixSpecial}" to_readonly="0"/>
</inp2:m_DefineElement>

<inp2:m_DefineElement name="cf_AllowAdminConsoleInterfaceChange_value">
	<inp2:m_RenderElement name="cf_default_value" pass_params="1"/> <label for="_cb_<inp2:InputName name='VariableValue'/>"><inp2:m_Phrase name="la_AllowChangingAdminConsoleInterface"/></label>
</inp2:m_DefineElement>