<?php
/**
* @version	$Id: modules_event_handler.php 15145 2012-03-04 09:04:08Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ModulesEventHandler extends kDBEventHandler {

		/**
		 * Builds item (loads if needed)
		 *
		 * Pattern: Prototype Manager
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		protected function OnItemBuild(kEvent $event)
		{
			$this->Application->SetVar($event->getPrefixSpecial(true) . '_id', $event->Special);

			parent::OnItemBuild($event);
		}

		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			$object = $event->getObject();
			/* @var $object kDBList */

			if ( $event->Special ) {
				$object->addFilter('current_module', '%1$s.Name = ' . $event->Special);
			}

			$object->addFilter('not_core', '%1$s.Name <> "Core"');
		}

		/**
		 * Define alternative event processing method names
		 *
		 * @return void
		 * @see kEventHandler::$eventMethods
		 * @access protected
		 */
		protected function mapEvents()
		{
			parent::mapEvents();

			$this->eventMethods['OnMassApprove'] = 'moduleAction';
			$this->eventMethods['OnMassDecline'] = 'moduleAction';
		}

		/**
		 * Disabled modules, but not In-Portal
		 *
		 * @param kEvent $event
		 */
		function moduleAction($event)
		{
			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				$event->status = kEvent::erFAIL;
				return ;
			}

			$object = $event->getObject( Array('skip_autoload' => true) );
			/* @var $object kDBItem */

			$ids = $this->StoreSelectedIDs($event);

			if (!$ids) {
				return ;
			}

			$updated = 0;
			$status_field = $this->Application->getUnitOption($event->Prefix, 'StatusField');
			$status_field = array_shift($status_field);

			foreach ($ids as $id) {
				$object->Load($id);

				if (in_array($id, Array ('In-Portal', 'Core')) || !$object->isLoaded()) {
					// don't allow any kind of manupulations with kernel
					// approve/decline on not installed module
					continue;
				}

				$enabled = $event->Name == 'OnMassApprove' ? 1 : 0;
				$object->SetDBField($status_field, $enabled);

				if (!$object->GetChangedFields()) {
					// no changes -> skip
					continue;
				}

				if ($object->Update()) {
					$updated++;

					$sql = 'UPDATE ' . TABLE_PREFIX . 'ImportScripts
							SET Status = ' . $enabled . '
 							WHERE Module = "' . $object->GetDBField('Name') . '"';
 					$this->Conn->Query($sql);
				}
				else {
					$event->status = kEvent::erFAIL;
					$event->redirect = false;
					break;
				}
			}

			if ( $updated ) {
				$event->status = kEvent::erSUCCESS;
				$event->SetRedirectParam('opener', 's');

				$this->Application->DeleteUnitCache();
				$this->Application->DeleteSectionCache();

				$event->SetRedirectParam('RefreshTree', 1);
			}
		}

		/**
		 * Occurs after list is queried
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterListQuery(kEvent $event)
		{
			parent::OnAfterListQuery($event);

			$modules_helper = $this->Application->recallObject('ModulesHelper');
			/* @var $modules_helper kModulesHelper */

			$new_modules = $modules_helper->getModules(kModulesHelper::NOT_INSTALLED);

			if ( !$new_modules || $this->Application->RecallVar('user_id') != USER_ROOT ) {
				return;
			}

			require_once FULL_PATH . '/core/install/install_toolkit.php';

			$toolkit = new kInstallToolkit();

			$object = $event->getObject();
			/* @var $object kDBList */

			foreach ($new_modules as $module) {
				$module_record = Array (
					'Name' => $toolkit->getModuleName($module),
					'Path' => 'modules/' . $module . '/',
					'Version' => $toolkit->GetMaxModuleVersion('modules/' . $module . '/'),
					'Loaded' => 0,
					'BuildDate' => null,
				);

				$object->addRecord($module_record);
			}
		}
	}