<?php
/**
* @version	$Id: change_log_eh.php 15145 2012-03-04 09:04:08Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ChangeLogEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standard permission mapping
	 *
	 * @return void
	 * @access protected
	 * @see kEventHandler::$permMapping
	 */
	protected function mapPermissions()
	{
		parent::mapPermissions();

		$permissions = Array (
			'OnEnableLog' => Array ('self' => 'view'),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Updates affected record count in session, when change log record is deleted
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemDelete(kEvent $event)
	{
		parent::OnAfterItemDelete($event);

		$object = $event->getObject();
		/* @var $object kDBItem */

		$sql = 'UPDATE ' . $this->Application->getUnitOption('session-log', 'TableName') . '
				SET AffectedItems = AffectedItems - 1
				WHERE SessionLogId = ' . $object->GetDBField('SessionLogId');
		$this->Conn->Query($sql);
	}

	/**
	 * Changes configuration value to enable log writing
	 *
	 * @param kEvent $event
	 */
	function OnEnableLog($event)
	{
		$this->Application->SetConfigValue('UseChangeLog', 1);
	}
}