<inp2:adm_SetPopupSize width="875" height="650"/>

<inp2:m_include t="incs/header"/>
<inp2:m_RenderElement name="combined_header" section="in-portal:configemail" prefix="emailevents" title_preset="email_message_edit_settings" tab_preset="Default"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
<tbody>
	<tr>
  	<td>
  		<script type="text/javascript">
				a_toolbar = new ToolBar();
				a_toolbar.AddButton( new ToolBarButton('select', '<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>', function() {
							submit_event('emailevents','<inp2:emailevents_SaveEvent/>');
						}
					) );

				a_toolbar.AddButton( new ToolBarButton('cancel', '<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>', function() {
							cancel_edit('emailevents','OnCancelEdit','<inp2:emailevents_SaveEvent/>','<inp2:m_Phrase label="la_FormCancelConfirmation" escape="1"/>');
						}
				 ) );


				a_toolbar.AddButton( new ToolBarButton('reset_edit', '<inp2:m_phrase label="la_ToolTip_Reset" escape="1"/>', function() {
						reset_form('emailevents', 'OnReset', '<inp2:m_Phrase label="la_FormResetConfirmation" escape="1"/>');
					}
			 	) );

				<inp2:m_if check="emailevents_IsSingle" inverse="inverse">
					a_toolbar.AddButton( new ToolBarSeparator('sep1') );
				</inp2:m_if>

				a_toolbar.AddButton( new ToolBarButton('prev', '<inp2:m_phrase label="la_ToolTip_Prev" escape="1"/>', function() {
							go_to_id('emailevents', '<inp2:emailevents_PrevId/>');
						}
				 ) );
				a_toolbar.AddButton( new ToolBarButton('next', '<inp2:m_phrase label="la_ToolTip_Next" escape="1"/>', function() {
							go_to_id('emailevents', '<inp2:emailevents_NextId/>');
						}
				 ) );

				a_toolbar.Render();

				<inp2:m_RenderElement name="edit_navigation" prefix="emailevents"/>
			</script>
		</td>

		<inp2:m_RenderElement name="ml_selector" prefix="emailevents"/>
	</tr>
</tbody>
</table>

<inp2:emailevents_SaveWarning name="grid_save_warning"/>
<inp2:emailevents_ErrorWarning name="form_error_warning"/>

<div id="scroll_container">
	<table class="edit-form">
		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="AllowChangingSender,CustomSender,SenderAddress,SenderAddressType,SenderName" title="la_section_SenderInfo"/>
			<inp2:m_if check="m_IsDebugMode">
				<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="AllowChangingSender"/>
			</inp2:m_if>

			<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingSender">
				<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="CustomSender"/>
				<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents" field="SenderAddress" has_empty="1"/>
				<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="SenderName" style="width: 318px;"/>
			<inp2:m_else/>
				<inp2:m_RenderElement name="inp_label" prefix="emailevents" field="CustomSender"/>
				<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents" field="SenderAddress" read_only="1"/>
				<inp2:m_RenderElement name="inp_label" prefix="emailevents" field="SenderName"/>
			</inp2:m_if>

		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="AllowChangingRecipient,CustomRecipient,RecipientType,RecipientAddress,RecipientAddressType,RecipientName,Recipients" title="la_section_RecipientsInfo"/>
			<inp2:m_if check="m_IsDebugMode">
				<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="AllowChangingRecipient"/>
			</inp2:m_if>

			<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
				<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="CustomRecipient"/>
			<inp2:m_else/>
				<inp2:m_RenderElement name="inp_label" prefix="emailevents" field="CustomRecipient"/>
				<inp2:emailevents_RemoveToRecipientType/>
			</inp2:m_if>

			<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="RecipientType"/>
			<inp2:m_RenderElement name="inp_edit_combo_target" prefix="emailevents" field="RecipientAddress" has_empty="1"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="RecipientName" style="width: 318px;"/>
			<inp2:m_RenderElement name="inp_edit_minput" prefix="emailevents" field="Recipients" format="auto" style="width: 400px; height: 150px;"/>

		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="Tag,Replacement,ReplacementTagsXML" title="la_section_ReplacementTags"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="Tag"/>
			<inp2:m_RenderElement name="inp_edit_textarea" prefix="emailevents" field="Replacement" control_options="{height: 60}"/>
			<inp2:m_RenderElement name="inp_edit_minput" prefix="emailevents" field="ReplacementTagsXML" title="la_fld_ReplacementTags" allow_move="0" format="#Tag# = #Replacement#" style="width: 600px; height: 100px;"/>

		<inp2:m_RenderElement name="subsection" prefix="emailevents" fields="Enabled,Description,FrontEndOnly,Type,Headers,Module,BindToSystemEvent" title="la_section_General"/>
			<inp2:m_if check="m_IsDebugMode">
				<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="Enabled"/>
			</inp2:m_if>

			<inp2:m_RenderElement name="inp_edit_textarea" prefix="emailevents" field="Description" control_options="{max_height: 50}"/>
			<inp2:m_RenderElement name="inp_edit_checkbox" prefix="emailevents" field="FrontEndOnly"/>
			<inp2:m_RenderElement name="inp_edit_radio" prefix="emailevents" field="Type"/>
			<inp2:m_RenderElement name="inp_edit_textarea" prefix="emailevents" field="Headers" title="la_fld_ExtraHeaders" control_options="{max_height: 50}"/>
			<inp2:m_RenderElement name="inp_edit_options" prefix="emailevents" field="Module" has_empty="1"/>
			<inp2:m_RenderElement name="inp_edit_box" prefix="emailevents" field="BindToSystemEvent" style="width: 200px;"/>
			<inp2:m_RenderElement name="inp_edit_filler"/>
	</table>
</div>

<inp2:m_if check="emailevents_FieldVisible" field="Recipients">
	<inp2:m_RenderElement name="email_recipients_js"/>
</inp2:m_if>

<script type="text/javascript">
	<inp2:m_if check="emailevents_FieldVisible" field="ReplacementTagsXML">
		// replacement tags
		ReplacementTagsXML.formatLine = function($record_index) {
			var $ret = MultiInputControl.prototype.formatLine.call(this, $record_index, false);

			if ($ret.length > 80) {
				$ret = $ret.substring(0, 80) + ' ...';
			}

			return this.htmlspecialchars($ret);
		}

		ReplacementTagsXML.compareRecords = function($record_a, $record_b) {
			return $record_a['Tag'] == $record_b['Tag'];
		}

		ReplacementTagsXML.registerControl('Tag', 'textbox', true);
		ReplacementTagsXML.registerControl('Replacement', 'textbox', true);
		ReplacementTagsXML.LoadValues();
	</inp2:m_if>

	// reflect custom sender & custom recipient radio button-dependent controls
	var $field_mask = '<inp2:emailevents_InputName name="#FIELD_NAME#" js_escape="1"/>';

	function reflectCustomSender() {
		var $default_sender = get_control($field_mask, 'CustomSender', '0').checked;
		var $type = get_control($field_mask, 'SenderAddressType');

		$type.disabled = $default_sender;
		get_control($field_mask, 'SenderAddress').disabled = $default_sender;
		get_control($field_mask, 'SenderName').disabled = $default_sender;

		$($type).change();
	}

	function reflectCustomRecipient() {
		<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
			var $default_recipient = get_control($field_mask, 'CustomRecipient', '0').checked;
			var $to_recipient = get_control($field_mask, 'RecipientType', <inp2:m_GetConst name="EmailEvent::RECIPIENT_TYPE_TO"/>);
		<inp2:m_else/>
			var $default_recipient = <inp2:m_if check="emailevents_Field" name="CustomRecipient" db="db" equals_to="0">true<inp2:m_else/>false</inp2:m_if>;
		</inp2:m_if>

		if ($default_recipient) {
			<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
				if ($to_recipient.checked) {
					get_control($field_mask, 'RecipientType', <inp2:m_GetConst name="EmailEvent::RECIPIENT_TYPE_CC"/>).checked = true;
				}
			</inp2:m_if>

			Recipients.registerControl('RecipientType', {'default': <inp2:m_GetConst name="EmailEvent::RECIPIENT_TYPE_CC"/>}, true);
		}
		else {
			Recipients.registerControl('RecipientType', {'default': <inp2:m_GetConst name="EmailEvent::RECIPIENT_TYPE_TO"/>}, true);
		}

		<inp2:m_if check="emailevents_IsEditable" check_field="AllowChangingRecipient">
			$to_recipient.disabled = $default_recipient;
		</inp2:m_if>
	}

	reflectCustomSender();
	reflectCustomRecipient();

	$(document).ready(
		function () {
			$("input[name='" + jq($field_mask.replace('#FIELD_NAME#', 'CustomSender')) + "']").click(reflectCustomSender);
			$("input[name='" + jq($field_mask.replace('#FIELD_NAME#', 'CustomRecipient')) + "']").click(reflectCustomRecipient);
		}
	);

	// enable all disabled controls before submit
	Application.setHook('emailevents:*',
		function () {
			$(':input:disabled').attr('disabled', '');
		}
	)
</script>

<inp2:m_include t="incs/footer"/>
