<?php
/**
* @version	$Id: cron.php 15229 2012-03-26 08:18:04Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

// Use either of lines above to invoke from cron:
// */1 * * * * wget http://<server_address>/tools/cron.php -O /dev/null > /dev/null 2>&1
// */1 * * * * /usr/bin/php /path/to/site/tools/cron.php > /dev/null 2>&1

$start = microtime(true);

define('CRON', 1);
define('ADMIN', 1);
define('FULL_PATH', realpath(dirname(__FILE__) . '/..'));
define('CMD_MODE', isset($argv) && count($argv) ? 1 : 0);

if ( CMD_MODE ) {
	define('DBG_SKIP_REPORTING', 1);
	$_SERVER['REQUEST_URI'] = 'CRON';
	$_SERVER['HTTP_USER_AGENT'] = 'gecko';
}

include_once(FULL_PATH . '/core/kernel/startup.php');

$application =& kApplication::Instance();
$application->Init();

// events from request are not processed, only predefined scheduled tasks
$application->EventManager->runScheduledTasks(true);

$application->Done();

$end = microtime(true);