<?php
/**
* @version	$Id: email_event_tp.php 15152 2012-03-04 09:26:24Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class EmailEventTagProcessor extends kDBTagProcessor
	{
		/**
		 * Removes "Enabled" column, when not in debug mode
		 *
		 * @param Array $params
		 */
		function ModifyUnitConfig($params)
		{
			if ( !$this->Application->isDebugMode() ) {
				$grids = $this->Application->getUnitOption($this->Prefix, 'Grids', Array ());
				/* @var $grids Array */

				foreach ($grids as $grid_name => $grid_data) {
					if ( array_key_exists('Enabled', $grid_data['Fields']) ) {
						unset($grids[$grid_name]['Fields']['Enabled']);
					}
				}

				$this->Application->setUnitOption($this->Prefix, 'Grids', $grids);
			}
		}

		/**
		 * Checks, that field can be edited
		 *
		 * @param Array $params
		 * @return string
		 */
		function IsEditable($params)
		{
			if ($this->Application->isDebugMode()) {
				return true;
			}

			$object = $this->getObject($params);
			/* @var $object kDBItem */

			return $object->GetDBField($params['check_field']);
		}

		/**
		 * To recipient read-only
		 *
		 * @param Array $params
		 * @return string
		 * @access protected
		 */
		protected function ToRecipientReadOnly($params)
		{
			return !$this->IsEditable(Array ('check_field' => 'AllowChangingRecipient'));
		}

		/**
		 * Removes "To" options from possible options in "RecipientType" field
		 *
		 * @param Array $params
		 */
		function RemoveToRecipientType($params)
		{
			$object = $this->getObject($params);
			/* @var $object kDBItem */

			$field_options = $object->GetFieldOptions('RecipientType');
			unset($field_options['options'][ EmailEvent::RECIPIENT_TYPE_TO ]);
			$object->SetFieldOptions('RecipientType', $field_options);
		}

		/**
		 * Restores "To" option in possible option list in "RecipientType" field
		 *
		 * @param Array $params
		 */
		function RestoreRecipientType($params)
		{
			$object = $this->getObject($params);
			/* @var $object kDBItem */

			$field_options = $object->GetFieldOptions('RecipientType');
			$virtual_fields = $this->Application->getUnitOption($this->Prefix, 'VirtualFields');
			$field_options['options'] = $virtual_fields['RecipientType']['options'];
			$object->SetFieldOptions('RecipientType', $field_options);
		}

	}