<?php
/**
* @version	$Id: country_state_eh.php 15145 2012-03-04 09:04:08Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class CountryStateEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnGetStatesJSON' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Applies edit picker filters
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			$object = $event->getObject();
			/* @var $object kDBList */

			if ( ($event->Special == 'selected') || ($event->Special == 'available') ) {
				$edit_picker_helper = $this->Application->recallObject('EditPickerHelper');
				/* @var $edit_picker_helper EditPickerHelper */

				$edit_picker_helper->applyFilter($event, 'Countries');

				// only countries
				$object->addFilter('type_filter', '%1$s.Type = ' . DESTINATION_TYPE_COUNTRY);
			}
		}

		/**
		 * Makes sure, that state country is always specified
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemCreate(kEvent $event)
		{
			parent::OnBeforeItemCreate($event);

			$this->_setRequired($event);
		}

		/**
		 * Makes sure, that state country is always specified
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemUpdate(kEvent $event)
		{
			parent::OnBeforeItemUpdate($event);

			$this->_setRequired($event);
		}

		/**
		 * Makes sure, that state country is always specified
		 *
		 * @param kEvent $event
		 */
		function _setRequired($event)
		{
			$object = $event->getObject();
			/* @var $object kDBItem */

			$field_options = $object->GetFieldOptions('IsoCode');

			if ($object->GetDBField('Type') == DESTINATION_TYPE_STATE) {
				$object->setRequired('StateCountryId');
				$field_options['unique'] = Array ('Type', 'StateCountryId');
			}
			else {
				$object->setRequired('StateCountryId', false);
				$field_options['unique'] = Array ('Type');
			}

			$object->SetFieldOptions('IsoCode', $field_options);
		}

		/**
		 * Don't allow to delete countries, that have states
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemDelete(kEvent $event)
		{
			parent::OnBeforeItemDelete($event);

			$object = $event->getObject();
			/* @var $object kDBItem */

			$cs_helper = $this->Application->recallObject('CountryStatesHelper');
			/* @var $cs_helper kCountryStatesHelper */

			if ( $cs_helper->CountryHasStates($object->GetDBField('IsoCode')) ) {
				$event->status = kEvent::erFAIL;
				return;
			}
		}

		/**
		 * Returns given country states in JSON format
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnGetStatesJSON(kEvent $event)
		{
			$event->status = kEvent::erSTOP;

			$cs_helper = $this->Application->recallObject('CountryStatesHelper');
			/* @var $cs_helper kCountryStatesHelper */

			$states = $cs_helper->getStates( (string)$this->Application->GetVar('country_iso') );
			echo json_encode($states);
		}
	}
